/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.pos.init;

import com.zkteco.zkbiosecurity.auth.service.AuthPermissionService;
import com.zkteco.zkbiosecurity.auth.vo.AuthPermissionItem;
import com.zkteco.zkbiosecurity.base.utils.VersionUtil;
import com.zkteco.zkbiosecurity.core.utils.EncrypAESUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.pos.constants.PosConstants;
import com.zkteco.zkbiosecurity.pos.service.PosBatchTimeService;
import com.zkteco.zkbiosecurity.pos.service.PosCardKindService;
import com.zkteco.zkbiosecurity.pos.service.PosDiningHallService;
import com.zkteco.zkbiosecurity.pos.service.PosKeyValueService;
import com.zkteco.zkbiosecurity.pos.service.PosMealService;
import com.zkteco.zkbiosecurity.pos.service.PosSplitTimeService;
import com.zkteco.zkbiosecurity.pos.vo.PosBatchTimeItem;
import com.zkteco.zkbiosecurity.pos.vo.PosCardKindItem;
import com.zkteco.zkbiosecurity.pos.vo.PosDiningHallItem;
import com.zkteco.zkbiosecurity.pos.vo.PosKeyValueItem;
import com.zkteco.zkbiosecurity.pos.vo.PosMealItem;
import com.zkteco.zkbiosecurity.pos.vo.PosSplitTimeItem;
import com.zkteco.zkbiosecurity.system.service.BaseSysParamService;
import com.zkteco.zkbiosecurity.system.vo.BaseSysParamItem;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=50)
public class PosInit
implements CommandLineRunner {
    @Autowired(required=false)
    private AuthPermissionService authPermissionService;
    @Autowired
    private BaseSysParamService baseSysParamService;
    @Autowired
    private PosSplitTimeService posSplitTimeService;
    @Autowired
    private PosBatchTimeService posBatchTimeService;
    @Autowired
    private PosDiningHallService posDiningHallService;
    @Autowired
    private PosMealService posMealService;
    @Autowired
    private PosKeyValueService posKeyValueService;
    @Autowired
    private PosCardKindService posCardKindService;
    @Value(value="${system.language}")
    private String language;

    public void run(String ... args) throws Exception {
        boolean alreadyInit = this.baseSysParamService.getAlreadyInitModule("Pos");
        if (alreadyInit) {
            this.baseSysParamService.setAlreadyInitModule("PosInit");
        }
        if (!(alreadyInit = this.baseSysParamService.getAlreadyInitModule("PosInit"))) {
            this.initAuthPermission();
            this.initPosSplitTime();
            this.initPosBatchTime();
            this.initPosDiningHall();
            this.initPosMeal();
            this.initPosKeyValue();
            this.initPosCardKind();
            this.initPosSystemParam();
            this.initUpgradeVersion();
            this.baseSysParamService.setAlreadyInitModule("PosInit");
        }
    }

    private void initAuthPermission() {
        AuthPermissionItem systemItem = new AuthPermissionItem("Pos", "pos_module", "pos", "system", "true", Integer.valueOf(5));
        systemItem = this.authPermissionService.saveItem(systemItem);
        AuthPermissionItem subMenuItem1 = new AuthPermissionItem("PosBaseInfo", "pos_leftMenu_basicInfo", "pos:base:info", "menu", "true", Integer.valueOf(1));
        subMenuItem1.setParentId(systemItem.getId());
        subMenuItem1.setActionLink("posSplitTime.do");
        subMenuItem1.setImg("pos_basic.png");
        subMenuItem1.setImgHover("pos_basic_over.png");
        subMenuItem1 = this.authPermissionService.saveItem(subMenuItem1);
        AuthPermissionItem subMenuItem = new AuthPermissionItem("PosSplitTime", "pos_leftMenu_splitTime", "pos:splitTime", "menu", "true", Integer.valueOf(1));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("posSplitTime.do");
        subMenuItem = this.authPermissionService.saveItem(subMenuItem);
        AuthPermissionItem subButtonItem = new AuthPermissionItem("PosSplitTimeEdit", "common_op_edit", "pos:splitTime:edit", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosSplitTimeRefresh", "common_op_refresh", "pos:splitTime:refresh", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subMenuItem = new AuthPermissionItem("PosBatchTime", "pos_leftMenu_batchTime", "pos:batchTime", "menu", "true", Integer.valueOf(2));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("posBatchTime.do");
        subMenuItem = this.authPermissionService.saveItem(subMenuItem);
        subButtonItem = new AuthPermissionItem("PosBatchTimeEdit", "common_op_edit", "pos:batchTime:edit", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosBatchTimeRefresh", "common_op_refresh", "pos:batchTime:refresh", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subMenuItem = new AuthPermissionItem("PosDiningHall", "pos_leftMenu_diningHall", "pos:diningHall", "menu", "true", Integer.valueOf(3));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("posDiningHall.do");
        subMenuItem = this.authPermissionService.saveItem(subMenuItem);
        subButtonItem = new AuthPermissionItem("PosDiningHallEdit", "common_op_edit", "pos:diningHall:edit", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosDiningHallRefresh", "common_op_refresh", "pos:diningHall:refresh", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosDiningHallAdd", "common_op_new", "pos:diningHall:add", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosDiningHallDel", "common_op_del", "pos:diningHall:del", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subMenuItem = new AuthPermissionItem("PosMeal", "pos_leftMenu_meal", "pos:meal", "menu", "true", Integer.valueOf(4));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("posMeal.do");
        subMenuItem = this.authPermissionService.saveItem(subMenuItem);
        subButtonItem = new AuthPermissionItem("PosMealEdit", "common_op_edit", "pos:meal:edit", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosMealRefresh", "common_op_refresh", "pos:meal:refresh", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subMenuItem = new AuthPermissionItem("PosStoreDetail", "pos_leftMenu_storeDetail", "pos:storeDetail", "menu", "true", Integer.valueOf(5));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("posStoreDetail.do");
        subMenuItem = this.authPermissionService.saveItem(subMenuItem);
        subButtonItem = new AuthPermissionItem("PosStoreDetailEdit", "common_op_edit", "pos:storeDetail:edit", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosStoreDetailRefresh", "common_op_refresh", "pos:storeDetail:refresh", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosStoreDetailAdd", "common_op_new", "pos:storeDetail:add", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosStoreDetailDel", "common_op_del", "pos:storeDetail:del", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subMenuItem = new AuthPermissionItem("PosKeyValue", "pos_leftMenu_keyValue", "pos:keyValue", "menu", "true", Integer.valueOf(6));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("posKeyValue.do");
        subMenuItem = this.authPermissionService.saveItem(subMenuItem);
        subButtonItem = new AuthPermissionItem("PosKeyValueEdit", "common_op_edit", "pos:keyValue:edit", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosKeyValueRefresh", "common_op_refresh", "pos:keyValue:refresh", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subMenuItem = new AuthPermissionItem("PosCardKind", "pos_leftMenu_icCard", "pos:cardKind", "menu", "true", Integer.valueOf(7));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("posCardKind.do");
        subMenuItem = this.authPermissionService.saveItem(subMenuItem);
        subButtonItem = new AuthPermissionItem("PosCardKindEdit", "common_op_edit", "pos:cardKind:edit", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosCardKindRefresh", "common_op_refresh", "pos:cardKind:refresh", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosCardKindAdd", "common_op_new", "pos:cardKind:add", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosCardKindDel", "common_op_del", "pos:cardKind:del", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subMenuItem1 = new AuthPermissionItem("PosDevice", "pos_leftMenu_devManage", "pos:device:manager", "menu", "true", Integer.valueOf(2));
        subMenuItem1.setParentId(systemItem.getId());
        subMenuItem1.setActionLink("posDevice.do");
        subMenuItem1.setImg("pos_device.png");
        subMenuItem1.setImgHover("pos_device_over.png");
        subMenuItem1 = this.authPermissionService.saveItem(subMenuItem1);
        subMenuItem = new AuthPermissionItem("PosDeviceSecond", "pos_leftMenu_devManage", "pos:device", "menu", "true", Integer.valueOf(1));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("posDevice.do");
        subMenuItem = this.authPermissionService.saveItem(subMenuItem);
        subButtonItem = new AuthPermissionItem("PosDeviceSecondEdit", "common_op_edit", "pos:device:edit", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosDeviceSecondRefresh", "common_op_refresh", "pos:device:refresh", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosDeviceSecondAdd", "common_op_new", "pos:device:add", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosDeviceSecondDel", "common_op_del", "pos:device:del", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosDeviceSecondClearCardData", "pos_op_clearCardData", "pos:device:clearCardData", "button", "true", Integer.valueOf(5));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosDeviceSecondClearConsumerSettings", "pos_op_clearConsumerSettings", "pos:device:clearConsumerSettings", "button", "true", Integer.valueOf(6));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosDeviceSecondDeleteCmd", "pos_op_deleteCmd", "pos:device:deleteCmd", "button", "true", Integer.valueOf(7));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosDeviceSecondCollectDataOnline", "pos_op_collectDataOnline", "pos:device:collectDataOnline", "button", "true", Integer.valueOf(8));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosDeviceSecondReboot", "pos_op_reboot", "pos:device:reboot", "button", "true", Integer.valueOf(9));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosDeviceSecondSyncAllDataToDev", "pos_op_syncallDataToDev", "pos:device:syncAllDataToDev", "button", "true", Integer.valueOf(10));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosDeviceSecondSearchDev", "pos_dev_search", "pos:device:search", "button", "true", Integer.valueOf(11));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosDeviceSecondRequestCollectData", "pos_op_collectDataOnline", "pos:device:requestCollectData", "button", "true", Integer.valueOf(12));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subMenuItem = new AuthPermissionItem("PosSystemParam", "pos_leftMenu_setParam", "pos:systemParam", "menu", "true", Integer.valueOf(2));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("posSystemParam.do");
        subMenuItem = this.authPermissionService.saveItem(subMenuItem);
        subButtonItem = new AuthPermissionItem("PosSystemParamEdit", "common_op_edit", "pos:systemParam:edit", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subMenuItem1 = new AuthPermissionItem("PosCard", "pos_leftMenu_cardManageBar", "pos:card:manager", "menu", "true", Integer.valueOf(3));
        subMenuItem1.setParentId(systemItem.getId());
        subMenuItem1.setActionLink("posCard.do");
        subMenuItem1.setImg("pos_card.png");
        subMenuItem1.setImgHover("pos_card_over.png");
        subMenuItem1 = this.authPermissionService.saveItem(subMenuItem1);
        subMenuItem = new AuthPermissionItem("PosCardOperation", "pos_leftMenu_cardBusiness", "pos:cardOperation", "menu", "true", Integer.valueOf(1));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("skip.do?page=pos_cardBusiness_PosCardBusiness");
        subMenuItem = this.authPermissionService.saveItem(subMenuItem);
        subButtonItem = new AuthPermissionItem("PosCardOperationModifiedData", "pos_op_modifiedData", "pos:modifiedData:edit", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosCardOperationSendCard", "pos_op_sendCard", "pos:sendCard:edit", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosCardOperationRetreatCard", "pos_op_retreatCard", "pos:retreatCard:edit", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosCardOperationRechargeCard", "pos_op_repairCard", "pos:rechargeCard:edit", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosCardOperationTopUp", "pos_op_topUp", "pos:topUp:edit", "button", "true", Integer.valueOf(5));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosCardOperationRefund", "pos_op_refund", "pos:refund:edit", "button", "true", Integer.valueOf(6));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subMenuItem = new AuthPermissionItem("PosCardManage", "pos_leftMenu_cardManage", "pos:cardManage", "menu", "true", Integer.valueOf(2));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("posCardManage.do");
        subMenuItem = this.authPermissionService.saveItem(subMenuItem);
        subButtonItem = new AuthPermissionItem("PosCardManageEdit", "common_op_edit", "pos:cardManage:edit", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosCardManageRefresh", "common_op_refresh", "pos:cardManage:refresh", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosCardManageExport", "common_op_export", "pos:cardManage:export", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosCardManageAdd", "common_op_new", "pos:cardManage:add", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosCardManageLogout", "pos_op_manage_card_logout", "pos:cardManage:logout", "button", "true", Integer.valueOf(5));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosCardManageNoneRetreatCard", "pos_op_noneRetreatCard", "pos:cardManage:noneRetreatCard", "button", "true", Integer.valueOf(6));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subMenuItem = new AuthPermissionItem("PosTransactionCard", "pos_leftMenu_carcashSZ", "pos:transactionCard", "menu", "true", Integer.valueOf(3));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("posTransactionCard.do");
        subMenuItem = this.authPermissionService.saveItem(subMenuItem);
        subButtonItem = new AuthPermissionItem("PosTransactionCardEdit", "common_op_edit", "pos:transactionCard:edit", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosTransactionCardRefresh", "common_op_refresh", "pos:transactionCard:refresh", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosTransactionCardExport", "common_op_export", "pos:transactionCard:export", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosTransactionCardAdd", "common_op_new", "pos:transactionCard:add", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subMenuItem1 = new AuthPermissionItem("PosTransaction", "pos_leftMenu_icConsumerList", "pos:transaction:manager", "menu", "true", Integer.valueOf(4));
        subMenuItem1.setParentId(systemItem.getId());
        subMenuItem1.setActionLink("posTransaction.do");
        subMenuItem1.setImg("pos_countTable.png");
        subMenuItem1.setImgHover("pos_countTable_over.png");
        subMenuItem1 = this.authPermissionService.saveItem(subMenuItem1);
        subMenuItem = new AuthPermissionItem("PosTransactionTable", "pos_consumption_details_table", "pos:transaction", "menu", "true", Integer.valueOf(1));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("posTransaction.do");
        subMenuItem = this.authPermissionService.saveItem(subMenuItem);
        subButtonItem = new AuthPermissionItem("PosTransactionTableEdit", "common_op_edit", "pos:transaction:edit", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosTransactionTableRefresh", "common_op_refresh", "pos:transaction:refresh", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosTransactionTableExport", "common_op_export", "pos:transaction:export", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosTransactionTableErrorRecovery", "pos_consumerList_correction", "pos:transaction:errorRecovery", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosTransactionTableDel", "common_op_del", "pos:transaction:del", "button", "true", Integer.valueOf(5));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosTransactionTableImport", "pos_consumerList_importRecord", "pos:transaction:importRecord", "button", "true", Integer.valueOf(6));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subMenuItem = new AuthPermissionItem("PosTransactionBak", "pos_leftMenu_transBak", "pos:transactionBak", "menu", "true", Integer.valueOf(2));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("posTransactionBak.do");
        subMenuItem = this.authPermissionService.saveItem(subMenuItem);
        subButtonItem = new AuthPermissionItem("PosTransactionBakRefresh", "common_op_refresh", "pos:transactionBak:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosTransactionBakCorrect", "pos_transBak_correct", "pos:transactionBak:correct", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosTransactionBakExport", "common_op_export", "pos:transactionBak:export", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subMenuItem1 = new AuthPermissionItem("PosHandConsume", "pos_leftMenu_handConsume", "pos:handConsume", "menu", "true", Integer.valueOf(5));
        subMenuItem1.setParentId(systemItem.getId());
        subMenuItem1.setActionLink("posHandConsume.do");
        subMenuItem1.setImg("pos_handconsume.png");
        subMenuItem1.setImgHover("pos_handconsume_over.png");
        subMenuItem1 = this.authPermissionService.saveItem(subMenuItem1);
        subMenuItem = new AuthPermissionItem("HandConsume", "pos_leftMenu_handConsume", "pos:handConsume", "menu", "true", Integer.valueOf(1));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("posHandConsume.do");
        subMenuItem = this.authPermissionService.saveItem(subMenuItem);
        subButtonItem = new AuthPermissionItem("HandConsumeEdit", "common_op_edit", "pos:handConsume:edit", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("HandConsumeRefresh", "common_op_refresh", "pos:handConsume:refresh", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("HandConsumeExport", "common_op_export", "pos:handConsume:export", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("HandConsumeAdd", "common_op_new", "pos:handConsume:add", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subMenuItem1 = new AuthPermissionItem("PosAllowanceLogRecord", "pos_leftMenu_allowance", "pos:allowanceLogRecord:manager", "menu", "true", Integer.valueOf(6));
        subMenuItem1.setParentId(systemItem.getId());
        subMenuItem1.setActionLink("posAllowanceLogRecord.do");
        subMenuItem1.setImg("pos_allowance.png");
        subMenuItem1.setImgHover("pos_allowance_over.png");
        subMenuItem1 = this.authPermissionService.saveItem(subMenuItem1);
        subMenuItem = new AuthPermissionItem("AllowanceLogRecord", "pos_leftMenu_allowanceLogRecord", "pos:allowanceLogRecord", "menu", "true", Integer.valueOf(1));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("posAllowanceLogRecord.do");
        subMenuItem = this.authPermissionService.saveItem(subMenuItem);
        subButtonItem = new AuthPermissionItem("AllowanceLogRecordEdit", "common_op_edit", "pos:allowanceLogRecord:edit", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("AllowanceLogRecordRefresh", "common_op_refresh", "pos:allowanceLogRecord:refresh", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("AllowanceLogRecordExport", "common_op_export", "pos:allowanceLogRecord:export", "button", "true", Integer.valueOf(3));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("AllowanceLogRecordAdd", "common_op_new", "pos:allowanceLogRecord:add", "button", "true", Integer.valueOf(4));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("AllowanceLogRecordSetCheck", "pos_allowance_check", "pos:allowanceLogRecord:setCheck", "button", "true", Integer.valueOf(5));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("AllowanceLogRecordEnable", "pos_allowance_checkAll", "pos:allowanceLogRecord:enable", "button", "true", Integer.valueOf(6));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("AllowanceLogRecordSetReCheck", "pos_allowance_reCheck", "pos:allowanceLogRecord:setReCheck", "button", "true", Integer.valueOf(7));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("AllowanceLogRecordImport", "pos_allowance_import", "pos:allowanceLogRecord:import", "button", "true", Integer.valueOf(8));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("AllowanceLogRecordDel", "common_op_del", "pos:allowanceLogRecord:del", "button", "true", Integer.valueOf(9));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("AllowanceLogRecordExportTemplet", "pos_import_template", "pos:allowanceLogRecord:exportTemplet", "button", "true", Integer.valueOf(10));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subMenuItem1 = new AuthPermissionItem("PosReport", "pos_leftMenu_posReportForm", "pos:report:manager", "menu", "true", Integer.valueOf(7));
        subMenuItem1.setParentId(systemItem.getId());
        subMenuItem1.setActionLink("posAllowanceLogRecord.do");
        subMenuItem1.setImg("pos_reportForm.png");
        subMenuItem1.setImgHover("pos_reportForm_over.png");
        subMenuItem1 = this.authPermissionService.saveItem(subMenuItem1);
        subMenuItem = new AuthPermissionItem("PosSendTable", "pos_sendCard_table", "pos:sendTable", "menu", "true", Integer.valueOf(1));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("posTransactionCardRecord.do?requestType=sendTable");
        subMenuItem = this.authPermissionService.saveItem(subMenuItem);
        subButtonItem = new AuthPermissionItem("PosSendTableRefresh", "common_op_refresh", "pos:sendTable:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosSendTableExport", "common_op_export", "pos:sendTable:export", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subMenuItem = new AuthPermissionItem("PosCardRechargeForm", "pos_card_recharge_table", "pos:rechargeForm", "menu", "true", Integer.valueOf(2));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("posTransactionCardRecord.do?requestType=rechargeForm");
        subMenuItem = this.authPermissionService.saveItem(subMenuItem);
        subButtonItem = new AuthPermissionItem("PosCardRechargeFormRefresh", "common_op_refresh", "pos:rechargeForm:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosCardRechargeFormExport", "common_op_export", "pos:rechargeForm:export", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subMenuItem = new AuthPermissionItem("PosCardRefund", "pos_card_refund_table", "pos:cardRefund", "menu", "true", Integer.valueOf(3));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("posTransactionCardRecord.do?requestType=cardRefund");
        subMenuItem = this.authPermissionService.saveItem(subMenuItem);
        subButtonItem = new AuthPermissionItem("PosCardRefundRefresh", "common_op_refresh", "pos:cardRefund:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosCardRefundExport", "common_op_export", "pos:cardRefund:export", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subMenuItem = new AuthPermissionItem("PosCardSubsidy", "pos_card_subsidy_table", "pos:cardSubsidy", "menu", "true", Integer.valueOf(4));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("posTransactionCardRecord.do?requestType=cardSubsidy");
        subMenuItem = this.authPermissionService.saveItem(subMenuItem);
        subButtonItem = new AuthPermissionItem("PosCardSubsidyRefresh", "common_op_refresh", "pos:cardSubsidy:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosCardSubsidyExport", "common_op_export", "pos:cardSubsidy:export", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subMenuItem = new AuthPermissionItem("PosBackCard", "pos_card_backCard", "pos:backCard", "menu", "true", Integer.valueOf(5));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("posTransactionCardRecord.do?requestType=backCard");
        subMenuItem = this.authPermissionService.saveItem(subMenuItem);
        subButtonItem = new AuthPermissionItem("PosBackCardRefresh", "common_op_refresh", "pos:backCard:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosBackCardExport", "common_op_export", "pos:backCard:export", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subMenuItem = new AuthPermissionItem("PosCardCost", "pos_card_cardCostTable", "pos:cardCost", "menu", "true", Integer.valueOf(6));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("posTransactionCardRecord.do?requestType=cardCost");
        subMenuItem = this.authPermissionService.saveItem(subMenuItem);
        subButtonItem = new AuthPermissionItem("PosCardCostRefresh", "common_op_refresh", "pos:cardCost:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosCardCostExport", "common_op_export", "pos:cardCost:export", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subMenuItem = new AuthPermissionItem("PosCardBlance", "pos_card_blance_table", "pos:cardBlance", "menu", "true", Integer.valueOf(7));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("posTransactionCardRecord.do?requestType=cardBlance");
        subMenuItem = this.authPermissionService.saveItem(subMenuItem);
        subButtonItem = new AuthPermissionItem("PosCardBlanceRefresh", "common_op_refresh", "pos:cardBlance:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosCardBlanceExport", "common_op_export", "pos:cardBlance:export", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subMenuItem = new AuthPermissionItem("PosCardNoCardBackCard", "pos_card_noCardBackCard_table", "pos:cardNoCardBackCard", "menu", "true", Integer.valueOf(8));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("posTransactionCardRecord.do?requestType=cardNoCardBackCard");
        subMenuItem = this.authPermissionService.saveItem(subMenuItem);
        subButtonItem = new AuthPermissionItem("PosCardNoCardBackCardRefresh", "common_op_refresh", "pos:cardNoCardBackCard:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosCardNoCardBackCardExport", "common_op_export", "pos:cardNoCardBackCard:export", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subMenuItem = new AuthPermissionItem("PosLoseUniteCard", "pos_card_report_and_missReport_table", "pos:loseUniteCard", "menu", "true", Integer.valueOf(9));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("posTransactionCardRecord.do?requestType=loseUniteCard");
        subMenuItem = this.authPermissionService.saveItem(subMenuItem);
        subButtonItem = new AuthPermissionItem("PosLoseUniteCardRefresh", "common_op_refresh", "pos:loseUniteCard:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosLoseUniteCardExport", "common_op_export", "pos:loseUniteCard:export", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subMenuItem1 = new AuthPermissionItem("PosStatisticsReport", "pos_leftMenu_countTable", "pos:report:manager", "menu", "true", Integer.valueOf(8));
        subMenuItem1.setParentId(systemItem.getId());
        subMenuItem1.setActionLink("posAllowanceLogRecord.do");
        subMenuItem1.setImg("pos_statistics_report.png");
        subMenuItem1.setImgHover("pos_statistics_report_over.png");
        subMenuItem1 = this.authPermissionService.saveItem(subMenuItem1);
        subMenuItem = new AuthPermissionItem("PosPersonConsume", "pos_countTable_personConsume", "pos:personConsume", "menu", "true", Integer.valueOf(1));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("posPersonConsume.do");
        subMenuItem = this.authPermissionService.saveItem(subMenuItem);
        subButtonItem = new AuthPermissionItem("PosPersonConsumeRefresh", "common_op_refresh", "pos:personConsume:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosPersonConsumeExport", "common_op_export", "pos:personConsume:export", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subMenuItem = new AuthPermissionItem("PosDeptConsume", "pos_countTable_deptConsume", "pos:deptConsume", "menu", "true", Integer.valueOf(2));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("posDeptConsume.do");
        subMenuItem = this.authPermissionService.saveItem(subMenuItem);
        subButtonItem = new AuthPermissionItem("PosDeptConsumeRefresh", "common_op_refresh", "pos:deptConsume:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosDeptConsumeExport", "common_op_export", "pos:deptConsume:export", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subMenuItem = new AuthPermissionItem("PosDiningHallConsume", "pos_countTable_diningHallConsume", "pos:diningHallConsume", "menu", "true", Integer.valueOf(3));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("posDiningHallConsume.do");
        subMenuItem = this.authPermissionService.saveItem(subMenuItem);
        subButtonItem = new AuthPermissionItem("PosDiningHallConsumeRefresh", "common_op_refresh", "pos:diningHallConsume:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosDiningHallConsumeExport", "common_op_export", "pos:diningHallConsume:export", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subMenuItem = new AuthPermissionItem("PosDeviceConsume", "pos_countTable_deviceConsume", "pos:deviceConsume", "menu", "true", Integer.valueOf(4));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("posDeviceConsume.do");
        subMenuItem = this.authPermissionService.saveItem(subMenuItem);
        subButtonItem = new AuthPermissionItem("PosDeviceConsumeRefresh", "common_op_refresh", "pos:deviceConsume:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosDeviceConsumeExport", "common_op_export", "pos:deviceConsume:export", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subMenuItem = new AuthPermissionItem("PosIncomeExpendConsume", "pos_countTable_incomeExpendConsume", "pos:incomeExpendConsume", "menu", "true", Integer.valueOf(5));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("posIncomeExpendConsume.do");
        subMenuItem = this.authPermissionService.saveItem(subMenuItem);
        subButtonItem = new AuthPermissionItem("PosIncomeExpendConsumeRefresh", "common_op_refresh", "pos:incomeExpendConsume:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosIncomeExpendConsumeExport", "common_op_export", "pos:incomeExpendConsume:export", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subMenuItem = new AuthPermissionItem("PosMealConsume", "pos_countTable_mealConsume", "pos:mealConsume", "menu", "true", Integer.valueOf(6));
        subMenuItem.setParentId(subMenuItem1.getId());
        subMenuItem.setActionLink("posMealConsume.do");
        subMenuItem = this.authPermissionService.saveItem(subMenuItem);
        subButtonItem = new AuthPermissionItem("PosMealConsumeRefresh", "common_op_refresh", "pos:mealConsume:refresh", "button", "true", Integer.valueOf(1));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
        subButtonItem = new AuthPermissionItem("PosMealConsumeExport", "common_op_export", "pos:mealConsume:export", "button", "true", Integer.valueOf(2));
        subButtonItem.setParentId(subMenuItem.getId());
        subButtonItem = this.authPermissionService.saveItem(subButtonItem);
    }

    public void initPosSplitTime() {
        PosSplitTimeItem posSplitTimeInit1 = new PosSplitTimeItem("1", I18nUtil.i18nCode((String)"pos_splitTime_name0", (Object[])new Object[0]), String.valueOf("00:00"), String.valueOf("10:00"), Double.valueOf(10.0), Boolean.valueOf(true));
        PosSplitTimeItem posSplitTimeInit2 = new PosSplitTimeItem("2", I18nUtil.i18nCode((String)"pos_splitTime_name1", (Object[])new Object[0]), String.valueOf("10:01"), String.valueOf("14:00"), Double.valueOf(10.0), Boolean.valueOf(true));
        PosSplitTimeItem posSplitTimeInit3 = new PosSplitTimeItem("3", I18nUtil.i18nCode((String)"pos_splitTime_name2", (Object[])new Object[0]), String.valueOf("14:01"), String.valueOf("20:00"), Double.valueOf(10.0), Boolean.valueOf(true));
        PosSplitTimeItem posSplitTimeInit4 = new PosSplitTimeItem("4", I18nUtil.i18nCode((String)"pos_splitTime_name3", (Object[])new Object[0]), String.valueOf("20:01"), String.valueOf("23:59"), Double.valueOf(10.0), Boolean.valueOf(true));
        PosSplitTimeItem posSplitTimeInit5 = new PosSplitTimeItem("5", I18nUtil.i18nCode((String)"pos_splitTime_name4", (Object[])new Object[0]), String.valueOf("00:00"), String.valueOf("10:00"), Double.valueOf(10.0), Boolean.valueOf(false));
        PosSplitTimeItem posSplitTimeInit6 = new PosSplitTimeItem("6", I18nUtil.i18nCode((String)"pos_splitTime_name5", (Object[])new Object[0]), String.valueOf("10:01"), String.valueOf("14:00"), Double.valueOf(10.0), Boolean.valueOf(false));
        PosSplitTimeItem posSplitTimeInit7 = new PosSplitTimeItem("7", I18nUtil.i18nCode((String)"pos_splitTime_name6", (Object[])new Object[0]), String.valueOf("14:01"), String.valueOf("20:00"), Double.valueOf(10.0), Boolean.valueOf(false));
        PosSplitTimeItem posSplitTimeInit8 = new PosSplitTimeItem("8", I18nUtil.i18nCode((String)"pos_splitTime_name7", (Object[])new Object[0]), String.valueOf("20:01"), String.valueOf("23:59"), Double.valueOf(10.0), Boolean.valueOf(false));
        this.posSplitTimeService.initData(posSplitTimeInit1);
        this.posSplitTimeService.initData(posSplitTimeInit2);
        this.posSplitTimeService.initData(posSplitTimeInit3);
        this.posSplitTimeService.initData(posSplitTimeInit4);
        this.posSplitTimeService.initData(posSplitTimeInit5);
        this.posSplitTimeService.initData(posSplitTimeInit6);
        this.posSplitTimeService.initData(posSplitTimeInit7);
        this.posSplitTimeService.initData(posSplitTimeInit8);
    }

    public void initPosBatchTime() {
        String[] names = new String[]{I18nUtil.i18nCode((String)"pos_timeSeg_0", (Object[])new Object[0]), I18nUtil.i18nCode((String)"pos_timeSeg_1", (Object[])new Object[0]), I18nUtil.i18nCode((String)"pos_timeSeg_2", (Object[])new Object[0]), I18nUtil.i18nCode((String)"pos_timeSeg_3", (Object[])new Object[0]), I18nUtil.i18nCode((String)"pos_timeSeg_4", (Object[])new Object[0]), I18nUtil.i18nCode((String)"pos_timeSeg_5", (Object[])new Object[0]), I18nUtil.i18nCode((String)"pos_timeSeg_6", (Object[])new Object[0]), I18nUtil.i18nCode((String)"pos_timeSeg_7", (Object[])new Object[0]), I18nUtil.i18nCode((String)"pos_timeSeg_8", (Object[])new Object[0])};
        String[] starts = new String[]{"08:00", "10:00", "17:00", "20:00"};
        String[] ends = new String[]{"09:00", "14:00", "19:00", "23:59"};
        this.posBatchTimeService.initData(names, starts, ends);
    }

    public void initPosDiningHall() {
        PosDiningHallItem item = this.posDiningHallService.getItemByCode("1");
        if (item == null) {
            item = new PosDiningHallItem();
            item.setCode("1");
            item.setName(I18nUtil.i18nCode((String)"pos_diningHall_headquarters", (Object[])new Object[0]));
            item.setRemark(I18nUtil.i18nCode((String)"pos_diningHall_defaultDate", (Object[])new Object[0]));
            item.setInitFlag(Boolean.valueOf(true));
            this.posDiningHallService.saveItem(item);
        }
    }

    public void initPosMeal() {
        PosMealItem posMealInit1 = new PosMealItem("1", I18nUtil.i18nCode((String)"pos_mealName_0", (Object[])new Object[0]), String.valueOf("00:00"), String.valueOf("10:00"), Boolean.valueOf(true));
        PosMealItem posMealInit2 = new PosMealItem("2", I18nUtil.i18nCode((String)"pos_mealName_1", (Object[])new Object[0]), String.valueOf("10:01"), String.valueOf("14:00"), Boolean.valueOf(true));
        PosMealItem posMealInit3 = new PosMealItem("3", I18nUtil.i18nCode((String)"pos_mealName_2", (Object[])new Object[0]), String.valueOf("14:01"), String.valueOf("20:00"), Boolean.valueOf(true));
        PosMealItem posMealInit4 = new PosMealItem("4", I18nUtil.i18nCode((String)"pos_mealName_3", (Object[])new Object[0]), String.valueOf("20:01"), String.valueOf("23:59"), Boolean.valueOf(true));
        PosMealItem posMealInit5 = new PosMealItem("5", I18nUtil.i18nCode((String)"pos_mealName_4", (Object[])new Object[0]), String.valueOf("00:00"), String.valueOf("10:00"), Boolean.valueOf(false));
        PosMealItem posMealInit6 = new PosMealItem("6", I18nUtil.i18nCode((String)"pos_mealName_5", (Object[])new Object[0]), String.valueOf("10:01"), String.valueOf("14:00"), Boolean.valueOf(false));
        PosMealItem posMealInit7 = new PosMealItem("7", I18nUtil.i18nCode((String)"pos_mealName_6", (Object[])new Object[0]), String.valueOf("14:01"), String.valueOf("20:00"), Boolean.valueOf(false));
        PosMealItem posMealInit8 = new PosMealItem("8", I18nUtil.i18nCode((String)"pos_mealName_7", (Object[])new Object[0]), String.valueOf("20:01"), String.valueOf("23:59"), Boolean.valueOf(false));
        this.posMealService.initData(posMealInit1);
        this.posMealService.initData(posMealInit2);
        this.posMealService.initData(posMealInit3);
        this.posMealService.initData(posMealInit4);
        this.posMealService.initData(posMealInit5);
        this.posMealService.initData(posMealInit6);
        this.posMealService.initData(posMealInit7);
        this.posMealService.initData(posMealInit8);
    }

    public void initPosKeyValue() {
        PosKeyValueItem posKeyValueInit1 = new PosKeyValueItem("1", Double.valueOf(0.0));
        PosKeyValueItem posKeyValueInit2 = new PosKeyValueItem("2", Double.valueOf(0.0));
        PosKeyValueItem posKeyValueInit3 = new PosKeyValueItem("3", Double.valueOf(0.0));
        PosKeyValueItem posKeyValueInit4 = new PosKeyValueItem("4", Double.valueOf(0.0));
        PosKeyValueItem posKeyValueInit5 = new PosKeyValueItem("5", Double.valueOf(0.0));
        PosKeyValueItem posKeyValueInit6 = new PosKeyValueItem("6", Double.valueOf(0.0));
        PosKeyValueItem posKeyValueInit7 = new PosKeyValueItem("7", Double.valueOf(0.0));
        PosKeyValueItem posKeyValueInit8 = new PosKeyValueItem("8", Double.valueOf(0.0));
        PosKeyValueItem posKeyValueInit9 = new PosKeyValueItem("9", Double.valueOf(0.0));
        this.posKeyValueService.initData(posKeyValueInit1);
        this.posKeyValueService.initData(posKeyValueInit2);
        this.posKeyValueService.initData(posKeyValueInit3);
        this.posKeyValueService.initData(posKeyValueInit4);
        this.posKeyValueService.initData(posKeyValueInit5);
        this.posKeyValueService.initData(posKeyValueInit6);
        this.posKeyValueService.initData(posKeyValueInit7);
        this.posKeyValueService.initData(posKeyValueInit8);
        this.posKeyValueService.initData(posKeyValueInit9);
    }

    public void initPosCardKind() {
        PosCardKindItem item = this.posCardKindService.getItemByCode("1");
        if (item == null) {
            PosBatchTimeItem posBatchTime = null;
            List itemList = this.posBatchTimeService.getItemByCode("1");
            if (itemList != null && itemList.size() > 0) {
                posBatchTime = (PosBatchTimeItem)itemList.get(0);
            }
            item = new PosCardKindItem();
            item.setCode("1");
            item.setName(I18nUtil.i18nCode((String)"pos_iccard_initName", (Object[])new Object[0]));
            item.setDiscount(Integer.valueOf(10));
            item.setDateMaxCount(Integer.valueOf(0));
            item.setDateMaxMoney(Double.valueOf(0.0));
            item.setPerMaxMoney(Double.valueOf(0.0));
            item.setMealMaxMoney(Double.valueOf(0.0));
            item.setMealMaxCount(Integer.valueOf(0));
            item.setLessMoney(Double.valueOf(0.0));
            if (!this.language.equals("zh_CN")) {
                item.setMaxMoney(Double.valueOf(PosConstants.OVERSEA_MAX_MONEY.doubleValue()));
            } else {
                item.setMaxMoney(Double.valueOf(PosConstants.CHINA_MAX_MONEY.doubleValue()));
            }
            item.setUseDate(Integer.valueOf(0));
            item.setBatchTimeId(posBatchTime != null ? posBatchTime.getId() : "");
            item.setBatchTimeName(posBatchTime != null ? posBatchTime.getName() : "");
            this.posCardKindService.saveItem(item);
        }
    }

    public void initPosSystemParam() {
        if (this.language.equals("zh_CN")) {
            this.baseSysParamService.initData(new BaseSysParamItem("pos.highLimit", PosConstants.CHINA_MAX_MONEY + "", "\u5361\u4f59\u989d\u4e0a\u9650"));
        } else {
            this.baseSysParamService.initData(new BaseSysParamItem("pos.highLimit", PosConstants.OVERSEA_MAX_MONEY + "", "\u5361\u4f59\u989d\u4e0a\u9650"));
        }
        this.baseSysParamService.initData(new BaseSysParamItem("pos.systemPassword", EncrypAESUtil.encrytToString((String)"123456"), "\u7cfb\u7edf\u5bc6\u7801"));
        this.baseSysParamService.initData(new BaseSysParamItem("pos.cardModel", "1", "\u5355/\u53cc\u94b1\u5305\u6a21\u5f0f"));
        this.baseSysParamService.initData(new BaseSysParamItem("pos.whiteList", "false", "1\u4e3a\u5f00\u542f\u767d\u540d\u5355\u6a21\u5f0f\uff0c0\u4f4d\u5173\u95ed\u767d\u540d\u5355\u6a21\u5f0f"));
        this.baseSysParamService.initData(new BaseSysParamItem("pos.oneSection", "1", "\u7b2c\u4e00\u6247\u533a"));
        this.baseSysParamService.initData(new BaseSysParamItem("pos.twoSection", "2", "\u7b2c\u4e8c\u6247\u533a"));
        this.baseSysParamService.initData(new BaseSysParamItem("pos.sectionCount", "15", "\u6247\u533a\u4e2a\u6570"));
        this.baseSysParamService.initData(new BaseSysParamItem("pos.toModify", "true", "0\u4e3a\u4e0d\u53ef\u4fee\u6539\uff0c1\u4e3a\u53ef\u4fee\u6539"));
        this.baseSysParamService.initData(new BaseSysParamItem("pos.switchTime", "1", "\u5207\u6362\u4e0a\u4f20\u65f6\u95f4\u548c\u6d88\u8d39\u65f6\u95f4 1\u6d88\u8d39\u65f6\u95f4 2\u4e0a\u4f20\u65f6\u95f4"));
        this.baseSysParamService.initData(new BaseSysParamItem("pos.keyWord", "ZKBiosecurityPosSystemKey", "\u63d2\u4ef6\u79d8\u94a5"));
        this.baseSysParamService.initData(new BaseSysParamItem("pos.consumeOrder", "3", "\u94b1\u5305\u6d88\u8d39\u987a\u5e8f(\u53ea\u9488\u5bf9\u53cc\u94b1\u5305\u6a21\u5f0f\u4e0b\u4f7f\u7528)"));
        this.baseSysParamService.initData(new BaseSysParamItem("pos.monthAllow", "false", "\u662f\u5426\u5f53\u6708\u8865\u8d34\u53ea\u53ef\u4ee5\u5f53\u6708\u6d88\u8d39:"));
        this.baseSysParamService.initData(new BaseSysParamItem("pos.confirmPassword", EncrypAESUtil.encrytToString((String)"123456"), "\u786e\u8ba4\u5bc6\u7801"));
        this.baseSysParamService.initData(new BaseSysParamItem("pos.moneyDeclare", "1", "\u8d27\u5e01\u5355\u4f4d"));
        this.baseSysParamService.initData(new BaseSysParamItem("pos.moneySign", "$", "\u8d27\u5e01\u5355\u4f4d\u7b26\u53f7"));
    }

    private void initUpgradeVersion() {
        String curVersion = VersionUtil.getReleaseGitTags((String)"pos");
        if (StringUtils.isNotBlank((CharSequence)curVersion)) {
            BaseSysParamItem baseSysParamItem = this.baseSysParamService.findByParamName("PosUpgradeVersion");
            if (StringUtils.isBlank((CharSequence)baseSysParamItem.getId())) {
                baseSysParamItem = new BaseSysParamItem("PosUpgradeVersion", curVersion, "Pos Upgrade Version", Boolean.valueOf(true));
            }
            this.baseSysParamService.saveItem(baseSysParamItem);
        }
    }
}

