/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.esdc.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.GridOperate;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import java.io.Serializable;

@From(after="ESDC_TRANSACTION_CONFIG t LEFT JOIN ESDC_TRANSACTION_CONFIG p ON t.PARENT_ID = p.ID ")
@OrderBy(after="t.CREATE_TIME DESC")
@GridConfig(operate=true, idField="id", operates={@GridOperate(type="edit", permission="esdc:transactionconfig:edit", url="esdcTransactionConfig.do?edit", label="common_op_edit")})
public class EsdcTransactionConfigItem
extends BaseItem
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Column(name="t.ID")
    @GridColumn(width="40", sort="na", show=false)
    private String id;
    @Column(name="t.EVENT_TYPE")
    @GridColumn(label="esdc_transaction_config_event_type", show=false, width="200")
    private String eventType;
    @Column(name="p.EVENT_TYPE")
    private String parentEventType;
    @Column(name="p.EVENT_NAME")
    @GridColumn(label="esdc_transaction_config_event_type", width="200")
    private String parentEventName;
    @Column(name="t.EVENT_NAME")
    @GridColumn(label="esdc_transaction_config_event_name", width="200")
    private String eventName;
    @Column(name="t.EVENT_LEVEL")
    @GridColumn(label="esdc_transaction_config_event_level", width="120", format="1=esdc_transaction_level_1,2=esdc_transaction_level_2,3=esdc_transaction_level_3,4=esdc_transaction_level_0")
    private Integer eventLevel;
    @Column(name="p.ID", equalTag="=")
    private String parentId;
    @Condition(value="t.ID", equalTag="in")
    private String ids;
    @Condition(value="t.EVENT_TYPE", equalTag="in")
    private String eventTypes;
    @Column(name="p.ID", equalTag="in")
    private String configId;

    public EsdcTransactionConfigItem() {
    }

    public EsdcTransactionConfigItem(String id) {
        this.id = id;
    }

    public EsdcTransactionConfigItem(String eventType, String eventName, int eventLevel) {
        this.eventLevel = eventLevel;
        this.eventType = eventType;
        this.eventName = eventName;
    }

    public EsdcTransactionConfigItem setId(String id) {
        this.id = id;
        return this;
    }

    public EsdcTransactionConfigItem setEventType(String eventType) {
        this.eventType = eventType;
        return this;
    }

    public EsdcTransactionConfigItem setParentEventType(String parentEventType) {
        this.parentEventType = parentEventType;
        return this;
    }

    public EsdcTransactionConfigItem setParentEventName(String parentEventName) {
        this.parentEventName = parentEventName;
        return this;
    }

    public EsdcTransactionConfigItem setEventName(String eventName) {
        this.eventName = eventName;
        return this;
    }

    public EsdcTransactionConfigItem setEventLevel(Integer eventLevel) {
        this.eventLevel = eventLevel;
        return this;
    }

    public EsdcTransactionConfigItem setParentId(String parentId) {
        this.parentId = parentId;
        return this;
    }

    public EsdcTransactionConfigItem setIds(String ids) {
        this.ids = ids;
        return this;
    }

    public EsdcTransactionConfigItem setEventTypes(String eventTypes) {
        this.eventTypes = eventTypes;
        return this;
    }

    public EsdcTransactionConfigItem setConfigId(String configId) {
        this.configId = configId;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public String getEventType() {
        return this.eventType;
    }

    public String getParentEventType() {
        return this.parentEventType;
    }

    public String getParentEventName() {
        return this.parentEventName;
    }

    public String getEventName() {
        return this.eventName;
    }

    public Integer getEventLevel() {
        return this.eventLevel;
    }

    public String getParentId() {
        return this.parentId;
    }

    public String getIds() {
        return this.ids;
    }

    public String getEventTypes() {
        return this.eventTypes;
    }

    public String getConfigId() {
        return this.configId;
    }
}

