/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.esdc.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import java.io.Serializable;

@From(after="ESDC_DEVICE2PERSON t LEFT JOIN PERS_PERSON p ON t.PERSON_ID = p.ID")
@OrderBy(after="t.CREATE_TIME DESC")
@GridConfig(operate=true, idField="id")
public class EsdcDevice2PersonItem
extends BaseItem
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Column(name="t.ID")
    @GridColumn(checkbox=true, width="40", sort="na")
    private String id;
    @Column(name="t.DEVICE_ID")
    private String deviceId;
    @Column(name="p.PIN")
    @GridColumn(label="pers_person_pin", width="90", encryptMode="${pers.pin.encryptMode}", encryptProp="${pers.pin.encryptProp}")
    private String pin;
    @Column(name="p.NAME")
    @GridColumn(label="pers_person_name", width="120", encryptMode="${pers.name.encryptMode}", encryptProp="${pers.name.encryptProp}")
    private String name;
    @Column(name="t.PERSONNEL_LIST_ID")
    private String personnelListId;
    @Column(name="t.PERSON_ID")
    private String personId;
    @Column(name="t.STATUS")
    @GridColumn(label="common_status", width="60", format="0=common_failed,1=common_succeed")
    private String status;
    @Column(name="t.DESCRIPTION")
    @GridColumn(label="base_system_description", width="100")
    private String description;
    @Column(name="t.DEV_PERSON_ID")
    private String devPersonId;
    @Column(name="t.FACE_TOKEN")
    private String faceToken;
    @Column(name="t.DEVICE_TYPE")
    private String deviceType;
    @Condition(value="t.PERSON_ID", equalTag="in")
    private String personIdIn;
    @Condition(value="t.DEV_PERSON_ID", equalTag="in")
    private String devPersonIdIn;
    private String devPersonnelListId;
    @Condition(value="t.PERSON_ID", equalTag="not in")
    private String notInPersonId;
    @Condition(value="t.ID", equalTag="in")
    private String inId;

    public EsdcDevice2PersonItem() {
    }

    public EsdcDevice2PersonItem(String id) {
        this.id = id;
    }

    public EsdcDevice2PersonItem(String deviceId, String personnelListId, String description, String status, String personId, String devPersonId) {
        this.deviceId = deviceId;
        this.personnelListId = personnelListId;
        this.description = description;
        this.status = status;
        this.personId = personId;
        this.devPersonId = devPersonId;
    }

    public EsdcDevice2PersonItem setId(String id) {
        this.id = id;
        return this;
    }

    public EsdcDevice2PersonItem setDeviceId(String deviceId) {
        this.deviceId = deviceId;
        return this;
    }

    public EsdcDevice2PersonItem setPin(String pin) {
        this.pin = pin;
        return this;
    }

    public EsdcDevice2PersonItem setName(String name) {
        this.name = name;
        return this;
    }

    public EsdcDevice2PersonItem setPersonnelListId(String personnelListId) {
        this.personnelListId = personnelListId;
        return this;
    }

    public EsdcDevice2PersonItem setPersonId(String personId) {
        this.personId = personId;
        return this;
    }

    public EsdcDevice2PersonItem setStatus(String status) {
        this.status = status;
        return this;
    }

    public EsdcDevice2PersonItem setDescription(String description) {
        this.description = description;
        return this;
    }

    public EsdcDevice2PersonItem setDevPersonId(String devPersonId) {
        this.devPersonId = devPersonId;
        return this;
    }

    public EsdcDevice2PersonItem setFaceToken(String faceToken) {
        this.faceToken = faceToken;
        return this;
    }

    public EsdcDevice2PersonItem setDeviceType(String deviceType) {
        this.deviceType = deviceType;
        return this;
    }

    public EsdcDevice2PersonItem setPersonIdIn(String personIdIn) {
        this.personIdIn = personIdIn;
        return this;
    }

    public EsdcDevice2PersonItem setDevPersonIdIn(String devPersonIdIn) {
        this.devPersonIdIn = devPersonIdIn;
        return this;
    }

    public EsdcDevice2PersonItem setDevPersonnelListId(String devPersonnelListId) {
        this.devPersonnelListId = devPersonnelListId;
        return this;
    }

    public EsdcDevice2PersonItem setNotInPersonId(String notInPersonId) {
        this.notInPersonId = notInPersonId;
        return this;
    }

    public EsdcDevice2PersonItem setInId(String inId) {
        this.inId = inId;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public String getPin() {
        return this.pin;
    }

    public String getName() {
        return this.name;
    }

    public String getPersonnelListId() {
        return this.personnelListId;
    }

    public String getPersonId() {
        return this.personId;
    }

    public String getStatus() {
        return this.status;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDevPersonId() {
        return this.devPersonId;
    }

    public String getFaceToken() {
        return this.faceToken;
    }

    public String getDeviceType() {
        return this.deviceType;
    }

    public String getPersonIdIn() {
        return this.personIdIn;
    }

    public String getDevPersonIdIn() {
        return this.devPersonIdIn;
    }

    public String getDevPersonnelListId() {
        return this.devPersonnelListId;
    }

    public String getNotInPersonId() {
        return this.notInPersonId;
    }

    public String getInId() {
        return this.inId;
    }
}

