/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.esdc.vo;

import com.alibaba.fastjson.annotation.JSONField;
import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.GridOperate;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import java.io.Serializable;

@From(after="ESDC_CHANNEL t LEFT JOIN ESDC_DEVICE d ON d.ID = t.DEVICE_ID")
@OrderBy(after="t.CREATE_TIME DESC")
@GridConfig(operate=true, idField="id", minWidth="150", operates={@GridOperate(type="custom", permission="esdc:aiboxchannel:preview", click="esdcRtPreview", label="esdc_common_rt_preview"), @GridOperate(type="custom", permission="esdc:aiboxchannel:channelConfig", click="esdcChannelConfig", label="esdc_ai_box_channel_config")})
public class EsdcChannelItem
extends BaseItem
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Column(name="t.ID")
    @GridColumn(checkbox=true, width="40", sort="na")
    private String id;
    @GridColumn(columnType="ra", width="40", sortNo=0, align="center")
    private String ra;
    @Column(name="t.AUTH_AREA_ID")
    private String areaId;
    @Column(name="t.DEVICE_ID")
    private String deviceId;
    @Column(name="t.VIDEO_NO")
    @GridColumn(label="esdc_device_channel_code")
    private Integer videoNo;
    @Column(name="t.NAME")
    @GridColumn(label="common_dev_channelName", width="160")
    private String name;
    @JSONField(name="ip")
    @Column(name="t.IP_ADDRESS")
    @GridColumn(label="common_ipAddress", width="100")
    private String ipAddress;
    @Column(name="t.PORT")
    @GridColumn(label="esdc_aiBox_onvif_port", width="100")
    private Integer port;
    @Column(name="d.VENDOR")
    private String vendor;
    @JSONField(name="main_stream")
    @GridColumn(label="esdc_aiBox_main_stream", width="300")
    private String mainStream;
    @GridColumn(label="base_area_name", width="100")
    private String areaName;
    @GridColumn(label="common_status", width="80", columnType="custom", convert="esdcConvertConnectState")
    private String status;
    private Integer strategy;
    private Integer mode;
    @JSONField(name="add_mode")
    private Integer addMode;
    @JSONField(name="time_interval")
    private Integer timeInterval;
    @Condition(value="t.AUTH_AREA_ID", equalTag="in")
    private String areaIdIn;
    @JSONField(name="alg_id")
    private Integer algId;
    @GridColumn(label="esdc_param_algorithm_server_configuration", width="*")
    private String algName;
    private Integer enable;
    @JSONField(name="object_types")
    private String objectTypes;
    @GridColumn(label="esdc_storage_status", width="100", convert="EsdcConvertToIcon", columnType="custom", sort="na")
    private String videoStorageStatus;
    private String devAlias;
    @GridColumn(label="esdc_device_channel_code", width="*", show=false)
    private String channelCode;
    private String domainCode;
    @GridColumn(label="esdc_device_dev_type", width="150", show=false)
    private String deviceType;
    private String deviceSn;
    @GridColumn(label="base_area_name", width="200", sort="na", show=false)
    private String authAreaName;
    @GridColumn(label="esdc_device_auth_area_id", width="100", show=false)
    private String authAreaId;
    @GridColumn(label="esdc_device_user_name", width="100", show=false)
    private String userName;
    @GridColumn(label="esdc_device_password", width="100", show=false)
    private String passWord;
    private Boolean faceCapacity;
    @Condition(value="t.AUTH_AREA_ID IN (%s)", formatType="quote")
    private String authAreaIdIn;
    @Condition(value="t.ID", equalTag="in")
    private String ids;
    private int platformPort;
    private String notInId;
    @Condition(value="t.ID", equalTag="not in")
    private String idNotIn;
    @GridColumn(label="esdc_device_sourceModule", width="150", columnType="custom", convert="esdcConvertSourceModule")
    private String sourceModule;

    public EsdcChannelItem() {
    }

    public EsdcChannelItem(String id) {
        this.id = id;
    }

    public EsdcChannelItem setId(String id) {
        this.id = id;
        return this;
    }

    public EsdcChannelItem setRa(String ra) {
        this.ra = ra;
        return this;
    }

    public EsdcChannelItem setAreaId(String areaId) {
        this.areaId = areaId;
        return this;
    }

    public EsdcChannelItem setDeviceId(String deviceId) {
        this.deviceId = deviceId;
        return this;
    }

    public EsdcChannelItem setVideoNo(Integer videoNo) {
        this.videoNo = videoNo;
        return this;
    }

    public EsdcChannelItem setName(String name) {
        this.name = name;
        return this;
    }

    public EsdcChannelItem setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
        return this;
    }

    public EsdcChannelItem setPort(Integer port) {
        this.port = port;
        return this;
    }

    public EsdcChannelItem setVendor(String vendor) {
        this.vendor = vendor;
        return this;
    }

    public EsdcChannelItem setMainStream(String mainStream) {
        this.mainStream = mainStream;
        return this;
    }

    public EsdcChannelItem setAreaName(String areaName) {
        this.areaName = areaName;
        return this;
    }

    public EsdcChannelItem setStatus(String status) {
        this.status = status;
        return this;
    }

    public EsdcChannelItem setStrategy(Integer strategy) {
        this.strategy = strategy;
        return this;
    }

    public EsdcChannelItem setMode(Integer mode) {
        this.mode = mode;
        return this;
    }

    public EsdcChannelItem setAddMode(Integer addMode) {
        this.addMode = addMode;
        return this;
    }

    public EsdcChannelItem setTimeInterval(Integer timeInterval) {
        this.timeInterval = timeInterval;
        return this;
    }

    public EsdcChannelItem setAreaIdIn(String areaIdIn) {
        this.areaIdIn = areaIdIn;
        return this;
    }

    public EsdcChannelItem setAlgId(Integer algId) {
        this.algId = algId;
        return this;
    }

    public EsdcChannelItem setAlgName(String algName) {
        this.algName = algName;
        return this;
    }

    public EsdcChannelItem setEnable(Integer enable) {
        this.enable = enable;
        return this;
    }

    public EsdcChannelItem setObjectTypes(String objectTypes) {
        this.objectTypes = objectTypes;
        return this;
    }

    public EsdcChannelItem setVideoStorageStatus(String videoStorageStatus) {
        this.videoStorageStatus = videoStorageStatus;
        return this;
    }

    public EsdcChannelItem setDevAlias(String devAlias) {
        this.devAlias = devAlias;
        return this;
    }

    public EsdcChannelItem setChannelCode(String channelCode) {
        this.channelCode = channelCode;
        return this;
    }

    public EsdcChannelItem setDomainCode(String domainCode) {
        this.domainCode = domainCode;
        return this;
    }

    public EsdcChannelItem setDeviceType(String deviceType) {
        this.deviceType = deviceType;
        return this;
    }

    public EsdcChannelItem setDeviceSn(String deviceSn) {
        this.deviceSn = deviceSn;
        return this;
    }

    public EsdcChannelItem setAuthAreaName(String authAreaName) {
        this.authAreaName = authAreaName;
        return this;
    }

    public EsdcChannelItem setAuthAreaId(String authAreaId) {
        this.authAreaId = authAreaId;
        return this;
    }

    public EsdcChannelItem setUserName(String userName) {
        this.userName = userName;
        return this;
    }

    public EsdcChannelItem setPassWord(String passWord) {
        this.passWord = passWord;
        return this;
    }

    public EsdcChannelItem setFaceCapacity(Boolean faceCapacity) {
        this.faceCapacity = faceCapacity;
        return this;
    }

    public EsdcChannelItem setAuthAreaIdIn(String authAreaIdIn) {
        this.authAreaIdIn = authAreaIdIn;
        return this;
    }

    public EsdcChannelItem setIds(String ids) {
        this.ids = ids;
        return this;
    }

    public EsdcChannelItem setPlatformPort(int platformPort) {
        this.platformPort = platformPort;
        return this;
    }

    public EsdcChannelItem setNotInId(String notInId) {
        this.notInId = notInId;
        return this;
    }

    public EsdcChannelItem setIdNotIn(String idNotIn) {
        this.idNotIn = idNotIn;
        return this;
    }

    public EsdcChannelItem setSourceModule(String sourceModule) {
        this.sourceModule = sourceModule;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public String getRa() {
        return this.ra;
    }

    public String getAreaId() {
        return this.areaId;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public Integer getVideoNo() {
        return this.videoNo;
    }

    public String getName() {
        return this.name;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public Integer getPort() {
        return this.port;
    }

    public String getVendor() {
        return this.vendor;
    }

    public String getMainStream() {
        return this.mainStream;
    }

    public String getAreaName() {
        return this.areaName;
    }

    public String getStatus() {
        return this.status;
    }

    public Integer getStrategy() {
        return this.strategy;
    }

    public Integer getMode() {
        return this.mode;
    }

    public Integer getAddMode() {
        return this.addMode;
    }

    public Integer getTimeInterval() {
        return this.timeInterval;
    }

    public String getAreaIdIn() {
        return this.areaIdIn;
    }

    public Integer getAlgId() {
        return this.algId;
    }

    public String getAlgName() {
        return this.algName;
    }

    public Integer getEnable() {
        return this.enable;
    }

    public String getObjectTypes() {
        return this.objectTypes;
    }

    public String getVideoStorageStatus() {
        return this.videoStorageStatus;
    }

    public String getDevAlias() {
        return this.devAlias;
    }

    public String getChannelCode() {
        return this.channelCode;
    }

    public String getDomainCode() {
        return this.domainCode;
    }

    public String getDeviceType() {
        return this.deviceType;
    }

    public String getDeviceSn() {
        return this.deviceSn;
    }

    public String getAuthAreaName() {
        return this.authAreaName;
    }

    public String getAuthAreaId() {
        return this.authAreaId;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassWord() {
        return this.passWord;
    }

    public Boolean getFaceCapacity() {
        return this.faceCapacity;
    }

    public String getAuthAreaIdIn() {
        return this.authAreaIdIn;
    }

    public String getIds() {
        return this.ids;
    }

    public int getPlatformPort() {
        return this.platformPort;
    }

    public String getNotInId() {
        return this.notInId;
    }

    public String getIdNotIn() {
        return this.idNotIn;
    }

    public String getSourceModule() {
        return this.sourceModule;
    }
}

