/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ele.monitor;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.core.utils.DateUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.ele.constants.EleConstants;
import com.zkteco.zkbiosecurity.ele.service.EleDeviceService;
import com.zkteco.zkbiosecurity.ele.service.EleFloorService;
import com.zkteco.zkbiosecurity.ele.service.EleMonitorRedirectService;
import com.zkteco.zkbiosecurity.ele.service.EleParamsService;
import com.zkteco.zkbiosecurity.ele.service.EleRTMonitorService;
import com.zkteco.zkbiosecurity.ele.service.EleTransactionService;
import com.zkteco.zkbiosecurity.ele.vo.EleDeviceEventItem;
import com.zkteco.zkbiosecurity.ele.vo.EleDeviceMonitorItem;
import com.zkteco.zkbiosecurity.ele.vo.EleFloorItem;
import com.zkteco.zkbiosecurity.ele.vo.EleTransactionItem;
import com.zkteco.zkbiosecurity.pers.service.PersParamsService;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.simp.SimpMessagingTemplate;
import org.springframework.stereotype.Component;

@Component
public class EleMonitorRedirectServiceImpl
implements EleMonitorRedirectService {
    @Autowired
    private SimpMessagingTemplate messagingTemplate;
    @Autowired
    private EleDeviceService eleDeviceService;
    @Autowired
    private EleRTMonitorService eleRTMonitorService;
    @Autowired
    private EleFloorService eleFloorService;
    @Autowired
    private EleParamsService eleParamsService;
    @Autowired
    private PersParamsService persParamsService;
    @Autowired
    private EleTransactionService eleTransactionService;

    public void sendEleTransaction2RTMonitor(EleTransactionItem eleTransactionItem, Map<String, String> userData, EleDeviceEventItem tempDevEvent) {
        EleFloorItem eleFloor = this.eleFloorService.getItemById(eleTransactionItem.getEventPointId() + "");
        JSONObject ret = new JSONObject();
        JSONArray audios = new JSONArray();
        if (eleTransactionItem.getAudioFilePath() != null) {
            audios.add((Object)eleTransactionItem.getAudioFilePath());
        } else if (2 == eleTransactionItem.getEventLevel()) {
            audios.add((Object)"/public/media/sound/alarm.wav");
        } else {
            audios.add(null);
        }
        ret.put("audios", (Object)audios);
        JSONArray rows = new JSONArray();
        JSONObject row = new JSONObject();
        row.put("id", (Object)eleTransactionItem.getUniqueKey());
        this.encryptItemProps(eleTransactionItem);
        JSONObject userdata = this.buildUserDate(eleTransactionItem, userData);
        if (eleTransactionItem.getVidDevices() != null && eleTransactionItem.getVidDevices().size() > 0) {
            row.put("vidDescription", (Object)eleTransactionItem.getDescription());
            row.put("vidDevices", (Object)eleTransactionItem.getVidDevices());
        }
        row.put("userdata", (Object)userdata);
        row.put("style", (Object)(eleTransactionItem.getEventLevel() == 0 ? "color:green" : (eleTransactionItem.getEventLevel() == 1 ? "color:#E57A14" : "color:red")));
        row.put("dataLevel", (Object)eleTransactionItem.getEventLevel());
        JSONArray data = new JSONArray();
        data.add((Object)DateUtil.dateToString((Date)eleTransactionItem.getEventTime(), (DateUtil.DateStyle)DateUtil.DateStyle.YYYY_MM_DD_HH_MM_SS));
        data.add((Object)eleTransactionItem.getAreaName());
        data.add((Object)(eleTransactionItem.getDevAlias() != null ? eleTransactionItem.getDevAlias() + "(" + eleTransactionItem.getDevSn() + ")" : ""));
        data.add((Object)eleTransactionItem.getEventPointName());
        data.add((Object)eleTransactionItem.getFloorNoEx());
        if (eleTransactionItem.getEventNo().shortValue() == EleConstants.EVENT_LINKCONTROL.intValue() && !"".equals(eleTransactionItem.getDescription())) {
            data.add((Object)(eleTransactionItem.getEventName() + "(" + eleTransactionItem.getDescription() + ")"));
        } else {
            data.add((Object)eleTransactionItem.getEventName());
        }
        data.add((Object)eleTransactionItem.getCardNo());
        String name = this.eleTransactionService.getPersonAllName(eleTransactionItem.getName(), eleTransactionItem.getLastName());
        if (StringUtils.isNotBlank((CharSequence)name)) {
            name = "(" + name + ")";
        }
        data.add((Object)(eleTransactionItem.getPin() + name));
        data.add((Object)eleTransactionItem.getReaderName());
        data.add((Object)eleTransactionItem.getVerifyModeName());
        data.add((Object)(eleTransactionItem.getDevAlias() != null ? eleTransactionItem.getDevAlias() + "##" + eleTransactionItem.getDevSn() + "##" + eleTransactionItem.getEventPointName() + "##" + eleTransactionItem.getEventPointType() : ""));
        data.add((Object)(Objects.nonNull(eleFloor) ? eleFloor.getId() : ""));
        row.put("data", (Object)data);
        rows.add((Object)row);
        ret.put("rows", (Object)rows);
        this.messagingTemplate.convertAndSend((Object)"/topic/eleRTMonitor/getEventData", (Object)ret);
        this.messagingTemplate.convertAndSend((Object)"/topic/dashboardRTMonitor/getEventData", (Object)ret);
    }

    private void encryptItemProps(EleTransactionItem item) {
        item.setPin(this.persParamsService.getEncryptPin(item.getPin()));
        item.setName(this.persParamsService.getEncryptName(item.getName()));
        item.setLastName(this.persParamsService.getEncryptLastName(item.getLastName()));
        item.setCardNo(this.persParamsService.getEncryptCardNo(item.getCardNo()));
    }

    public JSONObject buildUserDate(EleTransactionItem eleTransactionItem, Map<String, String> userData) {
        JSONObject userdata = new JSONObject();
        userdata.put("photoPath", (Object)userData.get("photoPath"));
        if (StringUtils.isNotBlank((CharSequence)userData.get("photoPath"))) {
            String fileBase64 = this.eleParamsService.getAvatarBase64ByPath(userData.get("photoPath"));
            userdata.put("photoFile", (Object)("data:image/jpg;base64," + fileBase64));
        }
        userdata.put("status", (Object)(eleTransactionItem.getEventLevel() == 0 ? "normal" : (eleTransactionItem.getEventLevel() == 1 ? "warning" : "alarm")));
        userdata.put("isExistCardOp", (Object)(eleTransactionItem.getEventNo() == 27 && StringUtils.isNotBlank((CharSequence)eleTransactionItem.getCardNo()) && !StringUtils.isNotBlank((CharSequence)userData.get("photoPath")) ? 1 : 0));
        userdata.put("eventNo", (Object)eleTransactionItem.getEventNo());
        if (StringUtils.isNotBlank((CharSequence)eleTransactionItem.getVidLinkageHandle()) && !eleTransactionItem.getVidLinkageHandle().startsWith("/upload")) {
            JSONObject tranJson = JSONObject.parseObject((String)JSONObject.toJSONString((Object)eleTransactionItem));
            userdata.put("globalLinkageEvent", (Object)tranJson);
        }
        return userdata;
    }

    public void sendDeviceMonitor(EleDeviceMonitorItem eleDeviceMonitorItem) {
        JSONObject dxGrid = new JSONObject();
        dxGrid.put("pos", (Object)0);
        ArrayList<JSONObject> rows = new ArrayList<JSONObject>();
        JSONObject row = new JSONObject();
        String status = this.eleDeviceService.getStatus(eleDeviceMonitorItem.getDevSn());
        row.put("id", (Object)eleDeviceMonitorItem.getId());
        JSONObject userData = new JSONObject();
        userData.put("areaId", (Object)eleDeviceMonitorItem.getAreaId());
        userData.put("status", (Object)eleDeviceMonitorItem.getDevStatus());
        row.put("userdata", (Object)userData);
        if ("normal".equals(eleDeviceMonitorItem.getDevStatus())) {
            row.put("style", (Object)"color:green");
            row.put("dataLevel", (Object)0);
        } else if ("disable".equals(eleDeviceMonitorItem.getDevStatus())) {
            row.put("style", (Object)"color:#E57A14");
            row.put("dataLevel", (Object)1);
        } else {
            row.put("style", (Object)"color:red");
            row.put("dataLevel", (Object)2);
        }
        JSONArray data = new JSONArray();
        data.add((Object)eleDeviceMonitorItem.getDevName());
        data.add((Object)eleDeviceMonitorItem.getDevSn());
        data.add((Object)eleDeviceMonitorItem.getAreaName());
        data.add((Object)eleDeviceMonitorItem.getOpState());
        data.add((Object)eleDeviceMonitorItem.getCurState());
        data.add((Object)eleDeviceMonitorItem.getCmdCount());
        data.add((Object)(eleDeviceMonitorItem.getLastError().equals("") ? I18nUtil.i18nCode((String)"common_none", (Object[])new Object[0]) : eleDeviceMonitorItem.getLastError()));
        data.add((Object)"0,1");
        row.put("data", (Object)data);
        rows.add(row);
        dxGrid.put("rows", rows);
        dxGrid.put("total_count", (Object)rows.size());
        this.messagingTemplate.convertAndSend((Object)"/topic/eleDeviceMonitor/getDeviceEvents", (Object)dxGrid);
    }
}

