/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ele.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.ele.remote.EleTransactionPersonFloorRemote;
import com.zkteco.zkbiosecurity.ele.service.EleDeviceService;
import com.zkteco.zkbiosecurity.ele.service.EleFloorService;
import com.zkteco.zkbiosecurity.ele.vo.EleTransactionPersonFloorItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
public class EleTransactionPersonFloorController
extends ExportController
implements EleTransactionPersonFloorRemote {
    @Autowired
    private EleFloorService eleFloorService;
    @Autowired
    private EleDeviceService eleDeviceService;

    @RequiresPermissions(value={"ele:transactionByPerson:refresh"})
    public DxGrid list(EleTransactionPersonFloorItem condition) {
        Pager pager = this.eleFloorService.loadTransactionPersonFloorByAuthUserFilter(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"ele:transactionByPerson:export"})
    @LogRequest(module="ele_module", object="common_leftMenu_searchByPerson", opType="common_op_export", opContent="common_op_export")
    public void export(HttpServletRequest request, HttpServletResponse response) {
        EleTransactionPersonFloorItem eleTransactionPersonFloorItem = new EleTransactionPersonFloorItem();
        this.setConditionValue((BaseItem)eleTransactionPersonFloorItem);
        String userId = this.eleDeviceService.getUserIdBySessionId(request.getSession().getId());
        if (StringUtils.isNotBlank((CharSequence)userId)) {
            eleTransactionPersonFloorItem.setUserId(userId);
        }
        List itemList = this.eleFloorService.getPersonFloorItemData(EleTransactionPersonFloorItem.class, (BaseItem)eleTransactionPersonFloorItem, this.getBeginIndex(), this.getEndIndex());
        this.excelExport(itemList, EleTransactionPersonFloorItem.class);
    }
}

