/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ele.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.ele.remote.EleTransactionFloorPersonRemote;
import com.zkteco.zkbiosecurity.ele.service.ElePersonService;
import com.zkteco.zkbiosecurity.ele.vo.EleTransactionFloorPersonItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
public class EleTransactionFloorPersonController
extends ExportController
implements EleTransactionFloorPersonRemote {
    @Autowired
    private ElePersonService elePersonService;

    @RequiresPermissions(value={"ele:transactionByFloor:refresh"})
    public DxGrid list(EleTransactionFloorPersonItem condition) {
        Pager pager = this.elePersonService.loadFloorPersonByAuthUserFilter(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"ele:transactionByFloor:export"})
    @LogRequest(module="ele_module", object="ele_leftMenu_searchByFloor", opType="common_op_export", opContent="common_op_export")
    public void export(HttpServletRequest request, HttpServletResponse response) {
        EleTransactionFloorPersonItem eleTransactionFloorPersonItem = new EleTransactionFloorPersonItem();
        this.setConditionValue((BaseItem)eleTransactionFloorPersonItem);
        List itemList = this.elePersonService.getFloorPersonItemData(request.getSession().getId(), eleTransactionFloorPersonItem, this.getBeginIndex(), this.getEndIndex());
        this.excelExport(itemList, EleTransactionFloorPersonItem.class);
    }
}

