/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ele.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.SelectItem;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.DateUtil;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.ele.remote.EleTimeSegRemote;
import com.zkteco.zkbiosecurity.ele.service.EleTimeSegService;
import com.zkteco.zkbiosecurity.ele.vo.EleTimeSegItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class EleTimeSegController
extends BaseController
implements EleTimeSegRemote {
    private final int maxTimeSegCount = 255;
    @Autowired
    private EleTimeSegService eleTimeSegService;

    @RequiresPermissions(value={"ele:timeSeg"})
    public ModelAndView index() {
        return new ModelAndView("ele/timeSeg/eleTimeSeg");
    }

    @RequiresPermissions(value={"ele:timeSeg:add", "ele:timeSeg:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.eleTimeSegService.getItemById(id));
        }
        return new ModelAndView("ele/timeSeg/editEleTimeSeg");
    }

    @RequiresPermissions(value={"ele:timeSeg:add", "ele:timeSeg:edit"})
    @LogRequest(module="ele_module", object="common_leftMenu_timeZone", opType="common_op_edit", requestParams={"name"}, opContent="common_timeSeg_name")
    public ZKResultMsg save(EleTimeSegItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.eleTimeSegService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"ele:timeSeg:refresh"})
    public DxGrid list(EleTimeSegItem condition) {
        Pager pager = this.eleTimeSegService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"ele:timeSeg:del"})
    @LogRequest(module="ele_module", object="common_leftMenu_timeZone", opType="common_op_del", requestParams={"names"}, opContent="common_timeSeg_name")
    public ZKResultMsg del(String ids) {
        this.eleTimeSegService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public ZKResultMsg getAllTimeSeg() {
        ArrayList<SelectItem> selectItems = new ArrayList<SelectItem>();
        SelectItem selectItem = null;
        List items = this.eleTimeSegService.getByCondition(new EleTimeSegItem());
        for (EleTimeSegItem eleTimeSegItem : items) {
            selectItem = new SelectItem();
            selectItem.setValue(eleTimeSegItem.getId());
            selectItem.setText((Object)eleTimeSegItem.getName());
            selectItems.add(selectItem);
        }
        return new ZKResultMsg(selectItems);
    }

    public boolean isExist(String name) {
        return this.eleTimeSegService.isExist(name);
    }

    public ZKResultMsg dataValid(EleTimeSegItem eleTimeSegItem) {
        ZKResultMsg resultMsg = new ZKResultMsg();
        String result = "true";
        String checkResult = this.checkTimeseg(eleTimeSegItem.getMondayStart1(), I18nUtil.i18nCode((String)"common_timeSeg_mondayStart1", (Object[])new Object[0]), eleTimeSegItem.getMondayEnd1(), I18nUtil.i18nCode((String)"common_timeSeg_mondayEnd1", (Object[])new Object[0]), eleTimeSegItem.getMondayStart2(), I18nUtil.i18nCode((String)"common_timeSeg_mondayStart2", (Object[])new Object[0]), eleTimeSegItem.getMondayEnd2(), I18nUtil.i18nCode((String)"common_timeSeg_mondayEnd2", (Object[])new Object[0]), eleTimeSegItem.getMondayStart3(), I18nUtil.i18nCode((String)"common_timeSeg_mondayStart3", (Object[])new Object[0]), eleTimeSegItem.getMondayEnd3(), I18nUtil.i18nCode((String)"common_timeSeg_mondayEnd3", (Object[])new Object[0]));
        if (checkResult != null) {
            resultMsg.setData((Object)checkResult);
            return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
        }
        checkResult = this.checkTimeseg(eleTimeSegItem.getTuesdayStart1(), I18nUtil.i18nCode((String)"common_timeSeg_tuesdayStart1", (Object[])new Object[0]), eleTimeSegItem.getTuesdayEnd1(), I18nUtil.i18nCode((String)"common_timeSeg_tuesdayEnd1", (Object[])new Object[0]), eleTimeSegItem.getTuesdayStart2(), I18nUtil.i18nCode((String)"common_timeSeg_tuesdayStart2", (Object[])new Object[0]), eleTimeSegItem.getTuesdayEnd2(), I18nUtil.i18nCode((String)"common_timeSeg_tuesdayEnd2", (Object[])new Object[0]), eleTimeSegItem.getTuesdayStart3(), I18nUtil.i18nCode((String)"common_timeSeg_tuesdayStart3", (Object[])new Object[0]), eleTimeSegItem.getTuesdayEnd3(), I18nUtil.i18nCode((String)"common_timeSeg_tuesdayEnd3", (Object[])new Object[0]));
        if (checkResult != null) {
            resultMsg.setData((Object)checkResult);
            return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
        }
        checkResult = this.checkTimeseg(eleTimeSegItem.getWednesdayStart1(), I18nUtil.i18nCode((String)"common_timeSeg_wednesdayStart1", (Object[])new Object[0]), eleTimeSegItem.getWednesdayEnd1(), I18nUtil.i18nCode((String)"common_timeSeg_wednesdayEnd1", (Object[])new Object[0]), eleTimeSegItem.getWednesdayStart2(), I18nUtil.i18nCode((String)"common_timeSeg_wednesdayStart2", (Object[])new Object[0]), eleTimeSegItem.getWednesdayEnd2(), I18nUtil.i18nCode((String)"common_timeSeg_wednesdayEnd2", (Object[])new Object[0]), eleTimeSegItem.getWednesdayStart3(), I18nUtil.i18nCode((String)"common_timeSeg_wednesdayStart3", (Object[])new Object[0]), eleTimeSegItem.getWednesdayEnd3(), I18nUtil.i18nCode((String)"common_timeSeg_wednesdayEnd3", (Object[])new Object[0]));
        if (checkResult != null) {
            resultMsg.setData((Object)checkResult);
            return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
        }
        checkResult = this.checkTimeseg(eleTimeSegItem.getThursdayStart1(), I18nUtil.i18nCode((String)"common_timeSeg_thursdayStart1", (Object[])new Object[0]), eleTimeSegItem.getThursdayEnd1(), I18nUtil.i18nCode((String)"common_timeSeg_thursdayEnd1", (Object[])new Object[0]), eleTimeSegItem.getThursdayStart2(), I18nUtil.i18nCode((String)"common_timeSeg_thursdayStart2", (Object[])new Object[0]), eleTimeSegItem.getThursdayEnd2(), I18nUtil.i18nCode((String)"common_timeSeg_thursdayEnd2", (Object[])new Object[0]), eleTimeSegItem.getThursdayStart3(), I18nUtil.i18nCode((String)"common_timeSeg_thursdayStart3", (Object[])new Object[0]), eleTimeSegItem.getThursdayEnd3(), I18nUtil.i18nCode((String)"common_timeSeg_thursdayEnd3", (Object[])new Object[0]));
        if (checkResult != null) {
            resultMsg.setData((Object)checkResult);
            return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
        }
        checkResult = this.checkTimeseg(eleTimeSegItem.getFridayStart1(), I18nUtil.i18nCode((String)"common_timeSeg_fridayStart1", (Object[])new Object[0]), eleTimeSegItem.getFridayEnd1(), I18nUtil.i18nCode((String)"common_timeSeg_fridayEnd1", (Object[])new Object[0]), eleTimeSegItem.getFridayStart2(), I18nUtil.i18nCode((String)"common_timeSeg_fridayStart2", (Object[])new Object[0]), eleTimeSegItem.getFridayEnd2(), I18nUtil.i18nCode((String)"common_timeSeg_fridayEnd2", (Object[])new Object[0]), eleTimeSegItem.getFridayStart3(), I18nUtil.i18nCode((String)"common_timeSeg_fridayStart3", (Object[])new Object[0]), eleTimeSegItem.getFridayEnd3(), I18nUtil.i18nCode((String)"common_timeSeg_fridayEnd3", (Object[])new Object[0]));
        if (checkResult != null) {
            resultMsg.setData((Object)checkResult);
            return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
        }
        checkResult = this.checkTimeseg(eleTimeSegItem.getSaturdayStart1(), I18nUtil.i18nCode((String)"common_timeSeg_saturdayStart1", (Object[])new Object[0]), eleTimeSegItem.getSaturdayEnd1(), I18nUtil.i18nCode((String)"common_timeSeg_saturdayEnd1", (Object[])new Object[0]), eleTimeSegItem.getSaturdayStart2(), I18nUtil.i18nCode((String)"common_timeSeg_saturdayStart2", (Object[])new Object[0]), eleTimeSegItem.getSaturdayEnd2(), I18nUtil.i18nCode((String)"common_timeSeg_saturdayEnd2", (Object[])new Object[0]), eleTimeSegItem.getSaturdayStart3(), I18nUtil.i18nCode((String)"common_timeSeg_saturdayStart3", (Object[])new Object[0]), eleTimeSegItem.getSaturdayEnd3(), I18nUtil.i18nCode((String)"common_timeSeg_saturdayEnd3", (Object[])new Object[0]));
        if (checkResult != null) {
            resultMsg.setData((Object)checkResult);
            return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
        }
        checkResult = this.checkTimeseg(eleTimeSegItem.getSundayStart1(), I18nUtil.i18nCode((String)"common_timeSeg_sundayStart1", (Object[])new Object[0]), eleTimeSegItem.getSundayEnd1(), I18nUtil.i18nCode((String)"common_timeSeg_sundayEnd1", (Object[])new Object[0]), eleTimeSegItem.getSundayStart2(), I18nUtil.i18nCode((String)"common_timeSeg_sundayStart2", (Object[])new Object[0]), eleTimeSegItem.getSundayEnd2(), I18nUtil.i18nCode((String)"common_timeSeg_sundayEnd2", (Object[])new Object[0]), eleTimeSegItem.getSundayStart3(), I18nUtil.i18nCode((String)"common_timeSeg_sundayStart3", (Object[])new Object[0]), eleTimeSegItem.getSundayEnd3(), I18nUtil.i18nCode((String)"common_timeSeg_sundayEnd3", (Object[])new Object[0]));
        if (checkResult != null) {
            resultMsg.setData((Object)checkResult);
            return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
        }
        checkResult = this.checkTimeseg(eleTimeSegItem.getHolidayType1Start1(), I18nUtil.i18nCode((String)"common_timeSeg_holidaytype1Start1", (Object[])new Object[0]), eleTimeSegItem.getHolidayType1End1(), I18nUtil.i18nCode((String)"common_timeSeg_holidaytype1End1", (Object[])new Object[0]), eleTimeSegItem.getHolidayType1Start2(), I18nUtil.i18nCode((String)"common_timeSeg_holidaytype1Start2", (Object[])new Object[0]), eleTimeSegItem.getHolidayType1End2(), I18nUtil.i18nCode((String)"common_timeSeg_holidaytype1End2", (Object[])new Object[0]), eleTimeSegItem.getHolidayType1Start3(), I18nUtil.i18nCode((String)"common_timeSeg_holidaytype1Start3", (Object[])new Object[0]), eleTimeSegItem.getHolidayType1End3(), I18nUtil.i18nCode((String)"common_timeSeg_holidaytype1End3", (Object[])new Object[0]));
        if (checkResult != null) {
            resultMsg.setData((Object)checkResult);
            return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
        }
        checkResult = this.checkTimeseg(eleTimeSegItem.getHolidayType2Start1(), I18nUtil.i18nCode((String)"common_timeSeg_holidaytype2Start1", (Object[])new Object[0]), eleTimeSegItem.getHolidayType2End1(), I18nUtil.i18nCode((String)"common_timeSeg_holidaytype2End1", (Object[])new Object[0]), eleTimeSegItem.getHolidayType2Start2(), I18nUtil.i18nCode((String)"common_timeSeg_holidaytype2Start2", (Object[])new Object[0]), eleTimeSegItem.getHolidayType2End2(), I18nUtil.i18nCode((String)"common_timeSeg_holidaytype2End2", (Object[])new Object[0]), eleTimeSegItem.getHolidayType2Start3(), I18nUtil.i18nCode((String)"common_timeSeg_holidaytype2Start3", (Object[])new Object[0]), eleTimeSegItem.getHolidayType2End3(), I18nUtil.i18nCode((String)"common_timeSeg_holidaytype2End3", (Object[])new Object[0]));
        if (checkResult != null) {
            resultMsg.setData((Object)checkResult);
            return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
        }
        checkResult = this.checkTimeseg(eleTimeSegItem.getHolidayType3Start1(), I18nUtil.i18nCode((String)"common_timeSeg_holidaytype3Start1", (Object[])new Object[0]), eleTimeSegItem.getHolidayType3End1(), I18nUtil.i18nCode((String)"common_timeSeg_holidaytype3End1", (Object[])new Object[0]), eleTimeSegItem.getHolidayType3Start2(), I18nUtil.i18nCode((String)"common_timeSeg_holidaytype3Start2", (Object[])new Object[0]), eleTimeSegItem.getHolidayType3End2(), I18nUtil.i18nCode((String)"common_timeSeg_holidaytype3End2", (Object[])new Object[0]), eleTimeSegItem.getHolidayType3Start3(), I18nUtil.i18nCode((String)"common_timeSeg_holidaytype3Start3", (Object[])new Object[0]), eleTimeSegItem.getHolidayType3End3(), I18nUtil.i18nCode((String)"common_timeSeg_holidaytype3End3", (Object[])new Object[0]));
        if (checkResult != null) {
            resultMsg.setData((Object)checkResult);
            return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
        }
        resultMsg.setData((Object)result);
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }

    private String checkTimeseg(String start1, String start1Vname, String end1, String end1Vname, String start2, String start2Vname, String end2, String end2Vname, String start3, String start3Vname, String end3, String end3Vname) {
        String checkResult = this.checkStartEndTime(start1, start1Vname, end1, end1Vname);
        if (checkResult != null) {
            return checkResult;
        }
        checkResult = this.checkStartEndTime(start2, start2Vname, end2, end2Vname);
        if (checkResult != null) {
            return checkResult;
        }
        checkResult = this.checkStartEndTime(start3, start3Vname, end3, end3Vname);
        if (checkResult != null) {
            return checkResult;
        }
        if (start1.equals("00:00") && end1.equals("00:00")) {
            if (!start2.equals("00:00")) {
                return I18nUtil.i18nCode((String)"common_timeSeg_fillError1", (Object[])new Object[]{start2Vname});
            }
            if (!end2.equals("00:00")) {
                return I18nUtil.i18nCode((String)"common_timeSeg_fillError1", (Object[])new Object[]{end2Vname});
            }
            if (!start3.equals("00:00")) {
                return I18nUtil.i18nCode((String)"common_timeSeg_fillError1", (Object[])new Object[]{start3Vname});
            }
            if (!end3.equals("00:00")) {
                return I18nUtil.i18nCode((String)"common_timeSeg_fillError1", (Object[])new Object[]{end3Vname});
            }
        } else if (start2.toString().equals("00:00") && end2.toString().equals("00:00")) {
            if (!start3.toString().equals("00:00")) {
                return I18nUtil.i18nCode((String)"common_timeSeg_fillError2", (Object[])new Object[]{start3Vname});
            }
            if (!end3.toString().equals("00:00")) {
                return I18nUtil.i18nCode((String)"common_timeSeg_fillError2", (Object[])new Object[]{end3Vname});
            }
        } else {
            if (DateUtil.stringToDate((String)start2, (DateUtil.DateStyle)DateUtil.DateStyle.HH_MM).getTime() <= DateUtil.stringToDate((String)end1, (DateUtil.DateStyle)DateUtil.DateStyle.HH_MM).getTime()) {
                return I18nUtil.i18nCode((String)"common_timeSeg_fillError3", (Object[])new Object[]{start2Vname, end1Vname});
            }
            if (!end3.equals("00:00") && DateUtil.stringToDate((String)start3, (DateUtil.DateStyle)DateUtil.DateStyle.HH_MM).getTime() <= DateUtil.stringToDate((String)end2, (DateUtil.DateStyle)DateUtil.DateStyle.HH_MM).getTime()) {
                return I18nUtil.i18nCode((String)"common_timeSeg_fillError3", (Object[])new Object[]{start3Vname, end2Vname});
            }
        }
        return null;
    }

    private String checkStartEndTime(String startTime, String startVname, String endTime, String endVname) {
        Date startDate = DateUtil.stringToDate((String)startTime, (DateUtil.DateStyle)DateUtil.DateStyle.HH_MM);
        Date endDate = DateUtil.stringToDate((String)endTime, (DateUtil.DateStyle)DateUtil.DateStyle.HH_MM);
        if (startDate.getTime() > endDate.getTime()) {
            return I18nUtil.i18nCode((String)"common_timeSeg_fillError4", (Object[])new Object[]{startVname, endVname});
        }
        if (startDate.getTime() == endDate.getTime() && !startTime.toString().equals("00:00")) {
            return I18nUtil.i18nCode((String)"common_timeSeg_fillError5", (Object[])new Object[]{startVname, endVname});
        }
        return null;
    }

    public ZKResultMsg getTimeSegList() {
        return new ZKResultMsg((Object)this.eleTimeSegService.getTimeSegList());
    }
}

