/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ele.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.TreeItem;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.format.TreeBuilder;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.ele.remote.EleServiceConfigRemote;
import com.zkteco.zkbiosecurity.ele.service.EleReaderMaskService;
import com.zkteco.zkbiosecurity.ele.service.EleServiceConfigService;
import com.zkteco.zkbiosecurity.ele.vo.EleReaderMaskInfoItem;
import com.zkteco.zkbiosecurity.ele.vo.EleReaderMaskItem;
import com.zkteco.zkbiosecurity.ele.vo.EleServiceConfigItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class EleServiceConfigController
extends BaseController
implements EleServiceConfigRemote {
    @Autowired
    private EleServiceConfigService eleServiceConfigService;
    @Autowired
    private EleReaderMaskService eleReaderMaskService;

    public ModelAndView index() {
        return new ModelAndView("ele/serviceConfig/eleServiceConfig");
    }

    @RequiresPermissions(value={"ele:serviceConfig:add", "ele:serviceConfig:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.eleServiceConfigService.getItemById(id));
        }
        return new ModelAndView("ele/serviceConfig/editEleServiceConfig");
    }

    @RequiresPermissions(value={"ele:serviceConfig:add", "ele:serviceConfig:edit"})
    @LogRequest(module="ele_module", object="ele_leftMenu_serviceConfig", opType="common_op_edit", requestParams={"name"}, opContent="ele_serviceConfig_name")
    public ZKResultMsg save(EleServiceConfigItem item) {
        ZKResultMsg res = this.eleServiceConfigService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"ele:serviceConfig:refresh"})
    public DxGrid list(EleServiceConfigItem condition) {
        Pager pager = this.eleServiceConfigService.loadPagerByAuthFilter(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"ele:serviceConfig:del"})
    @LogRequest(module="ele_module", object="ele_leftMenu_serviceConfig", opType="common_op_del", requestParams={"name"}, opContent="ele_serviceConfig_name")
    public ZKResultMsg delete(String ids) {
        this.eleServiceConfigService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public boolean isExistName(String name) {
        return this.eleServiceConfigService.isExistName(name);
    }

    public ZKResultMsg getManufacturerList() {
        return new ZKResultMsg((Object)this.eleServiceConfigService.getLicenseManufacturerList());
    }

    public ZKResultMsg getInternalManufacturerList() {
        return new ZKResultMsg((Object)this.eleServiceConfigService.getInternalManufacturerList());
    }

    public boolean isExistServerIp(String serverIp) {
        return this.eleServiceConfigService.isExistServerIp(serverIp);
    }

    public boolean isExistBackupServerIp(String backupServerIp) {
        return this.eleServiceConfigService.isExistServerIp(backupServerIp);
    }

    public ZKResultMsg getServiceConfigSelectItemList() {
        List selectItemList = this.eleServiceConfigService.getServiceConfigSelectItemList();
        return new ZKResultMsg((Object)selectItemList);
    }

    @RequiresPermissions(value={"ele:serviceConfig:externalGlobalMask"})
    public ModelAndView editExternalReaderGlobalMask(String id) {
        this.setReaderGlobalMaskInfo(id);
        return new ModelAndView("ele/serviceConfig/editEleReaderMask");
    }

    @RequiresPermissions(value={"ele:serviceConfig:internalGlobalMask"})
    public ModelAndView editInternalReaderGlobalMask(String id) {
        this.setReaderGlobalMaskInfo(id);
        return new ModelAndView("ele/serviceConfig/editEleReaderMask");
    }

    private void setReaderGlobalMaskInfo(String serviceConfigId) {
        String readerType = this.request.getParameter("readerType");
        EleReaderMaskItem condition = new EleReaderMaskItem();
        condition.setServiceConfigId(serviceConfigId);
        condition.setReaderId(null);
        condition.setReaderType(readerType);
        List maskItemList = this.eleReaderMaskService.getByCondition(condition);
        Map<String, List<EleReaderMaskItem>> globalMaskMap = maskItemList.stream().filter(item -> StringUtils.isBlank((CharSequence)item.getReaderId())).collect(Collectors.groupingBy(EleReaderMaskItem::getStatus));
        for (String status : globalMaskMap.keySet()) {
            List<EleReaderMaskItem> globalMaskItemList = globalMaskMap.get(status);
            globalMaskItemList.sort(Comparator.comparingInt(o -> Integer.parseInt(o.getFloorNo().toString())));
            if ("1".equals(status)) {
                this.request.setAttribute("onlineMask", globalMaskItemList);
                continue;
            }
            this.request.setAttribute("offlineMask", globalMaskItemList);
        }
        this.request.setAttribute("serviceConfigId", (Object)serviceConfigId);
        this.request.setAttribute("manufacturer", (Object)this.request.getParameter("manufacturer"));
        this.request.setAttribute("readerType", (Object)readerType);
    }

    public ZKResultMsg saveReaderMask(EleReaderMaskInfoItem item) {
        ZKResultMsg resultMsg = this.eleReaderMaskService.saveReaderMaskInfo(item);
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }

    public TreeItem getServiceFloorTreeList() {
        List items = this.eleServiceConfigService.createServiceFloorTree(this.request.getSession().getId());
        List treeItems = TreeBuilder.newTreeBuilder(TreeItem.class, String.class).buildToTreeList((Collection)items);
        return new TreeItem("0", treeItems);
    }

    public ZKResultMsg getCallTypeByManufacturer(String manufacturer) {
        List selectItemList = this.eleServiceConfigService.getCallTypeByManufacturer(manufacturer);
        return new ZKResultMsg((Object)selectItemList);
    }

    public TreeItem getServiceTreeList() {
        List items = this.eleServiceConfigService.createServiceTree(this.request.getSession().getId());
        List treeItems = TreeBuilder.newTreeBuilder(TreeItem.class, String.class).buildToTreeList((Collection)items);
        return new TreeItem("0", treeItems);
    }

    public ZKResultMsg getSourceSideList(String manufacturer) {
        return new ZKResultMsg((Object)this.eleServiceConfigService.getSourceSideList(manufacturer));
    }
}

