/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ele.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.ele.remote.EleReaderRemote;
import com.zkteco.zkbiosecurity.ele.service.EleDeviceOptionService;
import com.zkteco.zkbiosecurity.ele.service.EleDeviceVerifyModeService;
import com.zkteco.zkbiosecurity.ele.service.EleReaderOptionService;
import com.zkteco.zkbiosecurity.ele.service.EleReaderService;
import com.zkteco.zkbiosecurity.ele.vo.EleDeviceOptionItem;
import com.zkteco.zkbiosecurity.ele.vo.EleReaderItem;
import com.zkteco.zkbiosecurity.ele.vo.EleReaderOptionItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class EleReaderController
extends BaseController
implements EleReaderRemote {
    @Autowired
    private EleReaderService eleReaderService;
    @Autowired
    private EleDeviceOptionService eleDeviceOptionService;
    @Autowired
    private EleDeviceVerifyModeService eleDeviceVerifyModeService;
    @Autowired
    private EleReaderOptionService eleReaderOptionService;

    @RequiresPermissions(value={"ele:reader"})
    public ModelAndView index() {
        return new ModelAndView("ele/reader/eleReader");
    }

    @RequiresPermissions(value={"ele:reader:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            String newVFModeNos;
            EleReaderItem item;
            EleReaderOptionItem infoReveal = this.eleReaderOptionService.getByReaderIdAndOptName((item = this.eleReaderService.getItemById(id)).getId(), "IsSupportInfoReveal");
            item.setUserInfoReveal(infoReveal != null ? infoReveal.getValue() : "0");
            this.request.setAttribute("item", (Object)item);
            String deviceSn = item.getDeviceSn();
            boolean isSupportNewVerifyStyle = this.eleDeviceOptionService.isContainDevParam(deviceSn, "NewVFStyles");
            if (isSupportNewVerifyStyle && StringUtils.isNotBlank((CharSequence)(newVFModeNos = this.eleDeviceVerifyModeService.getVerifyModeNosByNewVFStyles(item.getVerifyMode() + "")))) {
                String verifyStyleLogic = String.valueOf(0).equals(newVFModeNos.split(",")[0]) ? "1" : "0";
                this.request.setAttribute("verifyStyleLogic", (Object)verifyStyleLogic);
                this.request.setAttribute("newVFStyles", (Object)newVFModeNos);
            }
            this.request.setAttribute("isSupportConfig", (Object)this.eleDeviceOptionService.isSupportFunList(deviceSn, 18));
            this.request.setAttribute("isSupportWgOrRS485", (Object)this.eleDeviceOptionService.isSupportFunList(deviceSn, 32));
            EleDeviceOptionItem devOpt = this.eleDeviceOptionService.getDevOptValueBySnAndName(deviceSn, "SupportReaderType");
            if (devOpt != null) {
                this.request.setAttribute("supportReaderType", (Object)devOpt.getValue());
            }
            if (this.eleDeviceOptionService.isSupportFunList(deviceSn, 1)) {
                this.request.setAttribute("encrypt", (Object)true);
            }
            this.request.setAttribute("isSupportInfoReveal", (Object)this.eleDeviceOptionService.isSupportFunList(deviceSn, 51));
            if (this.eleDeviceOptionService.isSupportFunList(deviceSn, 49)) {
                this.request.setAttribute("supportOSDP", (Object)true);
            }
        }
        return new ModelAndView("ele/reader/editEleReader");
    }

    @RequiresPermissions(value={"ele:reader:edit"})
    @LogRequest(module="ele_module", object="common_leftMenu_reader", opType="common_op_edit", requestParams={"name"}, opContent="ele_reader_name")
    public ZKResultMsg save(EleReaderItem item) {
        ZKResultMsg res = new ZKResultMsg();
        String applyTo = this.request.getParameter("applyTo");
        this.eleReaderService.saveReader(item, applyTo, this.request.getSession().getId());
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"ele:reader:refresh"})
    public DxGrid list(EleReaderItem condition) {
        Pager pager = this.eleReaderService.loadPagerByAuthFilter(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"ele:reader:del"})
    public ZKResultMsg del(String ids) {
        this.eleReaderService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public boolean isExist(EleReaderItem item) {
        return this.eleReaderService.isExist(item.getName());
    }

    public boolean isExistIp(EleReaderItem item) {
        return this.eleReaderService.isExistIp(item.getIp());
    }

    public ZKResultMsg getWiegandFmtList() {
        List selectItemList = this.eleReaderService.getWiegandFmtList();
        return new ZKResultMsg((Object)selectItemList);
    }
}

