/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ele.controller;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.ele.remote.EleRTMonitorRemote;
import com.zkteco.zkbiosecurity.ele.service.EleBaseDictionaryService;
import com.zkteco.zkbiosecurity.ele.service.EleDeviceService;
import com.zkteco.zkbiosecurity.ele.service.EleParamsService;
import com.zkteco.zkbiosecurity.ele.service.EleRTMonitorService;
import com.zkteco.zkbiosecurity.pers.service.PersParamsService;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.Map;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class EleRTMonitorController
extends ExportController
implements EleRTMonitorRemote {
    @Autowired
    private EleDeviceService eleDeviceService;
    @Autowired
    private EleRTMonitorService eleRTMonitorService;
    @Autowired
    private EleBaseDictionaryService eleBaseDictionaryService;
    @Autowired
    private EleParamsService eleParamService;
    @Autowired
    private PersParamsService persParamsService;

    @RequiresPermissions(value={"ele:rtMonitor", "ele:rtMonitor:browse"})
    public ModelAndView index() {
        String loadPlugins = (String)this.eleParamService.getVidParams().get("vid.loadPlugins");
        String personPhotoMaxHeight = this.eleParamService.getValByName("ele.personPhotoMaxHeight");
        boolean isEnableCardNoEncrypt = this.persParamsService.getEncryptPropByParamName("pers.cardNo.encryptProp");
        this.request.setAttribute("loadPlugins", (Object)loadPlugins);
        this.request.setAttribute("personPhotoMaxHeight", (Object)personPhotoMaxHeight);
        this.request.setAttribute("isEnableCardNoEncrypt", (Object)isEnableCardNoEncrypt);
        return new ModelAndView("ele/rtMonitor/eleRTMonitor");
    }

    @RequiresPermissions(value={"ele:rtMonitor:openFloor", "ele:rtMonitor:closeFloor"})
    public ModelAndView remoteOperate() {
        String opType = this.request.getParameter("opType");
        this.request.setAttribute("opType", (Object)opType);
        return new ModelAndView("ele/rtMonitor/opEleRemoteOperate");
    }

    @RequiresPermissions(value={"ele:rtMonitor:cancelEmergency"})
    public ModelAndView cancelEmergencyView() {
        String opType = this.request.getParameter("opType");
        this.request.setAttribute("opType", (Object)opType);
        return new ModelAndView("ele/rtMonitor/opEleCancelEmergency");
    }

    @LogRequest(module="ele_module", object="common_leftMenu_rtMonitor", opType="ele_eventNo_8", requestParams={"floorName"}, opContent="ele_floor_name")
    @RequiresPermissions(value={"ele:rtMonitor:openFloor"})
    public ZKResultMsg openFloor(String ids, String interval) {
        Map dataMap = this.eleRTMonitorService.operateFloor("openFloor", interval, ids);
        return this.dealResultData(dataMap);
    }

    @LogRequest(module="ele_module", object="common_leftMenu_rtMonitor", opType="ele_eventNo_11", requestParams={"floorName"}, opContent="ele_floor_name")
    @RequiresPermissions(value={"ele:rtMonitor:enableNormalOpenFloor"})
    public ZKResultMsg enableNormalOpenFloor(String ids) {
        Map dataMap = this.eleRTMonitorService.operateFloor("enableNormalOpenFloor", null, ids);
        return this.dealResultData(dataMap);
    }

    @LogRequest(module="ele_module", object="common_leftMenu_rtMonitor", opType="ele_eventNo_205", requestParams={"floorName"}, opContent="ele_floor_name")
    @RequiresPermissions(value={"ele:rtMonitor:normalOpenFloor"})
    public ZKResultMsg normalOpenFloor(String ids) {
        Map dataMap = this.eleRTMonitorService.operateFloor("normalOpenFloor", null, ids);
        return this.dealResultData(dataMap);
    }

    @RequiresPermissions(value={"ele:rtMonitor:closeFloor"})
    @LogRequest(module="ele_module", object="common_leftMenu_rtMonitor", opType="ele_eventNo_9", requestParams={"floorName"}, opContent="ele_floor_name")
    public ZKResultMsg closeFloor(String ids) {
        Map dataMap = this.eleRTMonitorService.operateFloor("closeFloor", null, ids);
        return this.dealResultData(dataMap);
    }

    @RequiresPermissions(value={"ele:rtMonitor:cancelEmergency"})
    @LogRequest(module="ele_module", object="common_leftMenu_rtMonitor", opType="ele_rtm_cancelEmergency", requestParams={"devName"}, opContent="common_dev_name")
    public ZKResultMsg cancelEmergency(String ids) {
        Map dataMap = this.eleRTMonitorService.cancelEmergency("cancelEmergency", null, ids);
        return this.dealResultData(dataMap);
    }

    @LogRequest(module="ele_module", object="common_leftMenu_rtMonitor", opType="ele_eventNo_10", requestParams={"floorName"}, opContent="ele_floor_name")
    @RequiresPermissions(value={"ele:rtMonitor:disableNormalOpenFloor"})
    public ZKResultMsg disableNormalOpenFloor(String ids) {
        Map dataMap = this.eleRTMonitorService.operateFloor("disableNormalOpenFloor", null, ids);
        return this.dealResultData(dataMap);
    }

    public ZKResultMsg getAreasByUser() {
        Map areaMap = this.eleRTMonitorService.getFilterAreaMap(this.request.getSession().getId());
        ZKResultMsg resultMsg = ZKResultMsg.successMsg();
        if (areaMap.size() > 0) {
            JSONObject dataJson = new JSONObject();
            dataJson.put("areaId", areaMap.get("areaIds"));
            dataJson.put("areaName", areaMap.get("areaName"));
            resultMsg.setData((Object)dataJson);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }

    private ZKResultMsg dealResultData(Map<String, String> dataMap) {
        String cmdIdData = dataMap.get("cmdId");
        String msg = "";
        ZKResultMsg resultMsg = new ZKResultMsg();
        if ("true".equals(dataMap.get("notExistDev"))) {
            msg = I18nUtil.i18nCode((String)"common_dev_opFaileAndReason", (Object[])new Object[0]) + I18nUtil.i18nCode((String)"common_dev_notExistDev", (Object[])new Object[0]);
            resultMsg.setMsg(msg);
            return resultMsg;
        }
        if (!"".equals(cmdIdData)) {
            for (String cmdData : cmdIdData.split(",")) {
                String cmdId = cmdData.split("=")[0];
                String floorName = cmdData.split("=")[1];
                Map resultMap = this.eleDeviceService.getCmdResultById(Long.valueOf(cmdId), 20);
                if (Objects.isNull(resultMap)) {
                    msg = msg + floorName + "," + I18nUtil.i18nCode((String)"common_op_failed", (Object[])new Object[0]) + ";";
                    continue;
                }
                Integer ret = Integer.valueOf((String)resultMap.get("result"));
                if (Objects.isNull(ret)) {
                    msg = msg + floorName + "," + I18nUtil.i18nCode((String)"common_op_failed", (Object[])new Object[0]) + ";";
                    continue;
                }
                if (ret >= 0) continue;
                String failedInfo = I18nUtil.i18nCode((String)this.eleBaseDictionaryService.getCommReason(ret.intValue()), (Object[])new Object[0]);
                msg = msg + floorName + "," + I18nUtil.i18nCode((String)"common_dev_opFaileAndReason", (Object[])new Object[0]) + failedInfo + ";";
            }
        }
        if (!"".equals(dataMap.get("offline"))) {
            for (String floorName : dataMap.get("offline").split(",")) {
                msg = msg + floorName + "," + I18nUtil.i18nCode((String)"common_dev_offlinePrompt", (Object[])new Object[0]) + ";";
            }
        }
        if (!"".equals(msg)) {
            resultMsg.setRet("400");
            resultMsg.setMsg(msg);
        }
        resultMsg.setData((Object)"");
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }
}

