/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ele.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.cache.ProgressCache;
import com.zkteco.zkbiosecurity.ele.remote.ElePersonLevelByPersonRemote;
import com.zkteco.zkbiosecurity.ele.service.EleDeviceService;
import com.zkteco.zkbiosecurity.ele.service.EleLevelService;
import com.zkteco.zkbiosecurity.ele.service.ElePersonLevelByPersonService;
import com.zkteco.zkbiosecurity.ele.service.ElePersonService;
import com.zkteco.zkbiosecurity.ele.vo.ElePersonItem;
import com.zkteco.zkbiosecurity.ele.vo.ElePersonLevelByPersonItem;
import com.zkteco.zkbiosecurity.ele.vo.ElePersonLevelItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class ElePersonLevelByPersonController
extends BaseController
implements ElePersonLevelByPersonRemote {
    private Logger logger = LoggerFactory.getLogger(ElePersonLevelByPersonController.class);
    @Autowired
    private ElePersonLevelByPersonService elePersonLevelByPersonService;
    @Autowired
    private EleLevelService eleLevelService;
    @Autowired
    private ProgressCache progressCache;
    @Autowired
    private EleDeviceService eleDeviceService;
    @Autowired
    private ElePersonService elePersonService;

    @RequiresPermissions(value={"ele:personLevelByPerson"})
    public ModelAndView index() {
        return new ModelAndView("ele/personLevelByPerson/elePersonLevelByPerson");
    }

    @RequiresPermissions(value={"ele:personLevelByPerson:refresh"})
    public DxGrid list(ElePersonLevelByPersonItem condition) {
        Pager pager = this.elePersonLevelByPersonService.loadPagerByAuthFilter(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"ele:personLevelByPerson:addLevel"})
    @LogRequest(module="ele_module", object="common_leftMenu_levelSetByPerson", opType="common_level_addPersonLevel", requestParams={"levelNames"}, opContent="common_level_name")
    public ZKResultMsg addLevel(@RequestParam(value="personId") String personId, @RequestParam(value="levelIds") String levelIds) {
        if (StringUtils.isNotBlank((CharSequence)personId)) {
            this.progressCache.beginProcess(I18nUtil.i18nCode((String)"common_progress_searchDev", (Object[])new Object[0]) + "<br/>", I18nUtil.i18nCode((String)"common_op_currProgress", (Object[])new Object[0]), I18nUtil.i18nCode((String)"common_op_totalProgress", (Object[])new Object[0]));
            this.progressCache.beginProcess(I18nUtil.i18nCode((String)"common_progress_searchDevFinish", (Object[])new Object[0]) + "<br/>", I18nUtil.i18nCode((String)"common_op_currProgress", (Object[])new Object[0]), I18nUtil.i18nCode((String)"common_op_totalProgress", (Object[])new Object[0]));
            if (StringUtils.isNotBlank((CharSequence)levelIds)) {
                this.eleLevelService.immeUpdatePersonLevel(personId, levelIds);
            }
            this.progressCache.finishProcess(I18nUtil.i18nCode((String)"common_progress_finish", (Object[])new Object[0]), I18nUtil.i18nCode((String)"common_op_currProgress", (Object[])new Object[0]), I18nUtil.i18nCode((String)"common_op_totalProgress", (Object[])new Object[0]));
        }
        return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.successMsg());
    }

    @RequiresPermissions(value={"ele:personLevelByPerson:delLevel"})
    @LogRequest(module="ele_module", object="common_leftMenu_levelSetByPerson", opType="common_level_delPersonLevel", requestParams={"personPin", "levelNames"}, opContent="common_level_name")
    public ZKResultMsg delLevel(String personId, String levelIds) {
        ZKResultMsg resultMsg = new ZKResultMsg();
        if (StringUtils.isNotBlank((CharSequence)personId) && StringUtils.isNotBlank((CharSequence)levelIds)) {
            ArrayList<String> levelIdList = new ArrayList<String>(Arrays.asList(levelIds.split(",")));
            this.eleLevelService.immeDelPersonLevel(levelIdList, personId);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }

    @RequiresPermissions(value={"ele:personLevelByPerson:refresh"})
    public DxGrid getPersonLevel(ElePersonLevelItem condition) {
        Pager pager = this.eleLevelService.loadPersonLevelPagerByAuthFilter(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"ele:personLevelByPerson:setEleParams"})
    public ModelAndView setEleParam(String ids) {
        ElePersonItem tempElePerson = null;
        String[] personIds = ids.split(",");
        this.request.setAttribute("ids", (Object)ids);
        List tempList = null;
        if (personIds != null && personIds.length == 1) {
            tempElePerson = this.elePersonService.getItemByPersonId(personIds[0]);
            this.request.setAttribute("tempElePerson", (Object)tempElePerson);
            if (tempElePerson != null) {
                tempList = this.eleLevelService.getLevelByPersonId(tempElePerson.getId());
                this.request.setAttribute("tempList", (Object)tempList);
            } else {
                this.logger.error("per_person ele_person data not sync");
            }
        }
        this.request.setAttribute("editPage", (Object)"true");
        return new ModelAndView("ele/personLevelByPerson/setElePersonParam");
    }
}

