/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ele.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.ProcessBean;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.cache.ProgressCache;
import com.zkteco.zkbiosecurity.ele.remote.ElePersonLevelByLevelRemote;
import com.zkteco.zkbiosecurity.ele.service.EleLevelService;
import com.zkteco.zkbiosecurity.ele.service.ElePersonLevelByLevelService;
import com.zkteco.zkbiosecurity.ele.service.ElePersonService;
import com.zkteco.zkbiosecurity.ele.vo.ElePersonLevelByLevelItem;
import com.zkteco.zkbiosecurity.ele.vo.ElePersonListItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class ElePersonLevelByLevelController
extends BaseController
implements ElePersonLevelByLevelRemote {
    private Logger logger = LoggerFactory.getLogger(ElePersonLevelByLevelController.class);
    @Autowired
    private ElePersonLevelByLevelService elePersonLevelByLevelService;
    @Autowired
    private ElePersonService elePersonService;
    @Autowired
    private ProgressCache progressCache;
    @Autowired
    private EleLevelService eleLevelService;

    @RequiresPermissions(value={"ele:personLevelByLevel"})
    public ModelAndView index() {
        return new ModelAndView("ele/personLevelByLevel/elePersonLevelByLevel");
    }

    @RequiresPermissions(value={"ele:personLevelByLevel:refresh"})
    public DxGrid list(ElePersonLevelByLevelItem condition) {
        Pager pager = this.elePersonLevelByLevelService.loadPagerByAuthFilter(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"ele:personLevelByLevel:addPerson"})
    @LogRequest(module="ele_module", object="common_leftMenu_levelSetByLevel", opType="pers_common_addPerson", requestParams={"levelName", "personPins"}, opContent="pers_person_pin")
    public ZKResultMsg addPerson(String levelId, String personIds, String deptIds) {
        String clientId = this.request.getParameter("clientId");
        this.progressCache.beginProcess(I18nUtil.i18nCode((String)"common_op_startProcessing", (Object[])new Object[0]) + "<br/>");
        if (StringUtils.isNotBlank((CharSequence)deptIds)) {
            personIds = this.elePersonService.getPersonIdsByDeptIds(deptIds);
        }
        if (StringUtils.isNotBlank((CharSequence)personIds) && StringUtils.isNotBlank((CharSequence)levelId)) {
            try {
                List personArrayIds = this.elePersonService.splitPersonIds(personIds, 200);
                int[] currentCount = new int[]{0};
                int[] totalCount = new int[]{personArrayIds.size()};
                personArrayIds.parallelStream().forEach(personArrayId -> {
                    this.eleLevelService.addPersonLevel(levelId, personArrayId);
                    currentCount[0] = currentCount[0] + 1;
                    this.progressCache.setProcess(new ProcessBean(0, (int)((double)currentCount[0] * 100.0 / (double)totalCount[0])), clientId);
                });
            }
            catch (Exception e) {
                this.logger.error("addPerson with level error", (Throwable)e);
            }
        }
        this.progressCache.finishProcess(I18nUtil.i18nCode((String)"common_progress_finish", (Object[])new Object[0]) + "<br/>");
        return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.successMsg());
    }

    @RequiresPermissions(value={"ele:personLevelByLevel:delPerson"})
    @LogRequest(module="ele_module", object="common_leftMenu_levelSetByLevel", opType="pers_common_delPerson", requestParams={"levelName", "personPins"}, opContent="pers_person_pin")
    public ZKResultMsg delPerson(String levelId, String personIds) {
        ZKResultMsg zkResultMsg = this.elePersonLevelByLevelService.delPerson(levelId, personIds);
        return I18nUtil.i18nMsg((ZKResultMsg)zkResultMsg);
    }

    public ZKResultMsg convertEleLevelPersonCount(String value) {
        return this.elePersonLevelByLevelService.getPersonCount(this.request.getSession().getId(), value);
    }

    @RequiresPermissions(value={"ele:personLevelByLevel:refresh"})
    public DxGrid getLevelPerson(ElePersonListItem codition) {
        Pager pager = this.elePersonService.getPersonItemList(this.request.getSession().getId(), codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }
}

