/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ele.controller;

import com.alibaba.fastjson.JSON;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.ele.remote.ElePersonRemote;
import com.zkteco.zkbiosecurity.ele.service.EleDirectSelectionService;
import com.zkteco.zkbiosecurity.ele.service.EleLevelService;
import com.zkteco.zkbiosecurity.ele.service.ElePersonService;
import com.zkteco.zkbiosecurity.ele.service.EleServiceConfigService;
import com.zkteco.zkbiosecurity.ele.vo.EleGlobalLinkagePersonItem;
import com.zkteco.zkbiosecurity.ele.vo.EleGlobalLinkageSelectPersonItem;
import com.zkteco.zkbiosecurity.ele.vo.EleLevelSelectPersonItem;
import com.zkteco.zkbiosecurity.ele.vo.ElePersonItem;
import com.zkteco.zkbiosecurity.ele.vo.EleSelectPersonItem;
import com.zkteco.zkbiosecurity.ele.vo.EleSelectPersonRadioItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class ElePersonController
extends BaseController
implements ElePersonRemote {
    @Autowired
    private ElePersonService elePersonService;
    @Autowired
    private EleLevelService eleLevelService;
    @Autowired
    private EleDirectSelectionService eleDirectSelectionService;
    @Autowired
    private EleServiceConfigService eleServiceConfigService;

    @RequiresPermissions(value={"ele:person"})
    public ModelAndView index() {
        return new ModelAndView("ele/person/elePerson");
    }

    @RequiresPermissions(value={"pers:person:eleEdit"})
    public ModelAndView edit(String personId) {
        if (StringUtils.isNotBlank((CharSequence)personId)) {
            ElePersonItem item = this.elePersonService.getItemByPersonId(personId);
            List directSelectionItems = this.eleDirectSelectionService.getItemsByPersonId(personId);
            if (Objects.nonNull(item) && directSelectionItems.size() > 0) {
                item.setIsSetDirectSelection(Boolean.valueOf(true));
            }
            this.request.setAttribute("item", (Object)item);
            this.request.setAttribute("directSelectionList", (Object)JSON.toJSONString((Object)directSelectionItems));
            this.request.setAttribute("tempList", (Object)this.eleLevelService.getLevelByPersonId(personId));
        }
        this.request.setAttribute("isSupportDCS", (Object)this.eleServiceConfigService.isExistEleDCS());
        return new ModelAndView("ele/person/editElePerson");
    }

    public ZKResultMsg save(ElePersonItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.elePersonService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"ele:person:refresh"})
    public DxGrid list(ElePersonItem condition) {
        Pager pager = this.elePersonService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"ele:person:del"})
    public ZKResultMsg del(String ids) {
        this.elePersonService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public DxGrid getLevelSelectPerson(EleLevelSelectPersonItem condition) {
        Pager pager = this.elePersonService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public DxGrid getGlobalLinkagePerson(EleGlobalLinkagePersonItem condition) {
        Pager pager = this.elePersonService.getGlobalLinkagePerson(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public DxGrid getGlobalLinkageSelectPerson(EleGlobalLinkageSelectPersonItem condition) {
        Pager pager = this.elePersonService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public ZKResultMsg getPersonCountByDept(String deptIds) {
        long personCount = this.elePersonService.getPersonCountByDept(deptIds);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg((Object)personCount));
    }

    public DxGrid selectPersonlist(EleSelectPersonItem codition) {
        Pager pager = new Pager();
        if (codition.getType().equals("noSelected")) {
            pager = this.elePersonService.getNoExistPerson(this.request.getSession().getId(), codition, this.getPageNo(), this.getPageSize());
        } else if (codition.getType().equals("selected")) {
            pager.setData(new ArrayList());
        }
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    public ModelAndView filterPersonByVaildCard(String cardNo) {
        Map filterPersonMap = this.elePersonService.filterPersonByVaildCard(cardNo);
        if ("true".equals(filterPersonMap.get("cardNoExist"))) {
            this.request.setAttribute("personPin", filterPersonMap.get("personPin"));
            return new ModelAndView("ele/rtMonitor/opEleSetCardNoToPerson");
        }
        this.request.setAttribute("cardNo", (Object)cardNo);
        return new ModelAndView("ele/rtMonitor/opEleSelectNoCardPersonContent");
    }

    public DxGrid getNoCardPerson(EleSelectPersonRadioItem eleSelectPersonRadioItem) {
        Pager pager = new Pager();
        if (eleSelectPersonRadioItem.getType().equals("noSelected")) {
            pager = this.elePersonService.getNoCardPerson(this.request.getSession().getId(), eleSelectPersonRadioItem, this.getPageNo(), this.getPageSize());
        } else if (eleSelectPersonRadioItem.getType().equals("selected")) {
            pager.setData(new ArrayList());
        }
        return GridUtil.convert((Pager)pager, eleSelectPersonRadioItem.getClass());
    }

    public ZKResultMsg saveParamSet(ElePersonItem item, String ids) {
        ZKResultMsg res = new ZKResultMsg();
        if (StringUtils.isNotBlank((CharSequence)ids)) {
            for (String id : ids.split(",")) {
                item.setPersonId(id);
                item.setDisabled(Boolean.valueOf(item.getDisabled() == null ? false : item.getDisabled()));
                this.elePersonService.saveParamSet(item);
            }
        }
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    public ZKResultMsg setPersonCard(String personId, String cardNo) {
        this.elePersonService.setCardNoToPerson(personId, cardNo);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }
}

