/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ele.controller;

import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.utils.WebContextUtil;
import com.zkteco.zkbiosecurity.ele.remote.EleParamsRemote;
import com.zkteco.zkbiosecurity.ele.service.EleParamsService;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class EleParamsController
extends BaseController
implements EleParamsRemote {
    @Autowired
    private EleParamsService eleParamsService;

    @RequiresPermissions(value={"ele:param:refresh"})
    public ModelAndView index() {
        Map eleParams = this.eleParamsService.getEleParams();
        this.request.setAttribute("eleParams", (Object)eleParams);
        return new ModelAndView("ele/params/eleParams");
    }

    @RequiresPermissions(value={"ele:param:edit"})
    public ZKResultMsg save(@RequestParam Map<String, String> params) {
        ZKResultMsg res = new ZKResultMsg();
        String downNewLogHours = this.request.getParameter("down_event_hours");
        params.put("ele.downNewlog", downNewLogHours);
        StringBuffer StrBuf = new StringBuffer("0 0 ").append(downNewLogHours).append(" * * ?");
        params.put("ele.downNewLogExpression", StrBuf.toString());
        String ip = this.getOpIp();
        this.eleParamsService.saveParams(this.request.getSession().getId(), ip, params);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    private String getOpIp() {
        String ip = "";
        if (WebContextUtil.getCurrentRequest() != null) {
            HttpServletRequest httpServletRequest = WebContextUtil.getCurrentRequest();
            ip = httpServletRequest.getHeader("X-Forwarded-For");
            if (StringUtils.isBlank((CharSequence)ip)) {
                ip = httpServletRequest.getRemoteAddr();
            }
            if ("0:0:0:0:0:0:0:1".equals(ip)) {
                ip = "127.0.0.1";
            }
        }
        return ip;
    }

    public ZKResultMsg enableOfflineFunCheck() {
        ZKResultMsg ret = this.eleParamsService.enableOfflineFunCheck();
        return I18nUtil.i18nMsg((ZKResultMsg)ret);
    }
}

