/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ele.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.ele.remote.EleOperationLogRemote;
import com.zkteco.zkbiosecurity.ele.service.EleOperationLogService;
import com.zkteco.zkbiosecurity.ele.vo.EleOperationLogItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class EleOperationLogController
extends BaseController
implements EleOperationLogRemote {
    @Autowired
    private EleOperationLogService eleOperationLogService;

    @RequiresPermissions(value={"ele:operationLog"})
    public ModelAndView index() {
        return new ModelAndView("ele/operationLog/eleOperationLog");
    }

    @RequiresPermissions(value={"ele:operationLog:refresh"})
    public DxGrid list(EleOperationLogItem condition) {
        Pager pager = this.eleOperationLogService.loadPagerByAuthFilter(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, EleOperationLogItem.class);
    }

    @RequiresPermissions(value={"ele:operationLog:clearData"})
    @LogRequest(module="ele_module", object="ele_leftMenu_operationLog", opType="common_op_clearData", opContent="common_op_clearData")
    public ZKResultMsg clearData() {
        this.eleOperationLogService.deleteAllData();
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }
}

