/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ele.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.ele.remote.EleInternalReaderRemote;
import com.zkteco.zkbiosecurity.ele.service.EleInternalReaderService;
import com.zkteco.zkbiosecurity.ele.service.EleReaderMaskService;
import com.zkteco.zkbiosecurity.ele.vo.EleInternalReaderItem;
import com.zkteco.zkbiosecurity.ele.vo.EleReaderMaskItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class EleInternalReaderController
extends BaseController
implements EleInternalReaderRemote {
    @Autowired
    private EleInternalReaderService eleInternalReaderService;
    @Autowired
    private EleReaderMaskService eleReaderMaskService;

    @RequiresPermissions(value={"ele:internalReader"})
    public ModelAndView index() {
        return new ModelAndView("ele/internalReader/eleInternalReader");
    }

    @RequiresPermissions(value={"ele:internalReader:add", "ele:internalReader:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.eleInternalReaderService.getItemById(id));
        }
        return new ModelAndView("ele/internalReader/editEleInternalReader");
    }

    @RequiresPermissions(value={"ele:internalReader:add", "ele:internalReader:edit"})
    @LogRequest(module="ele_module", object="ele_leftMenu_internalReader", opType="common_op_edit", requestParams={"name"}, opContent="ele_reader_name")
    public ZKResultMsg save(EleInternalReaderItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.eleInternalReaderService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"ele:internalReader:refresh"})
    public DxGrid list(EleInternalReaderItem condition) {
        Pager pager = this.eleInternalReaderService.loadPagerByAuthFilter(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, EleInternalReaderItem.class);
    }

    @RequiresPermissions(value={"ele:internalReader:del"})
    @LogRequest(module="ele_module", object="ele_leftMenu_internalReader", opType="common_op_del", requestParams={"name"}, opContent="ele_reader_name")
    public ZKResultMsg delete(String ids) {
        this.eleInternalReaderService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public boolean isExistReaderName(String name) {
        return this.eleInternalReaderService.isExistReaderName(name);
    }

    public ModelAndView editInternalReaderSpecificMask(String id) {
        EleReaderMaskItem condition = new EleReaderMaskItem();
        condition.setReaderId(id);
        condition.setReaderType("INTERNAL");
        List specificMaskItems = this.eleReaderMaskService.getByCondition(condition);
        Map<String, List<EleReaderMaskItem>> specificMaskMap = specificMaskItems.stream().collect(Collectors.groupingBy(EleReaderMaskItem::getStatus));
        for (String status : specificMaskMap.keySet()) {
            List<EleReaderMaskItem> specificMaskItemList = specificMaskMap.get(status);
            specificMaskItemList.sort(Comparator.comparingInt(o -> Integer.parseInt(o.getFloorNo().toString())));
            if ("1".equals(status)) {
                this.request.setAttribute("onlineMask", specificMaskItemList);
                continue;
            }
            this.request.setAttribute("offlineMask", specificMaskItemList);
        }
        String serviceConfigId = ((EleReaderMaskItem)specificMaskItems.get(0)).getServiceConfigId();
        this.request.setAttribute("serviceConfigId", (Object)serviceConfigId);
        this.request.setAttribute("readerId", (Object)id);
        this.request.setAttribute("readerType", (Object)"INTERNAL");
        this.request.setAttribute("specificMask", (Object)true);
        return new ModelAndView("ele/serviceConfig/editEleReaderMask");
    }

    public ZKResultMsg clearSpecificMask(String id) {
        return this.eleReaderMaskService.clearSpecificMask(id, "INTERNAL");
    }
}

