/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ele.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.ele.remote.EleIntegrationDeviceRemote;
import com.zkteco.zkbiosecurity.ele.service.EleIntegrationDeviceService;
import com.zkteco.zkbiosecurity.ele.vo.EleIntegrationDeviceItem;
import com.zkteco.zkbiosecurity.ele.vo.EleSelectDeviceItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class EleIntegrationDeviceController
extends ExportController
implements EleIntegrationDeviceRemote {
    @Autowired
    private EleIntegrationDeviceService eleIntegrationDeviceService;

    @RequiresPermissions(value={"ele:integrationDevice"})
    public ModelAndView index() {
        return new ModelAndView("ele/integrationDevice/eleIntegrationDevice");
    }

    @RequiresPermissions(value={"ele:integrationDevice:add"})
    public ModelAndView edit(String id) {
        return new ModelAndView("ele/integrationDevice/eleSelectDeviceContent");
    }

    @RequiresPermissions(value={"ele:integrationDevice:add"})
    @LogRequest(module="ele_module", object="ele_leftMenu_integrationDevice", opType="common_op_edit", requestParams={"name"}, opContent="common_dev_name")
    public ZKResultMsg save(EleIntegrationDeviceItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.eleIntegrationDeviceService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"ele:integrationDevice:refresh"})
    public DxGrid list(EleIntegrationDeviceItem condition) {
        Pager pager = this.eleIntegrationDeviceService.loadPagerByAuthFilter(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, EleIntegrationDeviceItem.class);
    }

    @RequiresPermissions(value={"ele:integrationDevice:del"})
    @LogRequest(module="ele_module", object="ele_leftMenu_integrationDevice", opType="common_op_del", requestParams={"alias"}, opContent="common_dev_name")
    public ZKResultMsg delete(String ids) {
        this.eleIntegrationDeviceService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public DxGrid selectDeviceList(EleSelectDeviceItem condition) {
        Pager pager = this.eleIntegrationDeviceService.getSelectDeviceList(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"ele:integrationDevice:add"})
    @LogRequest(module="ele_module", object="ele_leftMenu_integrationDevice", opType="common_op_add")
    public ZKResultMsg addIntegrationDevice(List<EleIntegrationDeviceItem> integrationDeviceItemList) {
        this.eleIntegrationDeviceService.addIntegrationDevice(integrationDeviceItemList);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }
}

