/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ele.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.ele.constants.EleConstants;
import com.zkteco.zkbiosecurity.ele.remote.EleGlobalLinkageRemote;
import com.zkteco.zkbiosecurity.ele.service.EleGlobalLinkageService;
import com.zkteco.zkbiosecurity.ele.service.ElePersonService;
import com.zkteco.zkbiosecurity.ele.service.EleTimeSegService;
import com.zkteco.zkbiosecurity.ele.vo.EleGlobalLinkageItem;
import com.zkteco.zkbiosecurity.ele.vo.EleGlobalLinkageSelectContactItem;
import com.zkteco.zkbiosecurity.ele.vo.EleTimeSegItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class EleGlobalLinkageController
extends BaseController
implements EleGlobalLinkageRemote {
    @Autowired
    private EleGlobalLinkageService eleGlobalLinkageService;
    @Autowired
    private EleTimeSegService timeSegService;
    @Autowired
    private ElePersonService elePersonService;

    @RequiresPermissions(value={"ele:globalLinkage"})
    public ModelAndView index() {
        return new ModelAndView("ele/globalLinkage/eleGlobalLinkage");
    }

    @RequiresPermissions(value={"ele:globalLinkage:add", "ele:globalLinkage:edit"})
    public ModelAndView edit(String id) {
        boolean showLine = this.eleGlobalLinkageService.checkShowLine();
        if (StringUtils.isNotBlank((CharSequence)id)) {
            EleGlobalLinkageItem eleGlobalLinkageItem = this.eleGlobalLinkageService.getItemById(id);
            if (showLine) {
                List eleGlobalLinkage4LineContactItems = this.eleGlobalLinkageService.getLineContactsByContactIds(eleGlobalLinkageItem.getLineContactId());
                this.request.setAttribute("contactList", (Object)eleGlobalLinkage4LineContactItems);
            }
            this.request.setAttribute("item", (Object)eleGlobalLinkageItem);
        } else {
            EleTimeSegItem initTimeSeg = this.timeSegService.getInitItem();
            this.request.setAttribute("initTimeSeg", (Object)initTimeSeg);
        }
        this.request.setAttribute("showLine", (Object)showLine);
        this.request.setAttribute("showSMS", (Object)this.eleGlobalLinkageService.checkShowSMS());
        this.request.setAttribute("showWhatsapp", (Object)this.eleGlobalLinkageService.checkShowWhatsapp());
        return new ModelAndView("ele/globalLinkage/editEleGlobalLinkage");
    }

    @RequiresPermissions(value={"ele:globalLinkage:add", "ele:globalLinkage:edit"})
    @LogRequest(module="ele_module", object="ele_leftMenu_globalLinkage", opType="common_op_edit", requestParams={"name"}, opContent="common_linkIO_linkageName")
    public ZKResultMsg save(EleGlobalLinkageItem item) {
        ZKResultMsg res = new ZKResultMsg();
        String isApplyToAll = this.request.getParameter("applyToAll");
        String isOnlyAuxInEvent = this.request.getParameter("isOnlyAuxInEvent");
        if (isApplyToAll != null) {
            item.setIsApplyToAll(Short.valueOf((short)0));
        } else if (isOnlyAuxInEvent.equals("2")) {
            item.setIsApplyToAll(Short.valueOf((short)2));
        } else {
            item.setIsApplyToAll(Short.valueOf((short)1));
        }
        if (StringUtils.isNotBlank((CharSequence)item.getPopUpVideo()) && (EleConstants.POP_UP_VIDEO + "").equals(item.getPopUpVideo())) {
            String popUpTime = this.request.getParameter("popUpTime");
            item.setPopUpTimes(Integer.parseInt(popUpTime));
        }
        if (StringUtils.isNotBlank((CharSequence)item.getRecord()) && (EleConstants.RECORD + "").equals(item.getRecord())) {
            String recordTime = this.request.getParameter("recordTime");
            item.setRecordTimes(Integer.parseInt(recordTime));
        }
        if (StringUtils.isNotBlank((CharSequence)item.getCapture()) && (EleConstants.CAPTURE + "").equals(item.getCapture())) {
            String captureTime = this.request.getParameter("captureTime");
            if (StringUtils.isNotBlank((CharSequence)captureTime)) {
                item.setCaptureTimes(Integer.parseInt(captureTime));
            } else {
                item.setCaptureTimes(-1);
            }
        }
        this.eleGlobalLinkageService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"ele:globalLinkage:refresh"})
    public DxGrid list(EleGlobalLinkageItem condition) {
        Pager pager = this.eleGlobalLinkageService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"ele:globalLinkage:del"})
    @LogRequest(module="ele_module", object="ele_leftMenu_globalLinkage", opType="common_op_del", requestParams={"name"}, opContent="common_linkIO_linkageName")
    public ZKResultMsg del(String ids) {
        this.eleGlobalLinkageService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public ZKResultMsg checkMailParam() {
        boolean isCompleteMailInfo = this.eleGlobalLinkageService.checkMailParam();
        if (isCompleteMailInfo) {
            return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg((Object)"ok"));
        }
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg((Object)"error"));
    }

    public ZKResultMsg getLinkTriggerOpt(String globalLinkageId) {
        JSONObject devsJson = new JSONObject();
        try {
            devsJson.put("id", (Object)"globalTrigger");
            JSONArray devJsonArray = new JSONArray();
            String data = this.eleGlobalLinkageService.getLinkTriggerOpt(globalLinkageId);
            JSONObject dataJson = JSONObject.parseObject((String)data);
            JSONArray eleEvent = dataJson.getJSONArray("eleEvent");
            boolean cheeckAll = dataJson.getBoolean("checkAll");
            boolean isCheckParentElement = dataJson.getBoolean("isCheckParentElement");
            JSONObject eventJson = null;
            if (eleEvent.size() > 0) {
                String[] parentElement = new String[]{I18nUtil.i18nCode((String)"ele_globalLinkage_eleEvent", (Object[])new Object[0])};
                for (int i = 0; i < parentElement.length; ++i) {
                    eventJson = new JSONObject();
                    eventJson.put("id", (Object)(i + "_parent"));
                    eventJson.put("text", (Object)parentElement[i]);
                    eventJson.put("open", (Object)"1");
                    if (cheeckAll) {
                        eventJson.put("checked", (Object)"1");
                    } else if (isCheckParentElement) {
                        eventJson.put("checked", (Object)"-1");
                    }
                    eventJson.put("item", (Object)eleEvent);
                    devJsonArray.add((Object)eventJson);
                }
                devsJson.put("item", (Object)devJsonArray);
            }
        }
        catch (Exception e) {
            throw new ZKBusinessException("getLinkTriggerOpt error", (Throwable)e);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg((Object)devsJson.toString()));
    }

    @LogRequest(module="ele_module", object="ele_leftMenu_globalLinkage", opType="pers_common_addPerson", requestParams={"globalLinkageName", "personPins"}, opContent="pers_person_pin")
    public ZKResultMsg addPerson(String globalLinkageId, String personIds, String deptIds) {
        if (StringUtils.isNotBlank((CharSequence)deptIds)) {
            personIds = this.elePersonService.getPersonIdsByDeptIds(deptIds);
        }
        if (StringUtils.isNotBlank((CharSequence)globalLinkageId) && StringUtils.isNotBlank((CharSequence)personIds)) {
            this.eleGlobalLinkageService.addPerson(globalLinkageId, personIds);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @LogRequest(module="ele_module", object="ele_leftMenu_globalLinkage", opType="pers_common_delPerson", requestParams={"globalLinkageName", "personPins"}, opContent="pers_person_pin")
    public ZKResultMsg delPerson(String globalLinkageId, String personIds) {
        if (StringUtils.isNotBlank((CharSequence)globalLinkageId) && StringUtils.isNotBlank((CharSequence)personIds)) {
            this.eleGlobalLinkageService.delPerson(personIds, globalLinkageId);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public boolean isExistLinkageName(String name) {
        return this.eleGlobalLinkageService.isExistLinkageName(name);
    }

    public ZKResultMsg getInputInfo(String triggerNos, String triggerNames) {
        ZKResultMsg resultMsg = new ZKResultMsg();
        try {
            String[] triggerNoStr;
            ArrayList<Integer> triggerNoList = new ArrayList<Integer>();
            for (String triggerNo : triggerNoStr = triggerNos.split(",")) {
                triggerNoList.add(Integer.parseInt(triggerNo.indexOf("_") >= 0 ? triggerNo.trim().split("_")[1] : triggerNo));
            }
            List<String> triggerNameList = Arrays.asList(triggerNames.split(","));
            String filterInputIds = this.eleGlobalLinkageService.getInputFilterIds(triggerNoList, triggerNameList);
            JSONObject retIds = new JSONObject();
            retIds.put("inputFilterIds", (Object)filterInputIds);
            resultMsg.setData((Object)retIds);
        }
        catch (Exception e) {
            throw new ZKBusinessException((Throwable)e);
        }
        return resultMsg;
    }

    @RequiresPermissions(value={"ele:globalLinkage:enable"})
    @LogRequest(module="ele_module", object="ele_leftMenu_globalLinkage", opType="common_enable", requestParams={"name"}, opContent="common_linkIO_linkageName")
    public ZKResultMsg setEnable(String ids) {
        if (StringUtils.isNotBlank((CharSequence)ids)) {
            this.eleGlobalLinkageService.setGlobalLinkageStatus(ids, true);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"ele:globalLinkage:disable"})
    @LogRequest(module="ele_module", object="ele_leftMenu_globalLinkage", opType="common_disable", requestParams={"name"}, opContent="common_linkIO_linkageName")
    public ZKResultMsg setDisable(String ids) {
        if (StringUtils.isNotBlank((CharSequence)ids)) {
            this.eleGlobalLinkageService.setGlobalLinkageStatus(ids, false);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public ZKResultMsg checkSMSModemParam() {
        ZKResultMsg zkResultMsg = new ZKResultMsg();
        zkResultMsg.setData((Object)this.eleGlobalLinkageService.checkSMSModemParam());
        return I18nUtil.i18nMsg((ZKResultMsg)zkResultMsg);
    }

    public DxGrid selectLineContactList(EleGlobalLinkageSelectContactItem condition) {
        Pager pager = new Pager();
        String selectIds = this.request.getParameter("selectValue");
        if (StringUtils.isBlank((CharSequence)selectIds)) {
            selectIds = "";
        }
        if (StringUtils.isNotBlank((CharSequence)condition.getSelectId())) {
            selectIds = selectIds + "," + condition.getSelectId();
        }
        condition.setSelectId(selectIds);
        if (condition.getType().equals("noSelected")) {
            pager = this.eleGlobalLinkageService.getNoExistLineContacts(condition, this.getPageNo(), this.getPageSize());
        } else if (condition.getType().equals("selected")) {
            pager.setData(new ArrayList());
        }
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public ZKResultMsg checkGlobalTriggerOpt() {
        String triggerOpt = this.request.getParameter("triggerOpt");
        String inputAddr = this.request.getParameter("inputAddr");
        String globalLinkageId = this.request.getParameter("globalLinkageId");
        ZKResultMsg resultMsg = this.eleGlobalLinkageService.checkGlobalTriggerOpt(triggerOpt, inputAddr, globalLinkageId);
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }
}

