/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ele.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.ele.remote.EleFirstInLastOutRemote;
import com.zkteco.zkbiosecurity.ele.service.EleDeviceService;
import com.zkteco.zkbiosecurity.ele.service.EleFirstInLastOutService;
import com.zkteco.zkbiosecurity.ele.vo.EleFirstInLastOutItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class EleFirstInLastOutController
extends ExportController
implements EleFirstInLastOutRemote {
    @Autowired
    private EleFirstInLastOutService eleFirstInLastOutService;
    @Autowired
    private EleDeviceService eleDeviceService;

    @RequiresPermissions(value={"ele:firstInLastOut"})
    public ModelAndView index() {
        return new ModelAndView("ele/firstInLastOut/eleFirstInLastOut");
    }

    @RequiresPermissions(value={"ele:firstInLastOut:refresh"})
    public DxGrid list(EleFirstInLastOutItem condition) {
        Pager pager = this.eleFirstInLastOutService.loadFirstInLastOutByAuthUserFilter(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize(), this.getLimitCount());
        return GridUtil.convert((Pager)pager, condition.getClass(), (boolean)this.getPageList());
    }

    @RequiresPermissions(value={"ele:firstInLastOut:clearData"})
    @LogRequest(module="ele_module", object="ele_leftMenu_firstInLastOut", opType="common_op_clearData", opContent="common_op_clearData")
    public ZKResultMsg clearData() {
        this.eleFirstInLastOutService.deleteAllData();
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"ele:firstInLastOut:export"})
    @LogRequest(module="ele_module", object="ele_leftMenu_firstInLastOut", opType="common_op_export", opContent="common_op_export")
    public void export(HttpServletRequest request, HttpServletResponse response) {
        EleFirstInLastOutItem eleFirstInLastOutItem = new EleFirstInLastOutItem();
        this.setConditionValue((BaseItem)eleFirstInLastOutItem);
        String userId = this.eleDeviceService.getUserIdBySessionId(request.getSession().getId());
        if (StringUtils.isNotBlank((CharSequence)userId)) {
            eleFirstInLastOutItem.setUserId(userId);
        }
        List itemList = this.eleFirstInLastOutService.getItemData(EleFirstInLastOutItem.class, (BaseItem)eleFirstInLastOutItem, this.getBeginIndex(), this.getEndIndex());
        this.excelExport(itemList, EleFirstInLastOutItem.class);
    }
}

