/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ele.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.TreeItem;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.ele.remote.EleExternalReaderRemote;
import com.zkteco.zkbiosecurity.ele.service.EleExternalReaderService;
import com.zkteco.zkbiosecurity.ele.service.EleReaderMaskService;
import com.zkteco.zkbiosecurity.ele.vo.EleExternalReaderItem;
import com.zkteco.zkbiosecurity.ele.vo.EleReaderMaskItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class EleExternalReaderController
extends BaseController
implements EleExternalReaderRemote {
    @Autowired
    private EleExternalReaderService eleExternalReaderService;
    @Autowired
    private EleReaderMaskService eleReaderMaskService;

    @RequiresPermissions(value={"ele:externalReader"})
    public ModelAndView index() {
        return new ModelAndView("ele/externalReader/eleExternalReader");
    }

    @RequiresPermissions(value={"ele:externalReader:add", "ele:externalReader:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.eleExternalReaderService.getItemById(id));
        }
        return new ModelAndView("ele/externalReader/editEleExternalReader");
    }

    @RequiresPermissions(value={"ele:externalReader:add", "ele:externalReader:edit"})
    @LogRequest(module="ele_module", object="ele_leftMenu_externalReader", opType="common_op_edit", requestParams={"name"}, opContent="ele_reader_name")
    public ZKResultMsg save(EleExternalReaderItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.eleExternalReaderService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"ele:externalReader:refresh"})
    public DxGrid list(EleExternalReaderItem condition) {
        Pager pager = this.eleExternalReaderService.loadPagerByAuthFilter(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, EleExternalReaderItem.class);
    }

    @RequiresPermissions(value={"ele:externalReader:del"})
    @LogRequest(module="ele_module", object="ele_leftMenu_externalReader", opType="common_op_del", requestParams={"name"}, opContent="ele_reader_name")
    public ZKResultMsg delete(String ids) {
        this.eleExternalReaderService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public boolean isExistReaderName(String name) {
        return this.eleExternalReaderService.isExistReaderName(name);
    }

    public ZKResultMsg getCallTypeList(String manufacturer) {
        List selectItemList = this.eleExternalReaderService.getCallTypeList(manufacturer);
        return new ZKResultMsg((Object)selectItemList);
    }

    public ZKResultMsg getIntegrationDeviceList() {
        List selectItemList = this.eleExternalReaderService.getIntegrationDeviceList(this.request.getSession().getId());
        return new ZKResultMsg((Object)selectItemList);
    }

    public ZKResultMsg getDeviceReaderList(EleExternalReaderItem item) {
        List selectItemList = this.eleExternalReaderService.getDeviceReaderList(item);
        return new ZKResultMsg((Object)selectItemList);
    }

    public TreeItem getServiceConfigFloorTree(String serviceConfigId) {
        return this.eleExternalReaderService.getServiceConfigFloorTree(this.request.getSession().getId(), serviceConfigId);
    }

    public ZKResultMsg isExistTerminalId(String terminalId, String floorId) {
        ZKResultMsg resultMsg = this.eleExternalReaderService.isExistTerminalId(terminalId, floorId);
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }

    public ModelAndView editExternalReaderSpecificMask(String id) {
        EleReaderMaskItem condition = new EleReaderMaskItem();
        condition.setReaderId(id);
        condition.setReaderType("EXTERNAL");
        List specificMaskItems = this.eleReaderMaskService.getByCondition(condition);
        Map<String, List<EleReaderMaskItem>> specificMaskMap = specificMaskItems.stream().collect(Collectors.groupingBy(EleReaderMaskItem::getStatus));
        for (String status : specificMaskMap.keySet()) {
            List<EleReaderMaskItem> specificMaskItemList = specificMaskMap.get(status);
            specificMaskItemList.sort(Comparator.comparingInt(o -> Integer.parseInt(o.getFloorNo().toString())));
            if ("1".equals(status)) {
                this.request.setAttribute("onlineMask", specificMaskItemList);
                continue;
            }
            this.request.setAttribute("offlineMask", specificMaskItemList);
        }
        String serviceConfigId = ((EleReaderMaskItem)specificMaskItems.get(0)).getServiceConfigId();
        this.request.setAttribute("serviceConfigId", (Object)serviceConfigId);
        this.request.setAttribute("readerId", (Object)id);
        this.request.setAttribute("readerType", (Object)"EXTERNAL");
        this.request.setAttribute("specificMask", (Object)true);
        return new ModelAndView("ele/serviceConfig/editEleReaderMask");
    }

    public ZKResultMsg clearSpecificMask(String id) {
        return this.eleReaderMaskService.clearSpecificMask(id, "EXTERNAL");
    }
}

