/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ele.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.SelectItem;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.ele.constants.EleConstants;
import com.zkteco.zkbiosecurity.ele.remote.EleExtBoardRemote;
import com.zkteco.zkbiosecurity.ele.service.EleDeviceOptionService;
import com.zkteco.zkbiosecurity.ele.service.EleDeviceService;
import com.zkteco.zkbiosecurity.ele.service.EleExtBoardService;
import com.zkteco.zkbiosecurity.ele.service.EleFloorService;
import com.zkteco.zkbiosecurity.ele.vo.EleDeviceItem;
import com.zkteco.zkbiosecurity.ele.vo.EleExtBoardItem;
import com.zkteco.zkbiosecurity.ele.vo.EleExtBoardSelectDevItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class EleExtBoardController
extends BaseController
implements EleExtBoardRemote {
    @Autowired
    private EleExtBoardService eleExtBoardService;
    @Autowired
    private EleDeviceService eleDeviceService;
    @Autowired
    private EleFloorService eleFloorService;
    @Autowired
    private EleDeviceOptionService eleDeviceOptionService;

    @RequiresPermissions(value={"ele:extBoard"})
    public ModelAndView index() {
        return new ModelAndView("ele/extBoard/eleExtBoard");
    }

    @RequiresPermissions(value={"ele:extBoard:add", "ele:extBoard:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.eleExtBoardService.getItemById(id));
            this.request.setAttribute("editPage", (Object)"true");
        }
        return new ModelAndView("ele/extBoard/editEleExtBoard");
    }

    @RequiresPermissions(value={"ele:extBoard:add", "ele:extBoard:edit"})
    @LogRequest(module="ele_module", object="ele_extBoard", opType="common_op_edit", requestParams={"alias"}, opContent="common_dev_name")
    public ZKResultMsg save(EleExtBoardItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.eleExtBoardService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"ele:extBoard:refresh"})
    public DxGrid list(EleExtBoardItem condition) {
        Pager pager = this.eleExtBoardService.loadPagerByAuthFilter(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"ele:extBoard:del"})
    @LogRequest(module="ele_module", object="ele_extBoard", opType="common_op_del", requestParams={"aliases"}, opContent="common_dev_name")
    public ZKResultMsg del(String ids) {
        this.eleExtBoardService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public DxGrid selectDeviceList(EleExtBoardSelectDevItem condition) {
        Pager pager = new Pager(this.getPageNo(), this.getPageSize());
        pager.setData(new ArrayList());
        if ("noSelected".equals(condition.getType())) {
            StringBuffer filterIds = new StringBuffer();
            filterIds.append(condition.getSelectId());
            if (StringUtils.isBlank((CharSequence)filterIds)) {
                filterIds.append("-1");
            }
            List eleDeviceItems = this.eleDeviceService.getByCondition(new EleDeviceItem());
            for (EleDeviceItem eleDeviceItem : eleDeviceItems) {
                if (eleDeviceItem.getDeviceMode().equals(EleConstants.DEV_MODE_OFFLINE) || this.eleDeviceOptionService.isSupportFunList(eleDeviceItem.getSn(), 52)) continue;
                filterIds.append(",");
                filterIds.append(eleDeviceItem.getId());
            }
            condition.setSelectDeviceIdNotIn(filterIds.toString());
            pager = this.eleDeviceService.getDeviceSelectItem(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        }
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public boolean rs485Valid(String id, String devId, String commAddress) {
        return this.eleExtBoardService.findExtBoardByCommAddress(id, devId, commAddress);
    }

    public boolean isAliasExist(String alias, String id) {
        return this.eleExtBoardService.findExtBoardByAlias(alias, id);
    }

    public ZKResultMsg getExtBoardType(String devId) {
        ArrayList<SelectItem> selectItems = new ArrayList<SelectItem>();
        SelectItem selectItem = null;
        if (StringUtils.isBlank((CharSequence)devId)) {
            return new ZKResultMsg(selectItems);
        }
        EleDeviceItem eleDeviceItem = this.eleDeviceService.getItemById(devId);
        if (this.eleDeviceOptionService.isSupportFunList(eleDeviceItem.getSn(), 52)) {
            selectItem = new SelectItem();
            selectItem.setValue(EleConstants.EXT_BOARD_TYPE_EX308 + "");
            selectItem.setText((Object)"EX-308");
            selectItems.add(selectItem);
            selectItem = new SelectItem();
            selectItem.setValue(EleConstants.EXT_BOARD_TYPE_EX316 + "");
            selectItem.setText((Object)"EX-316");
            selectItems.add(selectItem);
        }
        return new ZKResultMsg(selectItems);
    }
}

