/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ele.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.TreeItem;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.ele.remote.EleElevatorGroupRemote;
import com.zkteco.zkbiosecurity.ele.service.EleElevatorGroupService;
import com.zkteco.zkbiosecurity.ele.vo.EleElevatorGroupItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class EleElevatorGroupController
extends BaseController
implements EleElevatorGroupRemote {
    @Autowired
    private EleElevatorGroupService eleElevatorGroupService;

    @RequiresPermissions(value={"ele:elevatorGroup"})
    public ModelAndView index() {
        return new ModelAndView("ele/elevatorGroup/eleElevatorGroup");
    }

    @RequiresPermissions(value={"ele:elevatorGroup:add", "ele:elevatorGroup:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.eleElevatorGroupService.getItemById(id));
        }
        return new ModelAndView("ele/elevatorGroup/editEleElevatorGroup");
    }

    @RequiresPermissions(value={"ele:elevatorGroup:add", "ele:elevatorGroup:edit"})
    @LogRequest(module="ele_module", object="ele_leftMenu_elevatorGroup", opType="common_op_edit", requestParams={"groupName"}, opContent="ele_elevatorGroup_name")
    public ZKResultMsg save(EleElevatorGroupItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.eleElevatorGroupService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"ele:elevatorGroup:refresh"})
    public DxGrid list(EleElevatorGroupItem condition) {
        Pager pager = this.eleElevatorGroupService.loadPagerByAuthFilter(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, EleElevatorGroupItem.class);
    }

    @RequiresPermissions(value={"ele:elevatorGroup:del"})
    @LogRequest(module="ele_module", object="ele_leftMenu_elevatorGroup", opType="common_op_del", requestParams={"groupName"}, opContent="ele_elevatorGroup_name")
    public ZKResultMsg delete(String ids) {
        this.eleElevatorGroupService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public boolean isExistGroupName(String groupName) {
        return this.eleElevatorGroupService.isExistGroupName(groupName);
    }

    public boolean isExistGroupNo(String groupNo, String serviceConfigId) {
        return this.eleElevatorGroupService.isExistGroupNo(groupNo, serviceConfigId);
    }

    public TreeItem getFilterElevatorTree(String elevatorId) {
        return this.eleElevatorGroupService.getFilterElevatorTree(this.request.getSession().getId(), elevatorId);
    }

    public TreeItem getElevatorTree() {
        return this.eleElevatorGroupService.getElevatorTree(this.request.getSession().getId());
    }

    public ZKResultMsg validBankNumber(String serviceConfigId) {
        return this.eleElevatorGroupService.validBankNumber(serviceConfigId);
    }

    public ZKResultMsg getElevatorGroupListByReaderType(String serviceConfigId, String readerType) {
        return new ZKResultMsg((Object)this.eleElevatorGroupService.getElevatorGroupListByReaderType(serviceConfigId, readerType));
    }
}

