/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ele.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.ele.remote.EleElevatorRemote;
import com.zkteco.zkbiosecurity.ele.service.EleElevatorService;
import com.zkteco.zkbiosecurity.ele.vo.EleElevatorItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class EleElevatorController
extends BaseController
implements EleElevatorRemote {
    @Autowired
    private EleElevatorService eleElevatorService;

    @RequiresPermissions(value={"ele:elevator:edit", "ele:elevatorGroup:addElevator"})
    public ModelAndView edit(String id) {
        String elevatorGroupId = this.request.getParameter("elevatorGroupId");
        EleElevatorItem item = new EleElevatorItem();
        item.setElevatorGroupId(elevatorGroupId);
        if (StringUtils.isNotBlank((CharSequence)id)) {
            item = this.eleElevatorService.getItemById(id);
        }
        this.request.setAttribute("item", (Object)item);
        this.request.setAttribute("manufacturer", (Object)this.request.getParameter("manufacturer"));
        return new ModelAndView("ele/elevator/editElevator");
    }

    @RequiresPermissions(value={"ele:elevator:edit", "ele:elevatorGroup:addElevator"})
    @LogRequest(module="ele_module", object="ele_elevator", opType="common_op_edit", requestParams={"elevatorName"}, opContent="ele_elevator_name")
    public ZKResultMsg save(EleElevatorItem item) {
        ZKResultMsg resultMsg = new ZKResultMsg();
        this.eleElevatorService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }

    @RequiresPermissions(value={"ele:elevatorGroup:refresh"})
    public DxGrid list(EleElevatorItem condition) {
        Pager pager = this.eleElevatorService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, EleElevatorItem.class);
    }

    @RequiresPermissions(value={"ele:elevator:del"})
    @LogRequest(module="ele_module", object="ele_elevator", opType="common_op_del", requestParams={"elevatorName"}, opContent="ele_elevator_name")
    public ZKResultMsg delete(String ids) {
        this.eleElevatorService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public boolean isExistElevatorNo(String elevatorGroupId, String elevatorNo) {
        return this.eleElevatorService.isExistElevatorNo(elevatorGroupId, elevatorNo);
    }

    public boolean isExistElevatorName(String elevatorGroupId, String elevatorName) {
        return this.eleElevatorService.isExistElevatorName(elevatorGroupId, elevatorName);
    }

    public ZKResultMsg validElevatorNumber(String groupId) {
        return this.eleElevatorService.validElevatorNumber(groupId);
    }

    public ZKResultMsg getElevatorItemList(String elevatorGroupId) {
        return new ZKResultMsg((Object)this.eleElevatorService.getElevatorItemList(elevatorGroupId));
    }
}

