/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ele.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.SelectItem;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.ele.remote.EleDirectSelectionRemote;
import com.zkteco.zkbiosecurity.ele.service.EleDirectSelectionService;
import com.zkteco.zkbiosecurity.ele.service.EleFloorService;
import com.zkteco.zkbiosecurity.ele.service.ElePersonService;
import com.zkteco.zkbiosecurity.ele.vo.EleDeviceItem;
import com.zkteco.zkbiosecurity.ele.vo.EleDirectSelectionByPersonItem;
import com.zkteco.zkbiosecurity.ele.vo.EleDirectSelectionItem;
import com.zkteco.zkbiosecurity.ele.vo.EleDirectSelectionSelectFloorItem;
import com.zkteco.zkbiosecurity.ele.vo.EleFloorItem;
import com.zkteco.zkbiosecurity.ele.vo.ElePersonItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class EleDirectSelectionController
extends BaseController
implements EleDirectSelectionRemote {
    @Autowired
    private EleDirectSelectionService eleDirectSelectionService;
    @Autowired
    private ElePersonService elePersonService;
    @Autowired
    private EleFloorService eleFloorService;

    public ModelAndView index() {
        return new ModelAndView("ele/directSelection/eleDirectSelection");
    }

    @RequiresPermissions(value={"ele:directSelection:addDirectSelection", "ele:directSelection:edit"})
    public ModelAndView edit(String id) {
        EleDirectSelectionItem item;
        if (StringUtils.isNotBlank((CharSequence)id) && Objects.nonNull(item = this.eleDirectSelectionService.getItemById(id))) {
            this.request.setAttribute("item", (Object)item);
            this.request.setAttribute("personId", (Object)item.getPersonId());
            this.request.setAttribute("personPin", (Object)item.getPersonPin());
        }
        return new ModelAndView("ele/directSelection/opEleAddDirectSelection");
    }

    public DxGrid list(EleDirectSelectionByPersonItem condition) {
        Pager pager = this.eleDirectSelectionService.loadPagerByAuthFilter(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"ele:directSelection:addDirectSelection", "ele:directSelection:edit"})
    @LogRequest(module="ele_module", object="ele_leftMenu_directSelectionSet", opType="ele_directSelection_add", requestParams={"personPin"}, opContent="pers_person")
    public ZKResultMsg save(EleDirectSelectionItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.eleDirectSelectionService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    public ZKResultMsg getDirectSelectionDevice(String personId, String deviceId) {
        ArrayList<SelectItem> selectItems = new ArrayList<SelectItem>();
        SelectItem selectItem = null;
        List items = this.eleDirectSelectionService.getDirectSelectionDevice(personId, deviceId);
        for (EleDeviceItem eleDeviceItem : items) {
            selectItem = new SelectItem();
            selectItem.setValue(eleDeviceItem.getId());
            selectItem.setText((Object)eleDeviceItem.getAlias());
            selectItems.add(selectItem);
        }
        return new ZKResultMsg(selectItems);
    }

    public ZKResultMsg getDirectFloorSelect(String devId, String selectionFloorNos) {
        ArrayList<SelectItem> selectItems = new ArrayList<SelectItem>();
        SelectItem selectItem = null;
        List items = this.eleFloorService.getFloorItemsByDevIdAndFloorNoNotIn(devId, selectionFloorNos);
        for (EleFloorItem eleFloorItem : items) {
            selectItem = new SelectItem();
            selectItem.setValue(eleFloorItem.getFloorNo() + "");
            selectItem.setText((Object)eleFloorItem.getName());
            selectItems.add(selectItem);
        }
        return new ZKResultMsg(selectItems);
    }

    public DxGrid getSelectionFloorList(EleDirectSelectionSelectFloorItem condition) {
        if (StringUtils.isBlank((CharSequence)condition.getDeviceId())) {
            condition.setDeviceId("-1");
        }
        if (StringUtils.isBlank((CharSequence)condition.getSelectId())) {
            condition.setSelectId("-1");
        }
        if (condition.getType().equals("noSelected")) {
            condition.setSelectFloorIdsNotIn(condition.getSelectId());
        } else if (condition.getType().equals("selected")) {
            condition.setSelectFloorIdsIn(condition.getSelectId());
        }
        Pager pager = this.eleFloorService.getSelectionFloorByAuthFilter(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public DxGrid getPersonDirectSelection(EleDirectSelectionItem condition) {
        Pager pager = this.eleDirectSelectionService.loadDirectSelectionByAuthFilter(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"ele:directSelection:delPersonDirectSelection"})
    @LogRequest(module="ele_module", object="ele_leftMenu_directSelectionSet", opType="common_op_del", requestParams={"personPin"}, opContent="pers_person")
    public ZKResultMsg delPersonDirectSelection(String personId, String directSelectionIds) {
        if (StringUtils.isNotBlank((CharSequence)personId) && StringUtils.isNotBlank((CharSequence)directSelectionIds)) {
            List<String> directSelectionIdList = Arrays.asList(directSelectionIds.split(","));
            this.eleDirectSelectionService.delPersonDirectSelection(personId, directSelectionIdList);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"ele:directSelectionByPerson:setEleParams"})
    public ModelAndView setEleParam(String ids) {
        ElePersonItem tempElePerson = null;
        String[] personIds = ids.split(",");
        this.request.setAttribute("ids", (Object)ids);
        if (personIds != null && personIds.length == 1) {
            tempElePerson = this.elePersonService.getItemByPersonId(personIds[0]);
            this.request.setAttribute("tempElePerson", (Object)tempElePerson);
        }
        this.request.setAttribute("editPage", (Object)"true");
        return new ModelAndView("ele/directSelection/setEleDirectSelectionPersonParam");
    }

    @LogRequest(module="ele_module", object="ele_leftMenu_directSelectionSet", opType="pers_person_eleSetting", requestParams={"personPin"}, opContent="pers_person")
    public ZKResultMsg saveParamSet(ElePersonItem item, String ids) {
        ZKResultMsg res = new ZKResultMsg();
        if (StringUtils.isNotBlank((CharSequence)ids)) {
            for (String id : ids.split(",")) {
                item.setPersonId(id);
                item.setDisabled(Boolean.valueOf(item.getDisabled() == null ? false : item.getDisabled()));
                this.eleDirectSelectionService.saveDirectSelectionParamSet(item);
            }
        }
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    public ZKResultMsg getPersonDirectSelectionDevice(String deviceId) {
        ArrayList<SelectItem> selectItems = new ArrayList<SelectItem>();
        SelectItem selectItem = null;
        List items = this.eleDirectSelectionService.getPersonDirectSelectionDevice(deviceId);
        for (EleDeviceItem eleDeviceItem : items) {
            selectItem = new SelectItem();
            selectItem.setValue(eleDeviceItem.getId());
            selectItem.setText((Object)eleDeviceItem.getAlias());
            selectItems.add(selectItem);
        }
        return new ZKResultMsg(selectItems);
    }
}

