/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ele.controller;

import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.TreeItem;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.format.TreeBuilder;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.ele.remote.EleDeviceEventRemote;
import com.zkteco.zkbiosecurity.ele.service.EleDeviceEventService;
import com.zkteco.zkbiosecurity.ele.vo.EleDeviceEventItem;
import com.zkteco.zkbiosecurity.ele.vo.EleDeviceEventSelectItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class EleDeviceEventController
extends BaseController
implements EleDeviceEventRemote {
    @Autowired
    private EleDeviceEventService eleDeviceEventService;

    @RequiresPermissions(value={"ele:deviceEvent"})
    public ModelAndView index() {
        return new ModelAndView("ele/deviceEvent/eleDeviceEvent");
    }

    @RequiresPermissions(value={"ele:deviceEvent:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.eleDeviceEventService.getItemById(id));
        }
        return new ModelAndView("ele/deviceEvent/editEleDeviceEvent");
    }

    @RequiresPermissions(value={"ele:deviceEvent:edit"})
    public ZKResultMsg save(EleDeviceEventItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.eleDeviceEventService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"ele:deviceEvent:refresh"})
    public DxGrid list(EleDeviceEventItem condition) {
        Pager pager = this.eleDeviceEventService.loadPagerByAuthFilter(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"ele:deviceEvent:del"})
    public ZKResultMsg del(String ids) {
        this.eleDeviceEventService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public TreeItem tree() {
        Set eventList = this.eleDeviceEventService.getAllEventNameSet();
        ArrayList<TreeItem> items = new ArrayList<TreeItem>();
        for (String eventName : eventList) {
            TreeItem item = new TreeItem();
            item.setId(eventName);
            item.setText(I18nUtil.i18nCode((String)eventName, (Object[])new Object[0]));
            item.setParent(new TreeItem("0"));
            items.add(item);
        }
        List treeItems = TreeBuilder.newTreeBuilder(TreeItem.class, String.class).buildToTreeList(items);
        return new TreeItem("0", treeItems);
    }

    public DxGrid listSelect(EleDeviceEventSelectItem condition) {
        Pager pager = new Pager();
        int pageNo = this.getPageNo();
        int pageSize = this.getPageSize();
        Set eventList = this.eleDeviceEventService.getAllEventNameSet();
        ArrayList<EleDeviceEventSelectItem> items = new ArrayList<EleDeviceEventSelectItem>();
        EleDeviceEventSelectItem item = null;
        for (String eventName : eventList) {
            String name = I18nUtil.i18nCode((String)eventName, (Object[])new Object[0]);
            if (StringUtils.isNotBlank((CharSequence)condition.getName()) && !name.contains(condition.getName())) continue;
            item = new EleDeviceEventSelectItem();
            item.setName(name);
            item.setId(eventName);
            items.add(item);
        }
        int beginIndex = pageNo * pageSize;
        int endIndex = (pageNo + 1) * pageSize - 1;
        ArrayList data = new ArrayList();
        for (int i = beginIndex; i <= endIndex && items.size() > i; ++i) {
            data.add(items.get(i));
        }
        pager.setPage(pageNo);
        pager.setSize(pageSize);
        pager.setTotal(items.size());
        pager.setData(data);
        return GridUtil.convert((Pager)pager, condition.getClass());
    }
}

