/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ele.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.ProcessBean;
import com.zkteco.zkbiosecurity.base.bean.SelectItem;
import com.zkteco.zkbiosecurity.base.bean.TreeItem;
import com.zkteco.zkbiosecurity.base.constants.BaseConstants;
import com.zkteco.zkbiosecurity.base.format.TreeBuilder;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.ClassUtil;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.utils.IpUtil;
import com.zkteco.zkbiosecurity.core.utils.StrUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.core.web.cache.ProgressCache;
import com.zkteco.zkbiosecurity.ele.constants.EleConstants;
import com.zkteco.zkbiosecurity.ele.remote.EleDeviceRemote;
import com.zkteco.zkbiosecurity.ele.service.EleBaseDictionaryService;
import com.zkteco.zkbiosecurity.ele.service.EleChannelService;
import com.zkteco.zkbiosecurity.ele.service.EleDeviceOptionService;
import com.zkteco.zkbiosecurity.ele.service.EleDeviceService;
import com.zkteco.zkbiosecurity.ele.service.EleParamsService;
import com.zkteco.zkbiosecurity.ele.vo.EleDeviceExportItem;
import com.zkteco.zkbiosecurity.ele.vo.EleDeviceItem;
import com.zkteco.zkbiosecurity.ele.vo.EleDeviceOptionItem;
import com.zkteco.zkbiosecurity.ele.vo.EleDeviceParamItem;
import com.zkteco.zkbiosecurity.ele.vo.EleGlobalLinkageSelectDeviceItem;
import com.zkteco.zkbiosecurity.ele.vo.EleQueryDeviceItem;
import com.zkteco.zkbiosecurity.ele.vo.EleSearchAddDeviceItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.io.File;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class EleDeviceController
extends ExportController
implements EleDeviceRemote {
    @Autowired
    private EleDeviceService eleDeviceService;
    @Autowired
    private EleDeviceOptionService eleDeviceOptionService;
    @Autowired
    private ProgressCache progressCache;
    @Autowired
    private EleBaseDictionaryService eleBaseDictionaryService;
    @Autowired
    private EleParamsService eleParamsService;
    @Autowired
    private EleChannelService eleChannelService;
    @Value(value="${server.port:8098}")
    private int serverPort;
    @Value(value="${system.filePath:BioSecurityFile}")
    private String systemFilePath;
    @Value(value="${adms.push.port:8088}")
    private int hostPort;
    @Value(value="${security.require-ssl:false}")
    private String isSupportHttps;
    private static final String DEV_UPGRADEFIRMWARE_FILENAME = "emfw.cfg";

    @RequiresPermissions(value={"ele:device"})
    public ModelAndView index() {
        return new ModelAndView("ele/device/eleDevice");
    }

    @RequiresPermissions(value={"ele:device:add", "ele:device:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            EleDeviceItem item = this.eleDeviceService.getItemById(id);
            boolean isSupportExtBoard = this.eleDeviceOptionService.isSupportFunList(item.getSn(), 52);
            this.request.setAttribute("isSupportExtBoard", (Object)isSupportExtBoard);
            this.request.setAttribute("item", (Object)item);
            this.request.setAttribute("editPage", (Object)"true");
        }
        this.request.setAttribute("eleDeviceMode", (Object)this.eleParamsService.getValByName("ele.deviceMode"));
        this.request.setAttribute("offlineFunFlag", (Object)this.eleParamsService.getValByName("ele.offlineFlag"));
        return new ModelAndView("ele/device/editEleDevice");
    }

    @RequiresPermissions(value={"ele:device:add", "ele:device:edit"})
    @LogRequest(module="ele_module", object="common_leftMenu_device", opType="common_op_edit", requestParams={"alias"}, opContent="ele_dev_device")
    public ZKResultMsg save(EleDeviceItem item) {
        ZKResultMsg res = new ZKResultMsg();
        if (StringUtils.isEmpty((CharSequence)item.getId())) {
            if (EleConstants.DEV_MODE_OFFLINE.equals(item.getDeviceMode())) {
                this.eleDeviceService.addOfflineDevice(item);
            } else {
                this.eleDeviceService.addPullDevice(item);
            }
        } else {
            this.eleDeviceService.saveItem(item);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"ele:device:refresh"})
    public DxGrid list(EleDeviceItem condition) {
        Pager pager = this.eleDeviceService.loadPagerByAuthFilter(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"ele:device:del"})
    @LogRequest(module="ele_module", object="common_leftMenu_device", opType="common_op_del", requestParams={"alias"}, opContent="common_dev_name")
    public ZKResultMsg del(String ids) {
        this.eleDeviceService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"ele:device:enable"})
    public ZKResultMsg setDevEnable(String ids) {
        this.eleDeviceService.setDevEnbale(ids);
        return new ZKResultMsg();
    }

    @RequiresPermissions(value={"ele:device:disable"})
    public ZKResultMsg setDevDisable(String ids) {
        this.eleDeviceService.setDevDisable(ids);
        return new ZKResultMsg();
    }

    public ZKResultMsg getAllDeviceList() {
        ArrayList<SelectItem> selectItems = new ArrayList<SelectItem>();
        SelectItem selectItem = null;
        List items = this.eleDeviceService.getByCondition(new EleDeviceItem());
        for (EleDeviceItem eleDeviceItem : items) {
            selectItem = new SelectItem();
            selectItem.setValue(eleDeviceItem.getId());
            selectItem.setText((Object)eleDeviceItem.getAlias());
            selectItems.add(selectItem);
        }
        return new ZKResultMsg(selectItems);
    }

    public ZKResultMsg isAuthorization() {
        ZKResultMsg zkResultMsg = new ZKResultMsg();
        zkResultMsg.setRet("isAuthorizationOnLine");
        return I18nUtil.i18nMsg((ZKResultMsg)zkResultMsg);
    }

    @RequiresPermissions(value={"ele:device:refresh"})
    public DxGrid getGlobalLinkageDevice(EleGlobalLinkageSelectDeviceItem condition) {
        if (StringUtils.isBlank((CharSequence)condition.getSelectId())) {
            condition.setSelectId("-1");
        }
        if ("noSelected".equals(condition.getType())) {
            StringBuilder filterIds = new StringBuilder(condition.getSelectId());
            if (StringUtils.isNotBlank((CharSequence)condition.getFilterId())) {
                filterIds.append(",").append(condition.getFilterId());
            }
            condition.setNotInId(filterIds.toString());
        } else if ("selected".equals(condition.getType())) {
            condition.setInId(condition.getSelectId());
        }
        String authAreaIds = this.eleDeviceService.getAreaIdsByAuthFilter(this.request.getSession().getId());
        if (StringUtils.isNotBlank((CharSequence)authAreaIds)) {
            condition.setAuthAreaIdIn(authAreaIds);
        }
        Pager pager = this.eleDeviceService.getGlobalLinkageSelectDevices(condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"ele:device:searchDev"})
    public ZKResultMsg searchDev(Long nowTime) {
        JSONObject devInfoJson = new JSONObject();
        try {
            List deviceItems = this.eleDeviceService.searchDeviceList();
            devInfoJson.put("ret", (Object)"ok");
            devInfoJson.put("devCount", (Object)deviceItems.size());
            JSONArray jsonArray = new JSONArray();
            deviceItems.forEach(item -> {
                JSONObject rowData = new JSONObject();
                rowData.put("IP", (Object)item.getIp());
                rowData.put("MAC", (Object)item.getMacAddress());
                rowData.put("NetMask", (Object)item.getSubnetMask());
                rowData.put("GATEIPAddress", (Object)item.getGateway());
                rowData.put("SN", (Object)item.getSn());
                rowData.put("Device", (Object)item.getDeviceName());
                rowData.put("Protype", (Object)item.getProtype());
                rowData.put("ModeType", (Object)item.getModeType());
                rowData.put("IsSupportSSL", (Object)item.getIsSupportSSL());
                rowData.put("DNSFunOn", (Object)item.getDnsFunOn());
                rowData.put("DNS", (Object)StringUtils.defaultString((String)item.getDns(), (String)""));
                rowData.put("WebServerURL", (Object)StringUtils.defaultString((String)item.getServerUrl(), (String)""));
                if (item.getIsSupportMultiCard() != null) {
                    rowData.put("isSupportMultiCard", (Object)item.getIsSupportMultiCard().toString());
                }
                jsonArray.add((Object)rowData);
            });
            devInfoJson.put("devData", (Object)jsonArray);
            devInfoJson.put("nowTime", (Object)nowTime);
            devInfoJson.put("isSupportHttps", (Object)this.isSupportHttps);
            devInfoJson.put("hostAddress", (Object)InetAddress.getLocalHost().getHostAddress());
            devInfoJson.put("hostPort", (Object)this.hostPort);
        }
        catch (Exception e) {
            throw new ZKBusinessException((Throwable)e);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg((Object)devInfoJson));
    }

    public ZKResultMsg getAllIPSn() {
        JSONObject devInfoJson = new JSONObject();
        try {
            String ret = this.eleDeviceService.getAllIPSn();
            devInfoJson = JSONObject.parseObject((String)ret);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg((Object)devInfoJson));
    }

    public ZKResultMsg isOnline(String deviceId) {
        List eleDeviceItemList = this.eleDeviceService.getItemListByIds(deviceId);
        StringBuffer offLineAlias = new StringBuffer("");
        StringBuffer offLineIds = new StringBuffer("");
        JSONObject retJson = new JSONObject();
        for (EleDeviceItem dev : eleDeviceItemList) {
            if (!this.eleDeviceService.getStatus(dev.getSn()).equals(String.valueOf(0))) continue;
            offLineIds.append(dev.getId()).append(",");
            offLineAlias.append(dev.getAlias()).append(",");
        }
        retJson.put("ids", (Object)(offLineIds.length() > 0 ? offLineIds.substring(0, offLineIds.length() - 1) : offLineIds.toString()));
        retJson.put("alias", (Object)(offLineAlias.length() > 0 ? offLineAlias.substring(0, offLineAlias.length() - 1) : offLineAlias.toString()));
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg((Object)retJson));
    }

    @RequiresPermissions(value={"ele:device:changeDevIp"})
    public ZKResultMsg modifyIPAddress(EleSearchAddDeviceItem item) {
        ZKResultMsg resultMsg = new ZKResultMsg();
        String mac = item.getMac();
        String options = "";
        if ("devIP".equals(item.getType())) {
            String ip = IpUtil.getLocalIpAddr((HttpServletRequest)this.request);
            List ipList = IpUtil.getAllIPAddr();
            String newIP = item.getNewIP();
            String gateway = item.getGateway();
            String subnetMask = item.getSubnetMask();
            if (newIP.equals(ip) || ipList.contains(newIP)) {
                resultMsg.setRet("500");
                resultMsg.setMsg("ele_dev_addDevIpTip");
                return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
            }
            options = String.format("MAC=%s,IPAddress=%s,GATEIPAddress=%s,NetMask=%s,Reboot=1", mac, newIP, gateway, subnetMask);
        } else {
            String webServerIP = item.getWebServerIP();
            String webServerPort = item.getWebServerPort();
            String newPwd = item.getNewPwd();
            String isSupportSSL = item.getIsSupportSSL();
            options = this.isSupportHttps.equals("true") ? String.format("MAC=%s,ComPwd=%s,WebServerURL=%s,WebServerURLModel=1,Reboot=1", mac, newPwd, "https://" + webServerIP + ":" + webServerPort) : String.format("MAC=%s,ComPwd=%s,WebServerURL=%s,Reboot=1", mac, newPwd, "http://" + webServerIP + ":" + webServerPort);
        }
        String msgStr = "ele_dev_rebootAfterOperate";
        int ret = this.eleDeviceService.modifyDeviceOptions(options);
        if (ret < 0) {
            msgStr = "devIP".equals(item.getType()) && "-14".equals(String.valueOf(ret)) ? "common_dev_modifyAndCommPwdError" : ("webServerIP".equals(item.getType()) && "-14".equals(String.valueOf(ret)) ? "common_commStatus_commPwdError" : this.eleBaseDictionaryService.getCommReason(ret));
            if ("".equals(msgStr)) {
                msgStr = I18nUtil.i18nCode((String)"common_unknown", (Object[])new Object[0]);
            }
            resultMsg.setRet("pwdError");
            resultMsg.setMsg(msgStr);
        } else if ("webServerIP".equals(item.getType())) {
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException e) {
                this.log.error(e.getMessage());
            }
            this.eleDeviceService.authDevice(item.getSn(), item);
            resultMsg.setMsg(msgStr);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }

    @RequiresPermissions(value={"ele:device:syncAllData"})
    public ModelAndView getDevIdsBySyncData(String ids) {
        if (StringUtils.isNotBlank((CharSequence)ids)) {
            List devList = this.eleDeviceService.getItemListByIds(ids);
            StringBuilder devName = new StringBuilder("");
            StringBuilder disabledDevName = new StringBuilder("");
            StringBuilder offlineDevName = new StringBuilder("");
            StringBuilder retIds = new StringBuilder();
            HashMap<String, StringBuffer> devNameMap = new HashMap<String, StringBuffer>();
            for (EleDeviceItem dev : devList) {
                String status = this.eleDeviceService.getStatus(dev.getSn());
                if (String.valueOf(1).equals(status)) {
                    short machineType = dev.getMachineType();
                    retIds.append(dev.getId()).append(",");
                    String devTypeName = (String)EleConstants.MACHINETYPE_DEVTYPE.get(machineType);
                    if (devTypeName == null) {
                        devTypeName = (String)EleConstants.MACHINETYPE_DEVTYPE.get(EleConstants.DEVICE_CONTROL);
                    }
                    if (devNameMap.containsKey(devTypeName)) {
                        ((StringBuffer)devNameMap.get(devTypeName)).append(dev.getAlias() + "&" + dev.getId() + ",");
                        continue;
                    }
                    StringBuffer devNameBuf = new StringBuffer(devTypeName + "-" + I18nUtil.i18nCode((String)((String)EleConstants.DEV_NAME_MAP.get(devTypeName)), (Object[])new Object[0]) + ":" + dev.getAlias() + "&" + dev.getId() + ",");
                    devNameMap.put(devTypeName, devNameBuf);
                    continue;
                }
                if (String.valueOf(2).equals(status) && !dev.getDeviceMode().equals(EleConstants.DEV_MODE_OFFLINE)) {
                    disabledDevName.append(dev.getAlias() + ",");
                    continue;
                }
                offlineDevName.append(dev.getAlias()).append(",");
            }
            for (StringBuffer nameBuf : devNameMap.values()) {
                devName.append(nameBuf.substring(0, nameBuf.length() - 1) + ";");
            }
            this.request.setAttribute("retIds", retIds.length() > 0 ? retIds.substring(0, retIds.length() - 1) : null);
            this.request.setAttribute("devicesName", devName.length() > 0 ? devName.substring(0, devName.length() - 1) : null);
            this.request.setAttribute("disabledDevName", disabledDevName.length() > 0 ? disabledDevName.substring(0, disabledDevName.length() - 1) : null);
            this.request.setAttribute("offlineDevName", offlineDevName.length() > 0 ? offlineDevName.substring(0, offlineDevName.length() - 1) : null);
            return new ModelAndView("ele/device/opEleSyncAllData");
        }
        return null;
    }

    public boolean isExistByAlias(String alias) {
        EleDeviceItem item = new EleDeviceItem();
        item.setAlias(alias);
        item.setEquals(Boolean.valueOf(true));
        List itemList = this.eleDeviceService.getByCondition(item);
        return itemList == null || itemList.size() <= 0;
    }

    public boolean isComAddressExist(String comAddress, String id, String deviceMode) {
        return this.eleDeviceService.isComAddressExist(comAddress, id, deviceMode);
    }

    public boolean isSnExist(String sn) {
        EleDeviceItem item = this.eleDeviceService.getItemBySn(sn);
        return item == null;
    }

    public ZKResultMsg syncAllDataByDevType(String devType, String devId) {
        Set funcSet = new LinkedHashSet();
        JSONArray dataArray = new JSONArray();
        if (StringUtils.isNotBlank((CharSequence)devType) && StringUtils.isNotBlank((CharSequence)devId) && (funcSet = this.eleDeviceService.syncAllDataByDevType(devType, devId)).size() > 0) {
            int i = 0;
            for (String func : funcSet) {
                dataArray.add((Object)func);
                ++i;
            }
        }
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg((Object)dataArray));
    }

    private ModelAndView getDevStatusByIds(String ids, String type) {
        if (StringUtils.isNotBlank((CharSequence)ids) && StringUtils.isNotBlank((CharSequence)type)) {
            StringBuffer retIds = new StringBuffer();
            StringBuffer devName = new StringBuffer("");
            StringBuffer disabledDevName = new StringBuffer("");
            StringBuffer offlineDevName = new StringBuffer("");
            List devList = this.eleDeviceService.getItemListByIds(ids);
            ArrayList devListTemp = new ArrayList();
            devListTemp.addAll(devList);
            ArrayList<String> devNameList = new ArrayList<String>();
            for (EleDeviceItem dev : devListTemp) {
                String status = this.eleDeviceService.getStatus(dev.getSn());
                if (String.valueOf(1).equals(status)) {
                    retIds.append(dev.getId()).append(",");
                    if (devNameList.contains(dev.getDeviceName())) continue;
                    devNameList.add(dev.getDeviceName());
                    continue;
                }
                if (String.valueOf(2).equals(status) && !dev.getDeviceMode().equals(EleConstants.DEV_MODE_OFFLINE)) {
                    disabledDevName.append(dev.getAlias()).append(",");
                } else {
                    offlineDevName.append(dev.getAlias()).append(",");
                }
                devList.remove(dev);
            }
            boolean isNeed = false;
            for (String currDev : devNameList) {
                devName.append(currDev).append(":");
                for (EleDeviceItem dev : devList) {
                    String status = this.eleDeviceService.getStatus(dev.getSn());
                    if (!currDev.equals(dev.getDeviceName()) || String.valueOf(2).equals(status)) continue;
                    isNeed = true;
                    devName.append(dev.getAlias() + "&" + dev.getId()).append(",");
                }
                if (isNeed) {
                    devName.append(";");
                    continue;
                }
                if (devName.indexOf(";") < 0) {
                    devName = new StringBuffer("");
                    continue;
                }
                devName.substring(0, devName.lastIndexOf(";") - 1);
            }
            this.request.setAttribute("retIds", (Object)("".equals(retIds.toString()) ? "" : retIds.substring(0, retIds.length() - 1)));
            this.request.setAttribute("devicesName", (Object)("".equals(devName.toString()) ? "" : devName.substring(0, devName.length() - 1)));
            this.request.setAttribute("disabledDevName", (Object)("".equals(disabledDevName.toString()) ? "" : disabledDevName.substring(0, disabledDevName.length() - 1)));
            this.request.setAttribute("offlineDevName", (Object)("".equals(offlineDevName.toString()) ? "" : offlineDevName.substring(0, offlineDevName.length() - 1)));
            switch (type) {
                case "upgradeFirmware": {
                    return new ModelAndView("ele/device/opEleUpgradeFirmware");
                }
                case "uploadUserInfo": {
                    return new ModelAndView("ele/device/opEleUploadUserInfo");
                }
                case "uploadEleLogs": {
                    return new ModelAndView("ele/device/opEleUploadDevLogs");
                }
                case "syncTime": {
                    return new ModelAndView("ele/device/opEleSetDevTime");
                }
            }
        }
        return null;
    }

    @RequiresPermissions(value={"ele:device:rebootDevice"})
    public ZKResultMsg rebootDevice(String ids) {
        String offline = "";
        ArrayList<String> rebootDevIdList = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)ids)) {
            List devList = this.eleDeviceService.getItemListByIds(ids);
            for (EleDeviceItem dev : devList) {
                if (!String.valueOf(1).equals(this.eleDeviceService.getStatus(dev.getSn()))) {
                    offline = offline + dev.getAlias() + I18nUtil.i18nCode((String)"common_dev_offlinePrompt", (Object[])new Object[0]) + ",";
                    continue;
                }
                rebootDevIdList.add(dev.getId());
            }
            this.eleDeviceService.rebootDevice(rebootDevIdList, false);
            if (StringUtils.isNotBlank((CharSequence)offline)) {
                offline = offline.substring(0, offline.length() - 1);
                throw new ZKBusinessException(offline);
            }
        }
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"ele:device:getOptFromDev"})
    @LogRequest(module="ele_module", object="common_leftMenu_device", opType="common_dev_getDevOpt", requestParams={"alias"}, opContent="common_dev_name")
    public ZKResultMsg getOptFromDev(String ids) {
        StringBuffer failedDev = new StringBuffer("");
        ZKResultMsg resultMsg = new ZKResultMsg();
        String retStr = "ok";
        try {
            if (StringUtils.isNotBlank((CharSequence)ids)) {
                List devList = this.eleDeviceService.getItemListByIds(ids);
                ArrayList<Long> cmdIdList = new ArrayList<Long>();
                HashMap<Long, String> cmdIdAndDevNameMap = new HashMap<Long, String>();
                block2: for (EleDeviceItem dev : devList) {
                    if (!this.eleDeviceService.getStatus(dev.getSn()).equals(String.valueOf(1))) {
                        failedDev.append(dev.getAlias() + "," + I18nUtil.i18nCode((String)"common_dev_offlinePrompt", (Object[])new Object[0]) + "</br>");
                        retStr = "500";
                        resultMsg.setRet(retStr);
                        resultMsg.setMsg(failedDev.substring(0, failedDev.length() - 1));
                        continue;
                    }
                    long cmdIdTemp = 0L;
                    List cmdIds = this.eleDeviceService.getOptFromDev(dev.getSn(), true);
                    for (Long cmdId : cmdIds) {
                        if (cmdId < 0L) {
                            if (cmdIdTemp != 0L) {
                                cmdIdList.remove(cmdIdTemp);
                                cmdIdAndDevNameMap.remove(cmdIdTemp);
                            }
                            failedDev.append(dev.getAlias() + ":" + I18nUtil.i18nCode((String)"common_op_failed", (Object[])new Object[0]));
                            retStr = "400";
                            resultMsg.setRet(retStr);
                            resultMsg.setMsg(I18nUtil.i18nCode((String)"common_op_failed", (Object[])new Object[0]));
                            continue block2;
                        }
                        cmdIdList.add(cmdId);
                        cmdIdAndDevNameMap.put(cmdId, dev.getAlias());
                    }
                }
                if (cmdIdList.size() > 0) {
                    Iterator iterator = cmdIdList.iterator();
                    while (iterator.hasNext()) {
                        long cmdId = (Long)iterator.next();
                        Map resultMap = this.eleDeviceService.getCmdResultById(Long.valueOf(cmdId), 30);
                        if (!Objects.nonNull(resultMap)) continue;
                        Integer result = Integer.valueOf((String)resultMap.get("result"));
                        if (failedDev.indexOf((String)cmdIdAndDevNameMap.get(cmdId)) != -1) continue;
                        if (Objects.isNull(result)) {
                            failedDev.append((String)cmdIdAndDevNameMap.get(cmdId) + "," + I18nUtil.i18nCode((String)"common_op_failed", (Object[])new Object[0]) + "<br>");
                            retStr = "400";
                            continue;
                        }
                        if (result >= 0) continue;
                        String failedInfo = this.eleBaseDictionaryService.getCommReason(result.intValue());
                        failedInfo = StringUtils.isNotBlank((CharSequence)failedInfo) ? I18nUtil.i18nCode((String)failedInfo, (Object[])new Object[0]) : result.toString();
                        failedDev.append((String)cmdIdAndDevNameMap.get(cmdId) + "," + I18nUtil.i18nCode((String)"common_op_failed", (Object[])new Object[0]) + "," + I18nUtil.i18nCode((String)"common_dev_errorCode", (Object[])new Object[0]) + ":" + failedInfo + "<br>");
                        retStr = "400";
                    }
                    if ("400".equals(retStr)) {
                        resultMsg.setRet(retStr);
                        resultMsg.setMsg(I18nUtil.i18nCode((String)"common_dev_getDevOptFails", (Object[])new Object[0]));
                    }
                }
            }
        }
        catch (Exception e) {
            throw ZKBusinessException.errorException((String)I18nUtil.i18nCode((String)"common_dev_getDevOptFails", (Object[])new Object[0]), (Object[])new Object[0]);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }

    @RequiresPermissions(value={"ele:device:changeDevIp"})
    public ModelAndView getDevIPAddressInfo(String ids, String type) {
        return this.getDevById(ids, type);
    }

    @RequiresPermissions(value={"ele:device:changeDevPwd"})
    public ModelAndView getDevCommPwdInfo(String ids, String type) {
        return this.getDevById(ids, type);
    }

    @RequiresPermissions(value={"ele:device:updateRs485Addr"})
    public ModelAndView getDevRs485AddressInfo(String ids, String type) {
        return this.getDevById(ids, type);
    }

    @RequiresPermissions(value={"ele:device:changeDevMThreshold"})
    public ModelAndView getDevMThresholdInfo(String ids, String type) {
        return this.getDevById(ids, type);
    }

    private ModelAndView getDevById(String id, String type) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            EleDeviceItem tempDev = this.eleDeviceService.getItemById(id);
            this.request.setAttribute("editPage", (Object)true);
            this.request.setAttribute("tempEleDevice", (Object)tempDev);
            if (StringUtils.isNotBlank((CharSequence)type) && tempDev != null) {
                String status = this.eleDeviceService.getStatus(tempDev.getSn());
                if (!status.equals(String.valueOf(1))) {
                    if (tempDev.getDeviceMode().equals(EleConstants.DEV_MODE_OFFLINE)) {
                        this.request.setAttribute("failedReason", (Object)0);
                    } else {
                        this.request.setAttribute("failedReason", (Object)status);
                    }
                    return new ModelAndView("ele/device/opDevNotSupportFeatureTips");
                }
                if ("changeDevIp".equals(type)) {
                    if (this.eleDeviceOptionService.isSupportFunList(tempDev.getSn(), 28)) {
                        this.request.setAttribute("isSupportDualCard", (Object)true);
                        EleDeviceOptionItem devOpt = this.eleDeviceOptionService.getDevOptValueBySnAndName(tempDev.getSn(), "IPAddress1");
                        if (devOpt != null) {
                            this.request.setAttribute(devOpt.getName(), (Object)devOpt.getValue());
                        }
                        if ((devOpt = this.eleDeviceOptionService.getDevOptValueBySnAndName(tempDev.getSn(), "NetMask1")) != null) {
                            this.request.setAttribute(devOpt.getName(), (Object)devOpt.getValue());
                        }
                        if ((devOpt = this.eleDeviceOptionService.getDevOptValueBySnAndName(tempDev.getSn(), "GATEIPAddress1")) != null) {
                            this.request.setAttribute(devOpt.getName(), (Object)devOpt.getValue());
                        }
                    }
                    return new ModelAndView("ele/device/opEleChangeDevCommAddr");
                }
                if ("changeDevPwd".equals(type)) {
                    boolean isExistOldPwd = true;
                    if (tempDev.getCommPwd() == null || "".equals(tempDev.getCommPwd())) {
                        isExistOldPwd = false;
                    }
                    this.request.setAttribute("isExistOldPwd", (Object)isExistOldPwd);
                    return new ModelAndView("ele/device/opEleChangeDevPwd");
                }
                if ("changeDevMThreshold".equals(type)) {
                    String mThreshold = this.eleDeviceOptionService.getDevOptionValueByDevId(id, "MThreshold");
                    this.request.setAttribute("mThreshold", (Object)mThreshold);
                    return new ModelAndView("ele/device/opEleChangeDevMThreshold");
                }
                if ("updateRs485Addr".equals(type)) {
                    if (tempDev.getCommType() == 3) {
                        this.request.setAttribute("failedReason", (Object)EleConstants.DEV_NOT_SUPPORT_FEATURE);
                        return new ModelAndView("ele/device/opDevNotSupportFeatureTips");
                    }
                    return new ModelAndView("ele/device/opEleUpdateRs485Addr");
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZKResultMsg upgradeFirmware(String devIds, String devRadio, MultipartFile devFile) {
        ZKResultMsg resultMsg = new ZKResultMsg();
        if (StringUtils.isNotBlank((CharSequence)devIds) && StringUtils.isNotBlank((CharSequence)devRadio)) {
            try {
                this.progressCache.beginProcess(I18nUtil.i18nCode((String)"common_op_startProcessing", (Object[])new Object[0]) + "<br/>");
                File filePath = this.saveFile(devFile, DEV_UPGRADEFIRMWARE_FILENAME);
                this.progressCache.setProcess(new ProcessBean(0, 5, "<font>" + I18nUtil.i18nCode((String)"common_dev_fileUploadSuccess", (Object[])new Object[0]) + "...</font><br/>"));
                List deviceItemList = this.eleDeviceService.getItemListByIds(devIds);
                List cmdIdList = this.eleDeviceService.upgradeFirmware(devIds, filePath, "localhost", this.serverPort);
                this.progressCache.setProcess(new ProcessBean(0, 10, "<font>" + I18nUtil.i18nCode((String)"common_dev_cmdSendSucceed", (Object[])new Object[0]) + "," + I18nUtil.i18nCode((String)"common_dev_upgrade", (Object[])new Object[0]) + "...</font><br/>"));
                ArrayList<EleDeviceItem> successDevList = new ArrayList<EleDeviceItem>();
                ArrayList<String> devIdList = new ArrayList<String>();
                for (int index = 0; index < cmdIdList.size(); ++index) {
                    long cmdId = (Long)cmdIdList.get(index);
                    Map resultMap = this.eleDeviceService.getCmdResultById(Long.valueOf(cmdId), 1800);
                    if (!Objects.nonNull(resultMap)) continue;
                    int total = 50 / deviceItemList.size() * (index + 1) + 30;
                    Integer result = Integer.parseInt((String)resultMap.get("result"));
                    EleDeviceItem dev = this.eleDeviceService.getItemBySn((String)resultMap.get("sn"));
                    if (result >= 0) {
                        this.progressCache.setProcess(new ProcessBean(70, total, "<font>" + dev.getAlias() + ":" + I18nUtil.i18nCode((String)"common_dev_upgradeSuccess", (Object[])new Object[0]) + "," + I18nUtil.i18nCode((String)"common_dev_reboot", (Object[])new Object[0]) + "...</font><br/>"));
                        successDevList.add(dev);
                        devIdList.add(dev.getId());
                        continue;
                    }
                    String failedInfo = this.eleBaseDictionaryService.getCommReason(result.intValue());
                    failedInfo = StringUtils.isNotBlank((CharSequence)failedInfo) ? I18nUtil.i18nCode((String)failedInfo, (Object[])new Object[0]) : result.toString();
                    this.progressCache.setProcess(new ProcessBean(total + 20, total + 20, "<font class='zk-msg-error'>" + dev.getAlias() + ":" + I18nUtil.i18nCode((String)"common_dev_upgradeFail", (Object[])new Object[0]) + "," + I18nUtil.i18nCode((String)"common_dev_errorCode", (Object[])new Object[0]) + ":" + failedInfo + "...</font><br/>"));
                }
                if (devIdList.size() > 0) {
                    this.eleDeviceService.rebootDevice(devIdList, true);
                }
                if (successDevList.size() > 0) {
                    int count = 5;
                    for (int i = 1; i <= count; ++i) {
                        if (i == 12) {
                            this.progressCache.setProcess(new ProcessBean(70 + i, 70 + i, "<font>...</font><br/>"));
                            break;
                        }
                        if (i == 1) {
                            this.progressCache.setProcess(new ProcessBean(70 + i, 70 + i, "<font>" + I18nUtil.i18nCode((String)"common_devOpType_connect", (Object[])new Object[0]) + "...</font><br/>"));
                            this.progressCache.setProcess(new ProcessBean(70 + i, 70 + i, I18nUtil.i18nCode((String)"common_dev_dealTimeout", (Object[])new Object[]{3 + I18nUtil.i18nCode((String)"common_minutes", (Object[])new Object[0])}) + "<br/>"));
                        } else {
                            this.progressCache.setProcess(new ProcessBean(70 + i, 70 + i));
                            if (Short.parseShort(this.eleDeviceService.getStatus(((EleDeviceItem)deviceItemList.get(0)).getSn())) != 1) {
                                ++count;
                            }
                        }
                        Thread.sleep(15000L);
                    }
                    for (EleDeviceItem dev : successDevList) {
                        this.progressCache.setProcess(new ProcessBean(85, 85, "<font>" + dev.getAlias() + ":" + I18nUtil.i18nCode((String)"common_devOpType_dataUpdate", (Object[])new Object[0]) + "...</font><br/>"));
                        this.eleDeviceService.getOptFromDev(dev.getSn(), false);
                        this.progressCache.setProcess(new ProcessBean(90, 90, "<font>" + dev.getAlias() + ":" + I18nUtil.i18nCode((String)"common_dev_upgradeSuccess", (Object[])new Object[0]) + "</font><br/>"));
                    }
                }
            }
            catch (Exception e) {
                this.progressCache.finishProcess("<font class='zk-msg-error'>" + I18nUtil.i18nCode((String)"common_dev_upgradeFail", (Object[])new Object[0]) + "...</font><br/>");
                this.log.error("exception ", (Throwable)e);
            }
            finally {
                this.progressCache.finishProcess("<font>" + I18nUtil.i18nCode((String)"common_progress_finish", (Object[])new Object[0]) + "</font><br/>");
            }
        }
        return resultMsg;
    }

    private File saveFile(MultipartFile devFile, String fileName) throws Exception {
        File file;
        String realPath = this.systemFilePath + "/upload/ele/firmware";
        File tempFile = new File(realPath);
        if (!tempFile.isAbsolute()) {
            realPath = ClassUtil.getRootPath() + "/" + realPath;
            tempFile = new File(realPath);
        }
        if (!tempFile.exists()) {
            tempFile.mkdirs();
        }
        if ((file = new File(realPath + "/" + fileName)).exists()) {
            file.delete();
        }
        devFile.transferTo(file);
        return file;
    }

    @RequiresPermissions(value={"ele:device:uploadUserInfo"})
    @LogRequest(module="ele_module", object="common_leftMenu_device", opType="common_dev_getPersonInfo", requestParams={"alias"}, opContent="common_dev_name")
    public ZKResultMsg uploadUserInfo(String devIds, String dataType, String tempClientId) {
        if (!tempClientId.equals(this.request.getSession().getAttribute("beforeClientId"))) {
            this.request.getSession().setAttribute("beforeClientId", (Object)tempClientId);
            this.uploadPersonInfoFromDev(devIds, dataType);
        }
        return null;
    }

    private void uploadPersonInfoFromDev(String devIds, String dataType) {
        ArrayList devIdList = Lists.newArrayList((Object[])devIds.split(","));
        this.progressCache.beginProcess(I18nUtil.i18nCode((String)"common_op_startProcessing", (Object[])new Object[0]) + "...<br/>");
        ArrayList cmdIdList = Lists.newArrayList();
        String devId = null;
        Map dataMap = null;
        int total = 0;
        int devSize = devIdList.size();
        for (int i = 0; i < devSize; ++i) {
            devId = (String)devIdList.get(i);
            dataMap = this.eleDeviceService.getPersonInfoFromDev(devId, dataType);
            if (dataMap.containsKey("cmdIds") && !"".equals(dataMap.get("cmdIds"))) {
                String[] cmdIdArray;
                String cmdIds = (String)dataMap.get("cmdIds");
                for (String cmdId : cmdIdArray = cmdIds.split(",")) {
                    cmdIdList.add(cmdId);
                }
            }
            this.progressCache.setProcess(new ProcessBean(100, total, (String)dataMap.get("devName") + I18nUtil.i18nCode((String)"common_dev_cmdSendSucceed", (Object[])new Object[0]) + "<br/>"));
        }
        ArrayList cmdIdArray = Lists.newArrayList((Iterable)cmdIdList);
        int ret = this.dealQueryDataFromRedis(cmdIdArray, 1200000, this.progressCache, false);
        if (ret == 0) {
            for (String cmdId : cmdIdList) {
                String key = "ele:queryConflictCard:" + cmdId;
                String conflictCard = this.eleDeviceService.getQueryData(key);
                if ("".equals(conflictCard)) continue;
                String msg = I18nUtil.i18nCode((String)"ele_dev_conflictCardNo", (Object[])new Object[]{conflictCard});
                this.progressCache.setProcess(new ProcessBean(100, 99, "<font class='zk-msg-error'>" + msg + "</font><br/>"));
            }
            this.progressCache.finishProcess(I18nUtil.i18nCode((String)"common_progress_finish", (Object[])new Object[0]));
        } else if (ret == -1) {
            this.progressCache.finishProcess("<font class='zk-msg-error'>" + I18nUtil.i18nCode((String)"common_progress_getDataFailed", (Object[])new Object[0]) + "...</font><br/>");
        } else if (ret == 1) {
            this.progressCache.finishProcess("<font class='zk-msg-warn'>" + I18nUtil.i18nCode((String)"common_progress_busyFailed", (Object[])new Object[0]) + "</font><br/>");
        }
    }

    private int dealQueryDataFromRedis(List<String> cmdIdList, int timeout, ProgressCache dealRate, boolean newLog) {
        int ret = 0;
        String key = null;
        EleQueryDeviceItem dev = null;
        int cmdLen = cmdIdList.size();
        try {
            int time;
            dealRate.setProcess(new ProcessBean(100, 0, I18nUtil.i18nCode((String)"common_op_processing", (Object[])new Object[0]) + "<br/>"));
            int everyProcess = 100 / cmdLen;
            for (time = timeout; time > 0 && cmdIdList.size() != 0; time -= 4000) {
                for (int j = 0; j < cmdIdList.size(); ++j) {
                    key = "ele:queryData:" + cmdIdList.get(j);
                    String queryData = this.eleDeviceService.getQueryData(key);
                    if ("".equals(queryData)) continue;
                    JSONObject tempJson = JSONObject.parseObject((String)queryData);
                    dev = this.eleDeviceService.getQueryItemBySn(tempJson.getString("sn"));
                    int process = everyProcess * (cmdLen - cmdIdList.size());
                    if (dev != null) {
                        if (tempJson.containsKey((Object)"exception")) {
                            dealRate.setProcess(new ProcessBean(100, 99, "<font class='zk-msg-error'>" + dev.getAlias() + ":" + I18nUtil.i18nCode((String)"ele_dev_getInfoFail", (Object[])new Object[0]) + "</font><br/><font class='zk-msg-error'>" + dev.getAlias() + ":" + I18nUtil.i18nCode((String)tempJson.getString("exception"), (Object[])new Object[0]) + "</font><br/>"));
                            this.eleDeviceService.delQueryData(key);
                            cmdIdList.remove(j);
                            continue;
                        }
                        if (tempJson.getIntValue("packIdx") > tempJson.getIntValue("packCnt")) continue;
                        if (tempJson.getIntValue("packCnt") != 0) {
                            process = everyProcess * (cmdLen - cmdIdList.size()) + everyProcess * tempJson.getIntValue("packIdx") / tempJson.getIntValue("packCnt");
                        }
                        process = process == 100 ? process - 1 : process;
                        dealRate.setProcess(new ProcessBean(100, process));
                        if (tempJson.getIntValue("packCnt") != tempJson.getIntValue("packIdx")) continue;
                        String tableDesc = "";
                        if (tempJson.containsKey((Object)"table")) {
                            tableDesc = I18nUtil.i18nCode((String)((String)this.eleBaseDictionaryService.getBaseDictionaryMap("opType").get(tempJson.getString("table"))), (Object[])new Object[0]);
                        }
                        StringBuffer desc = new StringBuffer("");
                        if (tempJson.getIntValue("packCnt") == 0) {
                            desc.append(dev.getAlias()).append(":" + I18nUtil.i18nCode((String)"ele_dev_getInfoXSuccess", (Object[])new Object[]{tableDesc}) + "<br/>").append(" " + I18nUtil.i18nCode((String)"ele_dev_noData", (Object[])new Object[0]) + "<br/>");
                        } else if (Long.parseLong(tempJson.getString("count")) == 0L) {
                            desc.append(dev.getAlias()).append(":" + I18nUtil.i18nCode((String)"ele_dev_getInfoXSuccess", (Object[])new Object[]{tableDesc}) + "<br/>");
                            if ("transaction".equals(tempJson.getString("table"))) {
                                desc.append(" " + I18nUtil.i18nCode((String)"ele_dev_noNewData", (Object[])new Object[0]) + "<br/>");
                            } else {
                                desc.append(" " + I18nUtil.i18nCode((String)"ele_dev_noData", (Object[])new Object[0]) + "<br/>");
                            }
                        } else {
                            desc.append(dev.getAlias()).append(":" + I18nUtil.i18nCode((String)"ele_dev_getInfoXSuccess", (Object[])new Object[]{tableDesc}) + "<br/>").append(I18nUtil.i18nCode((String)"common_dev_getTotal", (Object[])new Object[0]) + " " + Long.valueOf(tempJson.getString("count"))).append(" " + I18nUtil.i18nCode((String)"common_dev_record", (Object[])new Object[0])).append("," + I18nUtil.i18nCode((String)"common_dev_duplicateData", (Object[])new Object[0])).append(" " + (Long.parseLong(tempJson.getString("count")) - Long.parseLong(tempJson.getString("update")) - Long.parseLong(tempJson.getString("insert")))).append(" " + I18nUtil.i18nCode((String)"common_dev_record", (Object[])new Object[0]) + ",").append(I18nUtil.i18nCode((String)"common_dev_insertData", (Object[])new Object[0]) + " " + Long.valueOf(tempJson.getString("insert")) + " ").append(I18nUtil.i18nCode((String)"common_dev_record", (Object[])new Object[0]) + ",").append(I18nUtil.i18nCode((String)"common_dev_updateData", (Object[])new Object[0]) + " " + Long.valueOf(tempJson.getString("update")) + " ").append(I18nUtil.i18nCode((String)"common_dev_record", (Object[])new Object[0]) + "<br/>");
                        }
                        dealRate.setProcess(new ProcessBean(100, process, desc.toString()));
                        this.eleDeviceService.delQueryData(key);
                        cmdIdList.remove(j);
                        continue;
                    }
                    dealRate.setProcess(new ProcessBean(100, process, "<font class='zk-msg-error'>" + I18nUtil.i18nCode((String)"common_dev_notExistDev", (Object[])new Object[0]) + ", SN=" + tempJson.getString("sn") + "</font><br/>"));
                    this.eleDeviceService.delQueryData(key);
                    cmdIdList.remove(j);
                }
                Thread.sleep(4000L);
            }
            if (time <= 0) {
                ret = 1;
            }
        }
        catch (Exception e) {
            ret = -1;
            this.log.error("exception" + e);
        }
        return ret;
    }

    private void sendCmdAndGetDataCount(Short dataType, String devIds) {
        if (StringUtils.isNotBlank((CharSequence)devIds)) {
            ArrayList devIdList = Lists.newArrayList((Object[])devIds.split(","));
            this.progressCache.beginProcess(I18nUtil.i18nCode((String)"common_op_startProcessing", (Object[])new Object[0]) + "...<br/>");
            StringBuffer retCmdBuf = new StringBuffer();
            Map dataMap = null;
            for (String devId : devIdList) {
                int i = 0;
                int lastTotal = (int)(((double)i + 0.3) / (double)devIdList.size() * 100.0);
                dataMap = this.eleDeviceService.sendCmdAndGetDataCount(dataType, devId);
                retCmdBuf.append((String)dataMap.get("cmdIds")).append(",");
                this.progressCache.setProcess(new ProcessBean(100, lastTotal, (String)dataMap.get("devName") + ":" + I18nUtil.i18nCode((String)"common_dev_cmdSendSucceed", (Object[])new Object[0]) + "...<br/>"));
                ++i;
            }
            this.progressCache.beginProcess(I18nUtil.i18nCode((String)"common_op_processing", (Object[])new Object[0]) + "...<br/>");
            String[] cmdIdArray = retCmdBuf.toString().split(",");
            int cmdIdArrayLen = cmdIdArray.length;
            for (int index = 0; index < cmdIdArrayLen; ++index) {
                String cmdId = cmdIdArray[index];
                if ("".equals(cmdId)) continue;
                int total = (int)((double)(index + 1) * 1.0 / (double)cmdIdArrayLen * 100.0);
                total = total == 100 ? 99 : total;
                Map resultMap = this.eleDeviceService.getCmdResultById(Long.valueOf(cmdId), 20);
                if (Objects.nonNull(resultMap)) {
                    Integer result = Integer.valueOf((String)resultMap.get("result"));
                    String sn = (String)resultMap.get("sn");
                    EleQueryDeviceItem dev = this.eleDeviceService.getQueryItemBySn(sn);
                    String fingerVersion = this.eleDeviceOptionService.getValueByDevSnAndName(dev.getSn(), "~ZKFPVersion");
                    if (Objects.nonNull(dev)) {
                        if (result >= 0) {
                            if ("".equals(this.eleDeviceService.getQueryData("IS_ERROR_USER"))) {
                                String showText = "";
                                String dataCount = "0";
                                JSONObject dataCountJson = JSONObject.parseObject((String)this.eleDeviceService.getQueryData("ele:dataCount:" + cmdId));
                                if (dataType.equals(EleConstants.DEV_TYPE_ZERO)) {
                                    dataCount = dataCountJson.get((Object)"user").toString();
                                    showText = I18nUtil.i18nCode((String)"ele_dev_getPersonCount", (Object[])new Object[0]) + ":" + dataCount + "<br/>";
                                } else if (dataType.equals(EleConstants.DEV_TYPE_FIRST)) {
                                    dataCount = dataCountJson.containsKey((Object)"biodata") ? dataCountJson.get((Object)"biodata").toString() : dataCountJson.get((Object)"templatev10").toString();
                                    showText = I18nUtil.i18nCode((String)"ele_dev_getFPCount", (Object[])new Object[0]) + ":" + dataCount + "<br/>";
                                } else if (BaseConstants.BaseBioType.PALM_BIO_TYPE.equals(dataType)) {
                                    dataCount = dataCountJson.get((Object)"biodata").toString();
                                    showText = I18nUtil.i18nCode((String)"ele_dev_getPalmCount", (Object[])new Object[0]) + ":" + dataCount + "<br/>";
                                } else if (BaseConstants.BaseBioType.BIOPHOTO_BIO_TYPE.equals(dataType)) {
                                    dataCount = dataCountJson.get((Object)"biodata").toString();
                                    showText = I18nUtil.i18nCode((String)"pers_person_faceBiodataCount", (Object[])new Object[0]) + ":" + dataCount + "<br/>";
                                }
                                if (!"".equals(this.eleDeviceService.getQueryData("SUM_RECORD_USER"))) {
                                    this.progressCache.setProcess(new ProcessBean(100, total, dev.getAlias() + ":" + I18nUtil.i18nCode((String)"ele_dev_getInfoSuccess", (Object[])new Object[0]) + "<br/>" + showText));
                                    this.eleDeviceService.delQueryData("SUM_RECORD_USER");
                                } else {
                                    this.progressCache.setProcess(new ProcessBean(100, total, dev.getAlias() + ":" + I18nUtil.i18nCode((String)"ele_dev_getInfoSuccess", (Object[])new Object[0]) + "<br/>" + showText));
                                }
                            } else {
                                this.progressCache.setProcess(new ProcessBean(100, total, dev.getAlias() + ":" + I18nUtil.i18nCode((String)"ele_dev_getInfoFail", (Object[])new Object[0]) + "<br/>" + I18nUtil.i18nCode((String)"common_dev_errorCode", (Object[])new Object[0]) + ":" + this.eleDeviceService.getQueryData("IS_ERROR_USER") + "</br>"));
                                this.eleDeviceService.delQueryData("IS_ERROR_USER");
                            }
                            this.eleDeviceService.delQueryData("ele:dataCount:" + cmdId);
                            continue;
                        }
                        String failedInfo = this.eleBaseDictionaryService.getCommReason(result.intValue());
                        failedInfo = StringUtils.isNotBlank((CharSequence)failedInfo) ? I18nUtil.i18nCode((String)failedInfo, (Object[])new Object[0]) : result.toString();
                        this.progressCache.setProcess(new ProcessBean(100, total, "<font class='zk-msg-error'>" + dev.getAlias() + ":" + I18nUtil.i18nCode((String)"ele_dev_getInfoFail", (Object[])new Object[0]) + "</font>," + I18nUtil.i18nCode((String)"common_dev_errorCode", (Object[])new Object[0]) + ":" + failedInfo + "</br>"));
                        continue;
                    }
                    this.progressCache.setProcess(new ProcessBean(100, total, "<font class='zk-msg-error'>" + I18nUtil.i18nCode((String)"common_dev_notExistDev", (Object[])new Object[0]) + ", SN=" + sn + "</font><br/>"));
                    continue;
                }
                this.progressCache.setProcess(new ProcessBean(100, total, "<font class='zk-msg-error'>" + I18nUtil.i18nCode((String)"ele_dev_getInfoFail", (Object[])new Object[0]) + "</font></br>"));
            }
            this.progressCache.finishProcess(I18nUtil.i18nCode((String)"common_progress_finish", (Object[])new Object[0]));
        }
    }

    @RequiresPermissions(value={"ele:device:uploadEleLogs"})
    @LogRequest(module="ele_module", object="common_leftMenu_device", opType="common_dev_getTrans", requestParams={"alias"}, opContent="common_dev_name")
    public ZKResultMsg uploadEleLogs(String devIds, String records) {
        String[] devIdArray;
        boolean newLog = "1".equals(records);
        this.progressCache.beginProcess(I18nUtil.i18nCode((String)"common_op_startProcessing", (Object[])new Object[0]) + "...<br/>");
        ArrayList<String> cmdIdList = new ArrayList<String>();
        int total = 0;
        for (String devId : devIdArray = devIds.split(",")) {
            Map devDataMap = this.eleDeviceService.uploadEleLogs(devId, records);
            cmdIdList.addAll(Lists.newArrayList((Object[])((String)devDataMap.get("cmdId")).split(",")));
            this.progressCache.setProcess(new ProcessBean(100, total, (String)devDataMap.get("alias") + ":" + I18nUtil.i18nCode((String)"common_dev_cmdSendSucceed", (Object[])new Object[0]) + "<br/>"));
        }
        int ret = this.dealQueryDataFromRedis(cmdIdList, 3600000, this.progressCache, newLog);
        if (ret == 0) {
            this.progressCache.finishProcess(I18nUtil.i18nCode((String)"common_progress_finish", (Object[])new Object[0]));
        } else if (ret == -1) {
            this.progressCache.finishProcess("<font class='zk-msg-error'>" + I18nUtil.i18nCode((String)"common_commStatus_getEventFailed", (Object[])new Object[0]) + "...</font><br/>");
        } else if (ret == 1) {
            this.progressCache.finishProcess("<font class='zk-msg-warn'>" + I18nUtil.i18nCode((String)"common_progress_busyFailed", (Object[])new Object[0]) + "</font><br/>");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermissions(value={"ele:device:syncAllData"})
    @LogRequest(module="ele_module", object="common_leftMenu_device", opType="common_dev_syncAllDataToDev", requestParams={"alias"}, opContent="common_dev_name")
    public ZKResultMsg syncAllData(String devIds, String optBoxValue) {
        try {
            String[] optBox = optBoxValue.split(",");
            this.progressCache.beginProcess(I18nUtil.i18nCode((String)"common_op_processing", (Object[])new Object[0]) + "...<br/>");
            List devList = this.eleDeviceService.getItemListByIds(devIds);
            ArrayList<String> devIdList = new ArrayList<String>();
            int size = devList.size();
            for (int i = 0; i < size; ++i) {
                EleDeviceItem dev = (EleDeviceItem)devList.get(i);
                devIdList.add(dev.getId());
                int total = (int)((float)(i + 1) / (float)size * 100.0f);
                int lastTotal = (int)(((double)i + 0.3) / (double)size * 100.0);
                this.progressCache.setProcess(new ProcessBean(30, lastTotal, dev.getAlias() + ":" + I18nUtil.i18nCode((String)"common_dev_syncPrompt", (Object[])new Object[0]) + "<br/>"));
                this.eleDeviceService.syncDataToDev(dev.getSn(), optBox);
                this.progressCache.setProcess(new ProcessBean(100, total, dev.getAlias() + ":" + I18nUtil.i18nCode((String)"common_dev_syncSuccess", (Object[])new Object[0]) + "<br/>"));
            }
            this.eleDeviceService.informOtherModuleSyncData(devIdList);
        }
        catch (Exception e) {
            this.log.error("exception", (Throwable)e);
        }
        finally {
            this.progressCache.finishProcess(I18nUtil.i18nCode((String)"common_progress_finish", (Object[])new Object[0]));
        }
        return null;
    }

    public ZKResultMsg changeDevIp(String id, String ipAddress, String subnetMask, String gateway, String ipAddressSec, String netMaskSec, String gateIPAddressSec) {
        ZKResultMsg resultMsg = new ZKResultMsg();
        if (StringUtils.isNotBlank((CharSequence)id)) {
            Map resultMap;
            Long cmdId;
            Map resultMap2;
            Integer result = -1;
            EleDeviceItem eleDeviceItem = this.eleDeviceService.getItemById(id);
            Long updateIpAddrCmdId = this.eleDeviceService.changeDevIp(id, ipAddress, subnetMask, gateway);
            if (updateIpAddrCmdId != null && updateIpAddrCmdId > 0L && Objects.nonNull(resultMap2 = this.eleDeviceService.getCmdResultById(updateIpAddrCmdId, 20))) {
                result = Integer.valueOf((String)resultMap2.get("result"));
            }
            if (result < 0) {
                String failedInfo = this.eleBaseDictionaryService.getCommReason(result.intValue());
                failedInfo = StringUtils.isNotBlank((CharSequence)failedInfo) ? I18nUtil.i18nCode((String)failedInfo, (Object[])new Object[0]) : result.toString();
                String msgStr = I18nUtil.i18nCode((String)"common_op_failed", (Object[])new Object[0]) + I18nUtil.i18nCode((String)"common_dev_errorCode", (Object[])new Object[0]) + ":" + failedInfo;
                throw new ZKBusinessException("400", msgStr);
            }
            eleDeviceItem.setIpAddress(ipAddress);
            eleDeviceItem.setSubnetMask(subnetMask);
            eleDeviceItem.setGateway(gateway);
            this.eleDeviceService.updateItemByParam(eleDeviceItem);
            this.eleDeviceService.updateAdmsDevIpAddr(eleDeviceItem.getSn(), ipAddress, subnetMask, gateway);
            this.eleDeviceService.updateCacheDevInfoBySn(eleDeviceItem.getSn());
            this.eleDeviceService.updateAdmsDevOption(eleDeviceItem);
            String msgStr = I18nUtil.i18nCode((String)"common_op_failed", (Object[])new Object[0]);
            Integer ret = null;
            if (this.eleDeviceOptionService.isSupportFunList(eleDeviceItem.getSn(), 28) && (cmdId = this.eleDeviceService.updateIpAddrEx(id, ipAddressSec, netMaskSec, gateIPAddressSec)) != null && cmdId > 0L && Objects.nonNull(resultMap = this.eleDeviceService.getCmdResultById(cmdId, 20))) {
                ret = Integer.valueOf((String)resultMap.get("result"));
                if (ret >= 0) {
                    this.eleDeviceOptionService.setDevOptValByName(id, "IPAddress1", ipAddressSec);
                    this.eleDeviceOptionService.setDevOptValByName(id, "GATEIPAddress1", gateIPAddressSec);
                    this.eleDeviceOptionService.setDevOptValByName(id, "NetMask1", netMaskSec);
                } else {
                    String failedInfo = StringUtils.isNotBlank((CharSequence)this.eleBaseDictionaryService.getCommReason(ret.intValue())) ? I18nUtil.i18nCode((String)this.eleBaseDictionaryService.getCommReason(ret.intValue()), (Object[])new Object[0]) : ret.toString();
                    msgStr = I18nUtil.i18nCode((String)"common_op_failed", (Object[])new Object[0]) + I18nUtil.i18nCode((String)"common_dev_errorCode", (Object[])new Object[0]) + ":" + failedInfo;
                    throw new ZKBusinessException("400", msgStr);
                }
            }
        }
        this.eleDeviceService.rebootDevice((List)Lists.newArrayList((Object[])new String[]{id}), false);
        resultMsg.setMsg("ele_dev_rebootAfterOperate");
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }

    public ZKResultMsg changeDevPwd(String id, String newCommPwd) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            EleDeviceItem eleDeviceItem = this.eleDeviceService.getItemById(id);
            Long cmdId = this.eleDeviceService.changeDevPwd(id, newCommPwd);
            if (cmdId != null && cmdId > 0L) {
                Map resultMap = this.eleDeviceService.getCmdResultById(cmdId, 20);
                Integer ret = Integer.valueOf((String)resultMap.get("result"));
                if (ret >= 0) {
                    eleDeviceItem.setCommPwd(newCommPwd);
                    this.eleDeviceService.updateItemByParam(eleDeviceItem);
                    this.eleDeviceService.updateCommPwdToAdms(eleDeviceItem.getSn(), newCommPwd);
                } else {
                    String failedInfo = this.eleBaseDictionaryService.getCommReason(ret.intValue());
                    failedInfo = StringUtils.isNotBlank((CharSequence)failedInfo) ? I18nUtil.i18nCode((String)failedInfo, (Object[])new Object[0]) : ret.toString();
                    String msgStr = I18nUtil.i18nCode((String)"common_op_failed", (Object[])new Object[0]) + I18nUtil.i18nCode((String)"common_dev_errorCode", (Object[])new Object[0]) + ":" + failedInfo;
                    throw new ZKBusinessException("400", msgStr);
                }
            }
        }
        return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.successMsg());
    }

    public ZKResultMsg checkPwd(String deviceId, String oldCommPwd) {
        ZKResultMsg resultMsg = new ZKResultMsg();
        if (StringUtils.isNotBlank((CharSequence)deviceId) && StringUtils.isNotBlank((CharSequence)oldCommPwd)) {
            boolean isExist = this.eleDeviceService.checkPwd(deviceId, oldCommPwd);
            resultMsg.setData((Object)isExist);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }

    public ZKResultMsg updateRs485Addr(String devId, String comAddr) {
        Long cmdId;
        ZKResultMsg resultMsg = new ZKResultMsg();
        if (StringUtils.isNotBlank((CharSequence)devId) && StringUtils.isNotBlank((CharSequence)comAddr) && (cmdId = this.eleDeviceService.updateRs485Addr(devId, comAddr)) != null && cmdId > 0L) {
            this.eleDeviceOptionService.setDevOptValByName(devId, "ComAddress", comAddr);
        }
        resultMsg.setMsg("common_op_succeed");
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }

    public ZKResultMsg changeDevMThreshold(String devId, String mThreshold) {
        Long cmdId;
        ZKResultMsg resultMsg = new ZKResultMsg();
        if (StringUtils.isNotBlank((CharSequence)devId) && StringUtils.isNotBlank((CharSequence)mThreshold) && (cmdId = this.eleDeviceService.changeDevMThreshold(devId, mThreshold)) != null && cmdId > 0L) {
            Map resultMap = this.eleDeviceService.getCmdResultById(cmdId, 20);
            if (Objects.nonNull(resultMap)) {
                Integer ret = Integer.valueOf((String)resultMap.get("result"));
                if (ret < 0) {
                    String failedInfo = this.eleBaseDictionaryService.getCommReason(ret.intValue());
                    failedInfo = StringUtils.isNotBlank((CharSequence)failedInfo) ? I18nUtil.i18nCode((String)failedInfo, (Object[])new Object[0]) : ret.toString();
                    String msgStr = I18nUtil.i18nCode((String)"common_op_failed", (Object[])new Object[0]) + I18nUtil.i18nCode((String)"common_dev_errorCode", (Object[])new Object[0]) + ":" + failedInfo;
                    throw new ZKBusinessException("400", msgStr);
                }
                this.eleDeviceOptionService.setDevOptValByName(devId, "MThreshold", mThreshold);
                this.eleDeviceService.rebootDevice((List)Lists.newArrayList((Object[])new String[]{devId}), false);
                resultMsg.setMsg("ele_dev_rebootAfterOperate");
            } else {
                throw new ZKBusinessException("400", I18nUtil.i18nCode((String)"common_op_failed", (Object[])new Object[0]));
            }
        }
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }

    public ModelAndView getDevSyncTimeInfo(String ids, String type) {
        return this.getDevStatusByIds(ids, type);
    }

    @RequiresPermissions(value={"ele:device:uploadUserInfo"})
    public ModelAndView getUploadUserInfo(String ids) {
        if (StringUtils.isNotBlank((CharSequence)ids)) {
            EleDeviceItem dev = this.eleDeviceService.getItemById(ids);
            HashMap<String, String> devNameMap = new HashMap<String, String>();
            StringBuffer disabledDevName = new StringBuffer("");
            StringBuffer offlineDevName = new StringBuffer("");
            StringBuffer supportDevFun = new StringBuffer("");
            StringBuffer retIds = new StringBuffer();
            if (String.valueOf(1).equals(this.eleDeviceService.getStatus(dev.getSn()))) {
                this.request.setAttribute("devicesName", (Object)(dev.getDeviceName() + ":" + dev.getAlias()));
                retIds.append(dev.getId());
                devNameMap.put(dev.getDeviceName(), dev.getDeviceName());
                EleDeviceOptionItem bioDataSupport = this.eleDeviceOptionService.getDevOptValueBySnAndName(dev.getSn(), "MultiBioDataSupport");
                if (bioDataSupport != null) {
                    supportDevFun.append(bioDataSupport.getValue());
                } else {
                    String authority = "0:1:0:0:0:0:0:0:0:0";
                    supportDevFun.append(authority);
                }
            } else if (String.valueOf(2).equals(this.eleDeviceService.getStatus(dev.getSn())) && !dev.getDeviceMode().equals(EleConstants.DEV_MODE_OFFLINE)) {
                disabledDevName.append(dev.getAlias());
            } else {
                offlineDevName.append(dev.getAlias());
            }
            this.request.setAttribute("retIds", (Object)(retIds.toString().equals("") ? "" : retIds));
            this.request.setAttribute("disabledDevName", (Object)(disabledDevName.toString().equals("") ? "" : disabledDevName));
            this.request.setAttribute("offlineDevName", (Object)(offlineDevName.toString().equals("") ? "" : offlineDevName));
            this.request.setAttribute("supportDevFun", (Object)(supportDevFun.toString().equals("") ? "" : supportDevFun));
        }
        return new ModelAndView("ele/device/opEleUploadUserInfo");
    }

    @RequiresPermissions(value={"ele:device:uploadEleLogs"})
    public ModelAndView getUploadEleLogs(String ids, String type) {
        return this.getDevStatusByIds(ids, type);
    }

    @RequiresPermissions(value={"ele:device:syncTime"})
    @LogRequest(module="ele_module", object="common_leftMenu_device", opType="common_dev_syncTime", requestParams={"alias"}, opContent="common_dev_name")
    public ZKResultMsg syncTime(String ids) {
        List eleDeviceItemList;
        if (StringUtils.isNotBlank((CharSequence)ids) && (eleDeviceItemList = this.eleDeviceService.getItemListByIds(ids)) != null && !eleDeviceItemList.isEmpty()) {
            this.progressCache.beginProcess(I18nUtil.i18nCode((String)"common_op_processing", (Object[])new Object[0]) + "...<br/>");
            StringBuffer cmdIdBuf = new StringBuffer();
            HashMap devDataMap = Maps.newHashMap();
            EleDeviceItem dev = null;
            int len = eleDeviceItemList.size();
            for (int i = 0; i < len; ++i) {
                dev = (EleDeviceItem)eleDeviceItemList.get(i);
                int total = (int)((double)(i + 1) * 0.5 / (double)eleDeviceItemList.size() * 100.0);
                long cmdId = this.eleDeviceService.syncTime(dev.getSn());
                cmdIdBuf.append(cmdId).append(",");
                devDataMap.put(cmdId, dev.getAlias());
                this.progressCache.setProcess(new ProcessBean(100, total, dev.getAlias() + " : " + I18nUtil.i18nCode((String)"common_dev_cmdSendSucceed", (Object[])new Object[0]) + "...<br/>"));
            }
            this.progressCache.setProcess(new ProcessBean(10, 50, I18nUtil.i18nCode((String)"common_dev_syncTime", (Object[])new Object[0]) + "...<br/>"));
            int j = 1;
            String[] cmdIdArray = cmdIdBuf.toString().split(",");
            int cmdIdArrayLen = cmdIdArray.length;
            for (int index = 0; index < cmdIdArrayLen; ++index) {
                if ("".equals(cmdIdArray[index]) || Long.parseLong(cmdIdArray[index]) <= 0L) continue;
                long cmdId = Long.parseLong(cmdIdArray[index]);
                int total = (int)(((double)j * 0.5 + 1.0) / (double)eleDeviceItemList.size() * 100.0);
                Map resultMap = this.eleDeviceService.getCmdResultById(Long.valueOf(cmdId), 20);
                String alias = (String)devDataMap.get(cmdId);
                if (Objects.nonNull(resultMap)) {
                    Integer ret = Integer.valueOf((String)resultMap.get("result"));
                    if (ret >= 0) {
                        this.progressCache.setProcess(new ProcessBean(100, total, alias + ":" + I18nUtil.i18nCode((String)"common_dev_syncTimeSuccess", (Object[])new Object[0]) + "...<br/>"));
                    } else {
                        String failedInfo = StringUtils.isNotBlank((CharSequence)this.eleBaseDictionaryService.getCommReason(ret.intValue())) ? I18nUtil.i18nCode((String)this.eleBaseDictionaryService.getCommReason(ret.intValue()), (Object[])new Object[0]) : ret.toString();
                        this.progressCache.setProcess(new ProcessBean(100, total, alias + ":" + I18nUtil.i18nCode((String)"common_dev_syncTimeFail", (Object[])new Object[0]) + "," + I18nUtil.i18nCode((String)"common_dev_errorCode", (Object[])new Object[0]) + ":" + failedInfo + "...<br/>"));
                    }
                } else {
                    this.progressCache.setProcess(new ProcessBean(100, total, alias + ":" + I18nUtil.i18nCode((String)"common_dev_syncTimeFail", (Object[])new Object[0]) + "...<br/>"));
                }
                ++j;
            }
            this.progressCache.finishProcess(I18nUtil.i18nCode((String)"common_progress_finish", (Object[])new Object[0]));
        }
        return null;
    }

    public ZKResultMsg checkDevInfo() {
        String commTypeVal = this.request.getParameter("commTypeVal");
        String maxMCUCardBits = this.request.getParameter("maxMCUCardBits");
        String pinLen = this.eleParamsService.getValByName("pers.pinLen");
        String cardLen = this.eleParamsService.getValByName("pers.cardLen");
        String pinSupportLetter = this.eleParamsService.getValByName("pers.pinSupportLetter");
        String multiCard = this.eleParamsService.getValByName("pers.cardsSupport");
        if (Integer.parseInt(maxMCUCardBits) < Integer.parseInt(cardLen)) {
            throw new ZKBusinessException("400", I18nUtil.i18nCode((String)"common_dev_beyondCardLen", (Object[])new Object[]{maxMCUCardBits}));
        }
        if (("1".equals(commTypeVal) || "2".equals(commTypeVal)) && (Integer.parseInt(pinLen) > 9 || "true".equals(pinSupportLetter))) {
            throw new ZKBusinessException("400", I18nUtil.i18nCode((String)"common_dev_deviceNotSupportPin", (Object[])new Object[0]));
        }
        if (multiCard.equals("true")) {
            throw new ZKBusinessException(I18nUtil.i18nCode((String)"common_dev_noSupportMultiCardTip", (Object[])new Object[0]));
        }
        return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.successMsg());
    }

    public ZKResultMsg getDevInfo(EleDeviceParamItem item) {
        return I18nUtil.i18nMsg((ZKResultMsg)this.eleDeviceService.getDevInfo(item));
    }

    public boolean isExistIpAddress(String ipAddress) {
        return this.eleDeviceService.isExistIpAddress(ipAddress);
    }

    public void export(HttpServletRequest request, HttpServletResponse response) {
        EleDeviceExportItem eleDeviceItem = new EleDeviceExportItem();
        this.setConditionValue((BaseItem)eleDeviceItem);
        String userId = this.eleDeviceService.getUserIdBySessionId(request.getSession().getId());
        if (StringUtils.isNotBlank((CharSequence)userId)) {
            eleDeviceItem.setUserId(userId);
        }
        Set offlineSns = new HashSet();
        Set onLineSns = new HashSet();
        String connectState = eleDeviceItem.getConnectState();
        if (StringUtils.isNotBlank((CharSequence)connectState) && connectState.equals("2")) {
            eleDeviceItem.setEnabled(Boolean.valueOf(false));
        } else {
            Map snsMap = this.eleDeviceService.getDevSnsByRedis();
            offlineSns = (Set)snsMap.get((short)0);
            onLineSns = (Set)snsMap.get((short)1);
            if (StringUtils.isNotBlank((CharSequence)connectState)) {
                eleDeviceItem.setEnabled(Boolean.valueOf(true));
                if (connectState.equals("1")) {
                    eleDeviceItem.setSnsNotIn(StrUtil.collectionToStr(offlineSns));
                } else {
                    eleDeviceItem.setSnIn(StrUtil.collectionToStr(offlineSns));
                }
            }
        }
        List eleDeviceItemList = this.eleDeviceService.getExportItemList(eleDeviceItem, this.getBeginIndex(), this.getEndIndex());
        HashMap commTypeValue = Maps.newHashMap();
        HashMap netConnectModeValue = Maps.newHashMap();
        HashMap connectStateValue = Maps.newHashMap();
        commTypeValue.put("1", "TCP/IP");
        commTypeValue.put("2", "RS485");
        commTypeValue.put("3", "HTTP");
        netConnectModeValue.put("0", I18nUtil.i18nCode((String)"ele_dev_netModeWired", (Object[])new Object[0]));
        netConnectModeValue.put("1", I18nUtil.i18nCode((String)"ele_dev_netMode4G", (Object[])new Object[0]));
        netConnectModeValue.put("2", I18nUtil.i18nCode((String)"ele_dev_netModeWifi", (Object[])new Object[0]));
        connectStateValue.put("0", I18nUtil.i18nCode((String)"common_offline", (Object[])new Object[0]));
        connectStateValue.put("1", I18nUtil.i18nCode((String)"common_online", (Object[])new Object[0]));
        connectStateValue.put("2", I18nUtil.i18nCode((String)"common_disable", (Object[])new Object[0]));
        Map authAreaMap = this.eleDeviceService.getAuthAreaByDev(eleDeviceItemList);
        HashSet offlineSnSet = new HashSet();
        HashSet onLineSnSet = new HashSet();
        offlineSnSet.addAll(offlineSns);
        onLineSnSet.addAll(onLineSns);
        eleDeviceItemList.stream().forEach(item -> {
            if (item.getAuthAreaId() != null) {
                item.setAuthAreaName((String)authAreaMap.get(item.getAuthAreaId()));
            }
            item.setCommType((String)commTypeValue.get(item.getCommType()));
            if (item.getEnabled().booleanValue()) {
                if (offlineSnSet.size() > 0 && offlineSnSet.contains(item.getSn())) {
                    item.setConnectState((String)connectStateValue.get("0"));
                } else if (onLineSnSet.size() > 0 && onLineSnSet.contains(item.getSn())) {
                    item.setConnectState((String)connectStateValue.get("1"));
                }
            } else {
                item.setConnectState((String)connectStateValue.get("2"));
            }
            if (item.getComPort() != null && item.getComAddress() != null) {
                String rs485Param = String.format("COM%s(%s) %s", item.getComPort(), item.getComAddress(), item.getBaudrate());
                item.setRs485Param(rs485Param);
            }
        });
        this.excelExport(eleDeviceItemList, EleDeviceExportItem.class);
    }

    public TreeItem getDevicetree() {
        ArrayList<TreeItem> items = new ArrayList<TreeItem>();
        List eleDeviceItemList = this.eleDeviceService.getByCondition(new EleDeviceItem());
        if (!eleDeviceItemList.isEmpty()) {
            TreeItem item = null;
            for (EleDeviceItem eleDeviceItem : eleDeviceItemList) {
                item = new TreeItem();
                item.setId(eleDeviceItem.getId());
                item.setText(eleDeviceItem.getAlias());
                item.setParent(new TreeItem("0"));
                items.add(item);
            }
        }
        List treeItems = TreeBuilder.newTreeBuilder(TreeItem.class, String.class).buildToTreeList(items);
        return new TreeItem("0", treeItems);
    }

    public TreeItem getCancelEmergencySupportDeviceTree() {
        return this.eleDeviceService.getCancelEmergencySupportDeviceTree(this.request.getSession().getId());
    }

    @RequiresPermissions(value={"ele:device:upgradeFirmware"})
    public ModelAndView getUpgradeFirmware(String ids, String type) {
        return this.getDevStatusByIds(ids, type);
    }

    public ModelAndView getChannelByEntityId() {
        String entityId = this.request.getParameter("entityId");
        this.request.setAttribute("entityId", (Object)entityId);
        this.request.setAttribute("entityName", (Object)"EleDevice");
        String channel2EntityIds = this.eleChannelService.getBindChannelIds(Arrays.asList(entityId), "EleDevice");
        this.request.setAttribute("value", (Object)channel2EntityIds);
        return new ModelAndView("ele/device/eleDeviceSelectChannelContent");
    }

    @RequiresPermissions(value={"ele:device:bindChannel"})
    @LogRequest(module="ele_module", object="common_dev_entity", opType="common_vid_bindOrUnbindChannel", requestParams={}, opContent="common_vid_bindOrUnbindChannel")
    public ZKResultMsg bindOrUnbindChannel() {
        String entityId = this.request.getParameter("entityId");
        String entityName = this.request.getParameter("entityName");
        String channelIds = this.request.getParameter("channelIds");
        ZKResultMsg ret = this.eleChannelService.bindOrUnbindChannel(channelIds, entityName, entityId);
        return I18nUtil.i18nMsg((ZKResultMsg)ret);
    }

    public ZKResultMsg grantAuthority(EleSearchAddDeviceItem item) {
        if (StringUtils.isNotBlank((CharSequence)item.getClearAllData())) {
            item.setClearAllData("true");
        }
        this.eleDeviceService.grantAuthority(item);
        return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.successMsg());
    }

    public ZKResultMsg validPushDevCount(String sn) {
        ZKResultMsg resultMsg = this.eleDeviceService.validPushDevCount(sn);
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }

    public boolean isExistAlias(String alias) {
        return this.eleDeviceService.isExistAlias(alias);
    }

    @RequiresPermissions(value={"ele:device:searchDev"})
    public ModelAndView getSearchDevInfo() {
        this.request.setAttribute("eleParams", (Object)this.eleParamsService.getEleParams());
        this.request.setAttribute("persParams", (Object)this.eleParamsService.getPersParams());
        this.request.setAttribute("hostPort", (Object)this.hostPort);
        return new ModelAndView("ele/device/opEleSearchDev");
    }

    @RequiresPermissions(value={"ele:device:queryDevUsage"})
    @LogRequest(module="ele_module", object="common_leftMenu_device", opType="ele_dev_queryDevCapacity", requestParams={"alias"}, opContent="common_dev_name")
    public ModelAndView queryDevUsage(String ids) {
        List retList = this.eleDeviceService.queryDevInfo(ids);
        this.request.setAttribute("retList", (Object)retList);
        StringBuffer devIds = new StringBuffer();
        for (List list : retList) {
            if (list.get(8) == null || list.get(8) != "") continue;
            devIds.append((String)list.get(7) + ",");
        }
        if (devIds.length() > 0) {
            this.request.setAttribute("devIds", (Object)devIds.substring(0, devIds.length() - 1));
        } else {
            this.request.setAttribute("getAll", (Object)"disabled='disabled'");
        }
        return new ModelAndView("ele/device/opEleQueryDevUsage");
    }

    @RequiresPermissions(value={"ele:device:queryDevUsage"})
    public ZKResultMsg getDevUsage(String devId) {
        ZKResultMsg resultMsg = new ZKResultMsg();
        JSONObject retObject = new JSONObject();
        JSONObject userJson = new JSONObject();
        JSONObject fingerJson = new JSONObject();
        JSONObject palmJson = new JSONObject();
        JSONObject faceBiodataJson = new JSONObject();
        fingerJson.put(devId, (Object)"false");
        faceBiodataJson.put(devId, (Object)"false");
        palmJson.put(devId, (Object)"false");
        retObject.put("id", (Object)devId);
        EleDeviceItem dev = this.eleDeviceService.getItemById(devId);
        Map cmdMap = this.eleDeviceService.getDevUserAndTempCounts(devId);
        String fingerVersion = this.eleDeviceOptionService.getValueByDevSnAndName(dev.getSn(), "~ZKFPVersion");
        EleDeviceOptionItem maxMultiBioDataCount = this.eleDeviceOptionService.getDevOptValueBySnAndName(dev.getSn(), "MaxMultiBioDataCount");
        String pvVersion = "";
        String vislightFaceVersion = "";
        Map devOptionMap = this.eleDeviceOptionService.getDevOptionBySn(dev.getSn());
        if (devOptionMap.containsKey("MultiBioVersion")) {
            String multiBioVersion = (String)devOptionMap.get("MultiBioVersion");
            String[] multiBioVersionAry = multiBioVersion.split(":");
            if (multiBioVersionAry != null) {
                fingerVersion = multiBioVersionAry[BaseConstants.BaseBioType.FP_BIO_TYPE].equals("0") ? "" : multiBioVersionAry[BaseConstants.BaseBioType.FP_BIO_TYPE];
                pvVersion = multiBioVersionAry[BaseConstants.BaseBioType.PALM_BIO_TYPE].equals("0") ? "" : multiBioVersionAry[BaseConstants.BaseBioType.PALM_BIO_TYPE];
                vislightFaceVersion = multiBioVersionAry[BaseConstants.BaseBioType.BIOPHOTO_BIO_TYPE].equals("0") ? "" : multiBioVersionAry[BaseConstants.BaseBioType.BIOPHOTO_BIO_TYPE];
            }
        } else if (devOptionMap.containsKey("PvVersion")) {
            pvVersion = (String)devOptionMap.get("PvVersion");
        }
        fingerVersion = StringUtils.isNotBlank((CharSequence)fingerVersion) && fingerVersion.contains(".") ? fingerVersion : fingerVersion + ".0";
        pvVersion = StringUtils.isNotBlank((CharSequence)pvVersion) && pvVersion.contains(".") ? pvVersion : pvVersion + ".0";
        vislightFaceVersion = StringUtils.isNotBlank((CharSequence)vislightFaceVersion) && vislightFaceVersion.contains(".") ? vislightFaceVersion : vislightFaceVersion + ".0";
        for (String key : cmdMap.keySet()) {
            int ret;
            Map resultMap;
            String[] cmdIdKey = key.split("_");
            Long cmdId = (Long)cmdMap.get(key);
            if (cmdId <= 0L || !Objects.nonNull(resultMap = this.eleDeviceService.getCmdResultById(cmdId, 20)) || (ret = Integer.parseInt((String)resultMap.get("result"))) < 0) continue;
            if ("".equals(this.eleDeviceService.getQueryData("IS_ERROR_USER"))) {
                JSONObject dataCountJson = null;
                if (!"".equals(this.eleDeviceService.getQueryData("ele:dataCount:" + cmdId))) {
                    dataCountJson = JSONObject.parseObject((String)this.eleDeviceService.getQueryData("ele:dataCount:" + cmdId));
                    if (dataCountJson.containsKey((Object)"user")) {
                        String maxUserCountOpt = this.eleDeviceOptionService.getValueByDevSnAndName(dev.getSn(), "~MaxUserCount");
                        int maxUserCount = Integer.parseInt(!"0".equals(maxUserCountOpt) ? maxUserCountOpt : (dev.getCommType() == 3 ? "90" : "300")) * 100;
                        userJson.put(devId, (Object)(dataCountJson.get((Object)"user").toString() + "/" + maxUserCount));
                    } else if (dataCountJson.containsKey((Object)"templatev10") || dataCountJson.containsKey((Object)"biodata") && cmdIdKey.length > 1 && BaseConstants.BaseBioType.FP_BIO_TYPE == Short.parseShort(cmdIdKey[1])) {
                        int maxFingerCount = 0;
                        if (maxMultiBioDataCount != null) {
                            maxFingerCount = Integer.parseInt(maxMultiBioDataCount.getValue().split(":")[BaseConstants.BaseBioType.FP_BIO_TYPE]);
                            fingerJson.put(devId, (Object)(dataCountJson.get((Object)"biodata").toString() + "/" + maxFingerCount));
                        } else {
                            String maxFingerCountOpt = this.eleDeviceOptionService.getValueByDevSnAndName(dev.getSn(), "~MaxFingerCount");
                            if (maxFingerCountOpt != null) {
                                maxFingerCount = Integer.parseInt(maxFingerCountOpt) * 100;
                            }
                            if ("12".equals(fingerVersion)) {
                                fingerJson.put(devId, (Object)(dataCountJson.get((Object)"biodata").toString() + "/" + maxFingerCount));
                            } else {
                                fingerJson.put(devId, (Object)(dataCountJson.get((Object)"templatev10").toString() + "/" + maxFingerCount));
                            }
                        }
                        fingerJson.put("fingerVersion", (Object)("V" + fingerVersion));
                    } else if (dataCountJson.containsKey((Object)"biodata") && cmdIdKey.length > 1 && BaseConstants.BaseBioType.PALM_BIO_TYPE == Short.parseShort(cmdIdKey[1])) {
                        int maxPalmCount = 0;
                        if (maxMultiBioDataCount != null) {
                            maxPalmCount = Integer.parseInt(maxMultiBioDataCount.getValue().split(":")[BaseConstants.BaseBioType.PALM_BIO_TYPE]);
                        } else {
                            String maxPalmCountOpt = this.eleDeviceOptionService.getValueByDevSnAndName(dev.getSn(), "~MaxPvCount");
                            if (maxPalmCountOpt != null) {
                                maxPalmCount = Integer.parseInt(maxPalmCountOpt);
                            }
                        }
                        palmJson.put(devId + "", (Object)(dataCountJson.get((Object)"biodata").toString() + "/" + maxPalmCount));
                        palmJson.put("pvVersion", (Object)("V" + pvVersion));
                    } else if (dataCountJson.containsKey((Object)"biodata") && cmdIdKey.length > 1 && BaseConstants.BaseBioType.BIOPHOTO_BIO_TYPE == Short.parseShort(cmdIdKey[1])) {
                        int maxVislightFaceTempCount = 0;
                        if (maxMultiBioDataCount != null) {
                            maxVislightFaceTempCount = Integer.parseInt(maxMultiBioDataCount.getValue().split(":")[BaseConstants.BaseBioType.BIOPHOTO_BIO_TYPE]);
                        } else {
                            String maxBiophotoCountOpt = this.eleDeviceOptionService.getValueByDevSnAndName(dev.getSn(), "~MaxFaceCount");
                            if (maxBiophotoCountOpt != null) {
                                maxVislightFaceTempCount = Integer.parseInt(maxBiophotoCountOpt);
                            }
                        }
                        faceBiodataJson.put(devId, (Object)(dataCountJson.get((Object)"biodata").toString() + "/" + maxVislightFaceTempCount));
                        faceBiodataJson.put("vislightFaceVersion", (Object)("V" + vislightFaceVersion));
                    }
                    this.eleDeviceService.delQueryData("ele:dataCount:" + cmdId);
                }
                this.eleDeviceService.delQueryData("SUM_RECORD_USER");
            }
            this.eleDeviceService.delQueryData("IS_ERROR_USER");
        }
        retObject.put("user", (Object)userJson);
        retObject.put("finger", (Object)fingerJson);
        retObject.put("palm", (Object)palmJson);
        retObject.put("faceBiodata", (Object)faceBiodataJson);
        resultMsg.setData((Object)retObject);
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }

    public ModelAndView getDevExtendInfo(String ids) {
        EleDeviceItem eleDeviceItem = this.eleDeviceService.getItemById(ids);
        short devConnectState = Short.parseShort(this.eleDeviceService.getStatus(eleDeviceItem.getSn()));
        if (devConnectState != 1) {
            if (eleDeviceItem.getDeviceMode().equals(EleConstants.DEV_MODE_OFFLINE)) {
                this.request.setAttribute("failedReason", (Object)0);
            } else {
                this.request.setAttribute("failedReason", (Object)devConnectState);
            }
            return new ModelAndView("ele/device/opDevNotSupportFeatureTips");
        }
        List<String> voiceModuleOptions = Arrays.asList("VoiceModuleType,VoiceModuleCancelTime,VoiceModuleCancelCount".split(","));
        List items = this.eleDeviceOptionService.getDevExtendParams(ids, voiceModuleOptions);
        Map<String, EleDeviceOptionItem> deviceOptionItemMap = items.stream().collect(Collectors.toMap(EleDeviceOptionItem::getName, eleDeviceOptionItem -> eleDeviceOptionItem));
        if (this.eleDeviceOptionService.isSupportFunList(eleDeviceItem.getSn(), 57)) {
            HashMap<String, String> voiceModuleParamMap = new HashMap<String, String>();
            for (String voiceModuleOption : voiceModuleOptions) {
                if (!deviceOptionItemMap.containsKey(voiceModuleOption)) continue;
                voiceModuleParamMap.put(voiceModuleOption, deviceOptionItemMap.get(voiceModuleOption).getValue());
            }
            if (voiceModuleParamMap.size() <= 0) {
                this.request.setAttribute("failedReason", (Object)EleConstants.DEV_NOT_SUPPORT_FEATURE);
                return new ModelAndView("ele/device/opDevNotSupportFeatureTips");
            }
            this.request.setAttribute("voiceModuleParamMap", voiceModuleParamMap);
            this.request.setAttribute("item", (Object)eleDeviceItem);
            return new ModelAndView("ele/device/opEleSetExtendParam");
        }
        this.request.setAttribute("failedReason", (Object)EleConstants.DEV_NOT_SUPPORT_FEATURE);
        return new ModelAndView("ele/device/opDevNotSupportFeatureTips");
    }

    @RequiresPermissions(value={"ele:device:updateDevExtendParam"})
    @LogRequest(module="ele_module", object="common_leftMenu_device", opType="ele_dev_setExtendParam", requestParams={"alias"}, opContent="common_dev_name")
    public ZKResultMsg updateDevExtendParam(Map<String, String> params) {
        ZKResultMsg resultMsg = this.eleDeviceService.updateDevExtendParam(params);
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }

    @RequiresPermissions(value={"ele:device:clearCmdCache"})
    @LogRequest(module="ele_module", object="common_leftMenu_device", opType="common_devMonitor_clearCmdCache", requestParams={"alias"}, opContent="common_dev_name")
    public ZKResultMsg clearCmdCache(String sn) {
        ZKResultMsg resultMsg = new ZKResultMsg();
        this.eleDeviceService.clearCmdCache(sn);
        resultMsg.setMsg("common_devMonitor_clearCmdSuccess");
        return resultMsg;
    }

    public ZKResultMsg getDeviceStatus(String devSns) {
        ZKResultMsg zkResultMsg = ZKResultMsg.failMsg();
        if (StringUtils.isNotBlank((CharSequence)devSns)) {
            JSONArray stateArray = new JSONArray();
            ArrayList snList = Lists.newArrayList((Object[])devSns.split(","));
            snList.forEach(sn -> {
                JSONObject devStatus = new JSONObject();
                String status = this.eleDeviceService.getStatus(sn);
                Long cmdCount = this.eleDeviceService.getCmdCount(sn);
                devStatus.put("connectState", (Object)status);
                devStatus.put("cmdCount", (Object)cmdCount);
                devStatus.put("sn", sn);
                stateArray.add((Object)devStatus);
            });
            zkResultMsg = ZKResultMsg.successMsg();
            zkResultMsg.setData((Object)stateArray);
        }
        return zkResultMsg;
    }
}

