/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ele.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.ele.remote.EleCardRemote;
import com.zkteco.zkbiosecurity.ele.service.EleCardService;
import com.zkteco.zkbiosecurity.ele.vo.EleCardItem;
import com.zkteco.zkbiosecurity.ele.vo.EleLossCardItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class EleCardController
extends ExportController
implements EleCardRemote {
    @Autowired
    private EleCardService eleCardService;

    @RequiresPermissions(value={"ele:card"})
    public ModelAndView index() {
        return new ModelAndView("ele/card/eleCard");
    }

    public DxGrid list(EleCardItem condition) {
        Pager pager = this.eleCardService.loadPagerByAuthUserFilter(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public ZKResultMsg lossCard(EleLossCardItem item) {
        return this.eleCardService.lossCard(item);
    }

    public ZKResultMsg revertCard(EleLossCardItem item) {
        return this.eleCardService.revertCard(item);
    }

    public ZKResultMsg clearCardInfo(String cardNo) {
        ZKResultMsg ret = this.eleCardService.clearCardKind(cardNo);
        return I18nUtil.i18nMsg((ZKResultMsg)ret);
    }

    @RequiresPermissions(value={"ele:card:export"})
    @LogRequest(module="ele_module", object="ele_leftMenu_cardManage", opType="common_op_export", opContent="common_op_export")
    public void export(HttpServletRequest request, HttpServletResponse response) {
        EleCardItem eleCardItem = new EleCardItem();
        this.setConditionValue((BaseItem)eleCardItem);
        List itemList = this.eleCardService.getExportItemData(request.getSession().getId(), eleCardItem, this.getBeginIndex(), this.getEndIndex());
        this.excelExport(itemList, EleCardItem.class);
    }
}

