/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ele.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.ele.constants.EleConstants;
import com.zkteco.zkbiosecurity.ele.remote.EleCardBusinessRemote;
import com.zkteco.zkbiosecurity.ele.service.EleCardBusinessService;
import com.zkteco.zkbiosecurity.ele.service.EleCardService;
import com.zkteco.zkbiosecurity.ele.service.EleDeviceService;
import com.zkteco.zkbiosecurity.ele.service.EleParamsService;
import com.zkteco.zkbiosecurity.ele.service.ElePersonService;
import com.zkteco.zkbiosecurity.ele.vo.EleCardBusinessSelectCardNoItem;
import com.zkteco.zkbiosecurity.ele.vo.EleCardBusinessSelectDeviceItem;
import com.zkteco.zkbiosecurity.ele.vo.EleCardBusinessSelectPersonRadioItem;
import com.zkteco.zkbiosecurity.ele.vo.EleInitCardItem;
import com.zkteco.zkbiosecurity.ele.vo.EleIssueCardItem;
import com.zkteco.zkbiosecurity.ele.vo.EleLossCardItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class EleCardBusinessController
extends BaseController
implements EleCardBusinessRemote {
    @Autowired
    private EleCardBusinessService eleCardBusinessService;
    @Autowired
    private EleDeviceService eleDeviceService;
    @Autowired
    private ElePersonService elePersonService;
    @Autowired
    private EleCardService eleCardService;
    @Autowired
    private EleParamsService eleParamsService;

    public ModelAndView index() {
        return new ModelAndView("ele/cardBusiness/eleCardBusiness");
    }

    public ModelAndView editEleIssueCard(String id) {
        String cardOldKey = this.eleParamsService.getDecryptCardOldKey();
        this.request.setAttribute("cardOldKey", (Object)cardOldKey);
        return new ModelAndView("ele/cardBusiness/opEleIssueCard");
    }

    public ModelAndView editEleInitCard() {
        return new ModelAndView("ele/cardBusiness/opEleInitCard");
    }

    public ModelAndView editEleLossCard() {
        return new ModelAndView("ele/cardBusiness/opEleLossCard");
    }

    public ModelAndView editEleRevertCard() {
        return new ModelAndView("ele/cardBusiness/opEleRevertCard");
    }

    @RequiresPermissions(value={"ele:cardBusiness:issueCard"})
    @LogRequest(module="ele_module", object="ele_leftMenu_cardBusiness", opType="pers_issueCard_entity", requestParams={"cardNo"}, opContent="ele_offline_userCard")
    public ZKResultMsg getIssueUserCardInfo(EleIssueCardItem item) {
        ZKResultMsg ret = this.eleCardBusinessService.getIssueUserCardInfo(item);
        return I18nUtil.i18nMsg((ZKResultMsg)ret);
    }

    @RequiresPermissions(value={"ele:cardBusiness:issueCard"})
    @LogRequest(module="ele_module", object="ele_leftMenu_cardBusiness", opType="pers_issueCard_entity", requestParams={"cardNo"}, opContent="ele_offline_configCard")
    public ZKResultMsg getIssueConfigCardInfo(EleIssueCardItem item) {
        ZKResultMsg ret = this.eleCardBusinessService.getIssueConfigCardInfo(item);
        return I18nUtil.i18nMsg((ZKResultMsg)ret);
    }

    @RequiresPermissions(value={"ele:cardBusiness:issueCard"})
    @LogRequest(module="ele_module", object="ele_leftMenu_cardBusiness", opType="pers_issueCard_entity", requestParams={"cardNo"}, opContent="ele_offline_readerConfigCard")
    public ZKResultMsg getIssueReaderConfigCardInfo(EleIssueCardItem item) {
        return this.eleCardBusinessService.getIssueReaderConfigCardInfo(item);
    }

    @RequiresPermissions(value={"ele:cardBusiness:lossCard"})
    @LogRequest(module="ele_module", object="ele_leftMenu_cardBusiness", opType="pers_lossCard_entity", requestParams={"cardNo"}, opContent="pers_lossCard_entity")
    public ZKResultMsg getIssueLossCardInfo(EleLossCardItem item) {
        return this.eleCardBusinessService.getLossCardInfo(item);
    }

    @RequiresPermissions(value={"ele:cardBusiness:revertCard"})
    @LogRequest(module="ele_module", object="ele_leftMenu_cardBusiness", opType="pers_revertCard_entity", requestParams={"cardNo"}, opContent="pers_revertCard_entity")
    public ZKResultMsg getIssueRevertCardInfo(EleLossCardItem item) {
        return this.eleCardBusinessService.getRevertCardInfo(item);
    }

    @RequiresPermissions(value={"ele:cardBusiness:initCard"})
    @LogRequest(module="ele_module", object="ele_leftMenu_cardBusiness", opType="pers_card_init", requestParams={"cardNo"}, opContent="ele_offline_cpuCard")
    public ZKResultMsg getResetCPUCardInfo(EleInitCardItem item) {
        return this.eleCardBusinessService.getResetCPUCardInfo(item);
    }

    @RequiresPermissions(value={"ele:cardBusiness:initCard"})
    @LogRequest(module="ele_module", object="ele_leftMenu_cardBusiness", opType="pers_card_init", requestParams={"cardNo"}, opContent="ele_offline_icCard")
    public ZKResultMsg getResetICCardInfo(EleInitCardItem item) {
        return this.eleCardBusinessService.getResetICCardInfo(item);
    }

    @RequiresPermissions(value={"ele:cardBusiness:initCard"})
    @LogRequest(module="ele_module", object="ele_leftMenu_cardBusiness", opType="pers_card_init", requestParams={"cardNo"}, opContent="ele_offline_readerConfigCard")
    public ZKResultMsg getResetReaderConfigCardInfo(EleInitCardItem item) {
        return this.eleCardBusinessService.getResetReaderConfigCardInfo(item);
    }

    public ZKResultMsg getChangeCPUKeyInfo(String cardNo) {
        return this.eleCardBusinessService.getChangeCPUKeyInfo(cardNo);
    }

    public ZKResultMsg getChangeICKeyInfo(String cardNo, String cardType) {
        return this.eleCardBusinessService.getChangeICKeyInfo(cardNo, cardType);
    }

    public ZKResultMsg saveEleCardInfo(EleIssueCardItem item) {
        return this.eleCardBusinessService.saveEleCardInfo(item);
    }

    public DxGrid selectDeviceList(EleCardBusinessSelectDeviceItem condition) {
        if (StringUtils.isBlank((CharSequence)condition.getSelectId())) {
            condition.setSelectId("-1");
        }
        if ("noSelected".equals(condition.getType())) {
            condition.setNotInId(condition.getSelectId());
        } else if ("selected".equals(condition.getType())) {
            condition.setInId(condition.getSelectId());
        }
        String userId = this.eleDeviceService.getUserIdBySessionId(this.request.getSession().getId());
        if (StringUtils.isNotBlank((CharSequence)userId)) {
            condition.setUserId(userId);
        }
        condition.setDeviceMode(EleConstants.DEV_MODE_OFFLINE);
        Pager pager = this.eleDeviceService.getSimpleItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public DxGrid selectPersonList(EleCardBusinessSelectPersonRadioItem condition) {
        if (StringUtils.isBlank((CharSequence)condition.getSelectId())) {
            condition.setSelectId("-1");
        }
        if ("noSelected".equals(condition.getType())) {
            condition.setNotInId(condition.getSelectId());
        } else if ("selected".equals(condition.getType())) {
            condition.setInId(condition.getSelectId());
        }
        Pager pager = this.elePersonService.getCardBusinessSelectPersonItems(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public DxGrid selectCardNoList(EleCardBusinessSelectCardNoItem condition) {
        if (StringUtils.isBlank((CharSequence)condition.getSelectId())) {
            condition.setSelectId("-1");
        }
        if ("noSelected".equals(condition.getType())) {
            condition.setNotInId(condition.getSelectId());
        } else if ("selected".equals(condition.getType())) {
            condition.setInId(condition.getSelectId());
        }
        Pager pager = this.eleCardService.getCardBusinessSelectCardNoItems(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }
}

