/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ele.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.ele.remote.EleAuxInRemote;
import com.zkteco.zkbiosecurity.ele.service.EleAuxInService;
import com.zkteco.zkbiosecurity.ele.vo.EleAuxInItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class EleAuxInController
extends BaseController
implements EleAuxInRemote {
    @Autowired
    private EleAuxInService eleAuxInService;

    @RequiresPermissions(value={"ele:auxIn"})
    public ModelAndView index() {
        return new ModelAndView("ele/auxIn/eleAuxIn");
    }

    @RequiresPermissions(value={"ele:auxIn:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.eleAuxInService.getItemById(id));
        }
        return new ModelAndView("ele/auxIn/editEleAuxIn");
    }

    @RequiresPermissions(value={"ele:auxIn:edit"})
    @LogRequest(module="ele_module", object="common_leftMenu_auxIn", opType="common_op_edit", requestParams={"name"}, opContent="common_name")
    public ZKResultMsg save(EleAuxInItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.eleAuxInService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"ele:auxIn:refresh"})
    public DxGrid list(EleAuxInItem condition) {
        Pager pager = this.eleAuxInService.loadPagerByAuthFilter(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"ele:auxIn:del"})
    public ZKResultMsg del(String ids) {
        this.eleAuxInService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public boolean isExist(EleAuxInItem item) {
        return this.eleAuxInService.isExist(item);
    }
}

