/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ele.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.ele.remote.EleAlarmTransactionRemote;
import com.zkteco.zkbiosecurity.ele.service.EleTransactionService;
import com.zkteco.zkbiosecurity.ele.vo.EleAlarmTransactionItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class EleAlarmTransactionController
extends ExportController
implements EleAlarmTransactionRemote {
    @Autowired
    private EleTransactionService eleTransactionService;

    @RequiresPermissions(value={"ele:alarmTransaction"})
    public ModelAndView index() {
        return new ModelAndView("ele/transaction/eleAlarmTransaction");
    }

    @RequiresPermissions(value={"ele:alarmTransaction:refresh"})
    public DxGrid list(EleAlarmTransactionItem condition) {
        Pager pager = this.eleTransactionService.loadAlarmTransactionByAuthUserFilter(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize(), this.getLimitCount());
        return GridUtil.convert((Pager)pager, condition.getClass(), (boolean)this.getPageList());
    }

    @RequiresPermissions(value={"ele:alarmTransaction:clearData"})
    @LogRequest(module="ele_module", object="common_leftMenu_exceptTransaction", opType="common_op_clearData", opContent="common_op_clearData")
    public ZKResultMsg clearData() {
        this.eleTransactionService.deleteAllExceptionData();
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @LogRequest(module="ele_module", object="common_leftMenu_exceptTransaction", opType="common_op_export", opContent="common_op_export")
    public void export(HttpServletRequest request, HttpServletResponse response) {
        EleAlarmTransactionItem eleAlarmTransactionItem = new EleAlarmTransactionItem();
        this.setConditionValue((BaseItem)eleAlarmTransactionItem);
        String sessionId = request.getSession().getId();
        String areaNames = this.eleTransactionService.getAreaNamesByAuthFilter(sessionId);
        String deptCodes = this.eleTransactionService.getDeptCodesByAuthFilter(sessionId);
        eleAlarmTransactionItem.setAreaNameIn(areaNames);
        eleAlarmTransactionItem.setDeptCodeIn(deptCodes);
        List itemList = this.eleTransactionService.getItemData(EleAlarmTransactionItem.class, (BaseItem)eleAlarmTransactionItem, this.getBeginIndex(), this.getEndIndex());
        this.excelExport(itemList, EleAlarmTransactionItem.class);
    }
}

