/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ele.api.controller;

import com.google.common.collect.Lists;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.ApiResultMessage;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.ele.api.vo.EleApiLevelItem;
import com.zkteco.zkbiosecurity.ele.service.EleLevelService;
import com.zkteco.zkbiosecurity.ele.vo.EleLevelItem;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/v2/eleLevel"})
@Api(tags={"EleLevel"}, description="ele level")
public class EleApiV2LevelController {
    private static final Logger log = LoggerFactory.getLogger(EleApiV2LevelController.class);
    @Autowired
    private EleLevelService eleLevelService;

    @ApiOperation(value="Get Ele Level List", notes="Return Ele Level List", response=ApiResultMessage.class)
    @RequestMapping(value={"/list"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public ApiResultMessage getEleLevelList(@RequestParam(value="pageNo") Integer pageNo, @RequestParam(value="pageSize") Integer pageSize) {
        ApiResultMessage rs = ApiResultMessage.successMessage();
        try {
            if (pageNo <= 0 || pageSize <= 0) {
                return ApiResultMessage.message((int)-90, (String)I18nUtil.i18nCode((String)"common_api_pageValid", (Object[])new Object[0]));
            }
            ArrayList eleApiLevelItemList = Lists.newArrayList();
            Pager pager = this.eleLevelService.getItemsByPage((BaseItem)new EleLevelItem(), pageNo - 1, pageSize.intValue());
            List eleLevelItemList = pager.getData();
            if (!eleLevelItemList.isEmpty()) {
                eleLevelItemList.forEach(eleLevelItem -> {
                    EleApiLevelItem eleApiLevelItem = EleApiLevelItem.createApiLevel((EleLevelItem)eleLevelItem);
                    if (eleApiLevelItem != null) {
                        eleApiLevelItemList.add(eleApiLevelItem);
                    }
                });
            }
            pager.setData((List)eleApiLevelItemList);
            rs.setData((Object)pager);
        }
        catch (Exception e) {
            rs = ApiResultMessage.message((int)-1, (String)I18nUtil.i18nCode((String)"common_api_programError", (Object[])new Object[0]));
            log.error("api eleLevel/getEleLevelList error ", (Throwable)e);
        }
        return rs;
    }
}

