/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ele.api.controller;

import com.google.common.collect.Lists;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.ApiResultMessage;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.ele.api.vo.EleApiFloorItem;
import com.zkteco.zkbiosecurity.ele.service.EleDeviceService;
import com.zkteco.zkbiosecurity.ele.service.EleFloorService;
import com.zkteco.zkbiosecurity.ele.vo.EleFloorItem;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/v2/floor"})
@Api(tags={"EleFloor"}, description="ele floor")
public class EleApiV2FloorController {
    private static final Logger log = LoggerFactory.getLogger(EleApiV2FloorController.class);
    @Autowired
    private EleFloorService eleFloorService;
    @Autowired
    private EleDeviceService eleDeviceService;

    @ResponseBody
    @RequestMapping(value={"/list"}, method={RequestMethod.GET}, produces={"application/json"})
    @ApiOperation(value="Get Ele Floors", notes="Return Ele Floor List", response=ApiResultMessage.class)
    public ApiResultMessage floorList(@RequestParam Integer pageNo, @RequestParam Integer pageSize) {
        ApiResultMessage rs = ApiResultMessage.successMessage();
        try {
            if (pageNo <= 0 || pageSize <= 0) {
                return ApiResultMessage.message((int)-90, (String)I18nUtil.i18nCode((String)"common_api_pageValid", (Object[])new Object[0]));
            }
            ArrayList eleApiFloorItemList = Lists.newArrayList();
            Pager pager = this.eleFloorService.getItemsByPage((BaseItem)new EleFloorItem(), pageNo - 1, pageSize.intValue());
            List eleFloorItemList = pager.getData();
            if (!eleFloorItemList.isEmpty()) {
                eleFloorItemList.forEach(eleFloorItem -> {
                    EleApiFloorItem eleApiFloorItem = EleApiFloorItem.createApiFloor((EleFloorItem)eleFloorItem);
                    if (eleApiFloorItem != null) {
                        eleApiFloorItemList.add(eleApiFloorItem);
                    }
                });
            }
            pager.setData((List)eleApiFloorItemList);
            rs.setData((Object)pager);
        }
        catch (Exception e) {
            log.error("api floor/list error", (Throwable)e);
            rs = ApiResultMessage.message((int)-1, (String)I18nUtil.i18nCode((String)"common_api_programError", (Object[])new Object[0]));
        }
        return rs;
    }
}

