/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ele.api.controller;

import com.google.common.collect.Lists;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.ApiResultMessage;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.ele.api.vo.EleApiDeviceItem;
import com.zkteco.zkbiosecurity.ele.service.EleDeviceService;
import com.zkteco.zkbiosecurity.ele.vo.EleDeviceItem;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/v2/eleDevice"})
@Api(tags={"EleDevice"}, description="ele device")
public class EleApiV2DeviceController {
    private static final Logger log = LoggerFactory.getLogger(EleApiV2DeviceController.class);
    @Autowired
    private EleDeviceService eleDeviceService;

    @ResponseBody
    @RequestMapping(value={"/eleList"}, method={RequestMethod.GET}, produces={"application/json"})
    @ApiOperation(value="Get Ele Devices", notes="Return Ele Devices List", response=ApiResultMessage.class)
    public ApiResultMessage eleList(@RequestParam Integer pageNo, @RequestParam Integer pageSize) {
        ApiResultMessage rs = ApiResultMessage.successMessage();
        try {
            if (pageNo <= 0 || pageSize <= 0) {
                return ApiResultMessage.message((int)-90, (String)I18nUtil.i18nCode((String)"common_api_pageValid", (Object[])new Object[0]));
            }
            ArrayList eleApiDeviceItemList = Lists.newArrayList();
            Pager pager = this.eleDeviceService.getItemsByPage((BaseItem)new EleDeviceItem(), pageNo - 1, pageSize.intValue());
            List eleDeviceItemList = pager.getData();
            if (!eleDeviceItemList.isEmpty()) {
                eleDeviceItemList.forEach(eleDeviceItem -> {
                    EleApiDeviceItem eleApiDeviceItem = EleApiDeviceItem.createApiDevice((EleDeviceItem)eleDeviceItem);
                    if (eleApiDeviceItem != null) {
                        eleApiDeviceItemList.add(eleApiDeviceItem);
                    }
                });
            }
            pager.setData((List)eleApiDeviceItemList);
            rs.setData((Object)pager);
        }
        catch (Exception e) {
            log.error("api eleDevice/eleList error", (Throwable)e);
            rs = ApiResultMessage.message((int)-1, (String)I18nUtil.i18nCode((String)"common_api_programError", (Object[])new Object[0]));
        }
        return rs;
    }
}

