/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ele.api.controller;

import com.google.common.collect.Lists;
import com.zkteco.zkbiosecurity.base.vo.ApiResultMessage;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.ele.api.vo.EleApiLevelItem;
import com.zkteco.zkbiosecurity.ele.service.EleLevelService;
import com.zkteco.zkbiosecurity.ele.vo.EleLevelItem;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/eleLevel"})
@Api(tags={"EleLevel"}, description="ele level")
public class EleApiLevelController {
    private static final Logger log = LoggerFactory.getLogger(EleApiLevelController.class);
    @Autowired
    private EleLevelService eleLevelService;

    @ApiOperation(value="Get Ele Level List", notes="Return Ele Level List", response=ApiResultMessage.class)
    @RequestMapping(value={"/list"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public ApiResultMessage getEleLevelList(@RequestParam(value="pageNo") Integer pageNo, @RequestParam(value="pageSize") Integer pageSize) {
        ApiResultMessage rs = ApiResultMessage.successMessage();
        try {
            if (pageNo <= 0 || pageSize <= 0) {
                return ApiResultMessage.message((int)-90, (String)I18nUtil.i18nCode((String)"common_api_pageValid", (Object[])new Object[0]));
            }
            ArrayList eleApiLevelItemList = Lists.newArrayList();
            List eleLevelItemList = this.eleLevelService.getItemsByPage((BaseItem)new EleLevelItem(), pageNo - 1, pageSize.intValue()).getData();
            if (!eleLevelItemList.isEmpty()) {
                eleLevelItemList.forEach(eleLevelItem -> {
                    EleApiLevelItem eleApiLevelItem = EleApiLevelItem.createApiLevel((EleLevelItem)eleLevelItem);
                    if (eleApiLevelItem != null) {
                        eleApiLevelItemList.add(eleApiLevelItem);
                    }
                });
            }
            rs.setData((Object)eleApiLevelItemList);
        }
        catch (Exception e) {
            rs = ApiResultMessage.message((int)-1, (String)I18nUtil.i18nCode((String)"common_api_programError", (Object[])new Object[0]));
            log.error("api eleLevel/getEleLevelList error ", (Throwable)e);
        }
        return rs;
    }

    @ApiOperation(value="Get Ele Level By LevelId", notes="Return Ele Level", response=ApiResultMessage.class)
    @RequestMapping(value={"/getById"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public ApiResultMessage getEleLevelByLevelId(@RequestParam(value="id", required=false) String id) {
        ApiResultMessage rs = ApiResultMessage.successMessage();
        try {
            if (StringUtils.isBlank((CharSequence)id)) {
                return ApiResultMessage.message((int)-204, (String)I18nUtil.i18nCode((String)"ele_api_levelIdNotNull", (Object[])new Object[0]));
            }
            EleLevelItem eleLevelItem = this.eleLevelService.getItemById(id);
            if (eleLevelItem == null) {
                return ApiResultMessage.message((int)-24, (String)I18nUtil.i18nCode((String)"ele_api_levelNotExist", (Object[])new Object[0]));
            }
            rs.setData((Object)EleApiLevelItem.createApiLevel((EleLevelItem)eleLevelItem));
        }
        catch (Exception e) {
            log.error("api eleLevel/getEleLevelByLevelId error ", (Throwable)e);
            rs = ApiResultMessage.message((int)-1, (String)I18nUtil.i18nCode((String)"common_api_programError", (Object[])new Object[0]));
        }
        return rs;
    }

    @ApiOperation(value="Get Ele Level By LevelName", notes="Return Ele Level", response=ApiResultMessage.class)
    @RequestMapping(value={"/getByName"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public ApiResultMessage getEleLevelByLevelName(@RequestParam(value="name", required=false) String name) {
        ApiResultMessage rm = ApiResultMessage.successMessage();
        try {
            if (StringUtils.isBlank((CharSequence)name)) {
                return ApiResultMessage.message((int)-204, (String)I18nUtil.i18nCode((String)"ele_api_levelNameNotNull", (Object[])new Object[0]));
            }
            EleLevelItem eleLevelItem = this.eleLevelService.getItemByName(name);
            if (eleLevelItem == null) {
                return ApiResultMessage.message((int)-24, (String)I18nUtil.i18nCode((String)"ele_api_levelNotExist", (Object[])new Object[0]));
            }
            rm.setData((Object)EleApiLevelItem.createApiLevel((EleLevelItem)eleLevelItem));
        }
        catch (Exception e) {
            log.error("api eleLevel/getEleLevelByLevelName error ", (Throwable)e);
            rm = new ApiResultMessage(-1, I18nUtil.i18nCode((String)"common_api_programError", (Object[])new Object[0]));
        }
        return rm;
    }

    @ApiOperation(value="Del Ele Level", notes="Return Result Object", response=ApiResultMessage.class)
    @RequestMapping(value={"/deleteLevel"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public ApiResultMessage deleteLevel(@RequestParam String pin, @RequestParam String levelIds) {
        ApiResultMessage rs = null;
        try {
            rs = this.eleLevelService.delApiPersonLevel(pin, levelIds);
        }
        catch (Exception e) {
            log.error("api eleLevel/deleteLevel error ", (Throwable)e);
            rs = ApiResultMessage.message((int)-1, (String)I18nUtil.i18nCode((String)"common_api_programError", (Object[])new Object[0]));
        }
        return rs;
    }

    @ApiOperation(value="Sync Ele Level To Dev", notes="Return Result Object", response=ApiResultMessage.class)
    @RequestMapping(value={"/syncLevel"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public ApiResultMessage syncEleLevelToDev(@RequestParam String levelId) {
        ApiResultMessage rm = null;
        try {
            rm = this.eleLevelService.syncApiLevel(levelId);
        }
        catch (Exception e) {
            log.error("api eleLevel/syncEleLevelToDev error", (Throwable)e);
            rm = ApiResultMessage.message((int)-1, (String)I18nUtil.i18nCode((String)"common_api_programError", (Object[])new Object[0]));
        }
        return rm;
    }

    @ApiOperation(value="Sync Ele Person Level", notes="Return Result Object", response=ApiResultMessage.class)
    @RequestMapping(value={"/syncPerson"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public ApiResultMessage syncElePersonToDev(@RequestParam String pin, @RequestParam String levelIds) {
        ApiResultMessage rm = null;
        try {
            rm = this.eleLevelService.syncApiPersonLevel(pin, levelIds);
        }
        catch (Exception e) {
            log.error("api eleLevel/syncElePerson error ", (Throwable)e);
            rm = new ApiResultMessage(-1, I18nUtil.i18nCode((String)"common_api_programError", (Object[])new Object[0]));
        }
        return rm;
    }
}

