/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ele.api.controller;

import com.google.common.collect.Lists;
import com.zkteco.zkbiosecurity.base.vo.ApiResultMessage;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.ele.api.vo.EleApiFloorItem;
import com.zkteco.zkbiosecurity.ele.service.EleDeviceService;
import com.zkteco.zkbiosecurity.ele.service.EleFloorService;
import com.zkteco.zkbiosecurity.ele.service.EleRTMonitorService;
import com.zkteco.zkbiosecurity.ele.vo.EleFloorItem;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/floor"})
@Api(tags={"EleFloor"}, description="ele floor")
public class EleApiFloorController {
    private static final Logger log = LoggerFactory.getLogger(EleApiFloorController.class);
    @Autowired
    private EleFloorService eleFloorService;
    @Autowired
    private EleRTMonitorService eleRTMonitorService;
    @Autowired
    private EleDeviceService eleDeviceService;

    @ResponseBody
    @RequestMapping(value={"/list"}, method={RequestMethod.GET}, produces={"application/json"})
    @ApiOperation(value="Get Ele Floors", notes="Return Ele Floor List", response=ApiResultMessage.class)
    public ApiResultMessage floorList(@RequestParam Integer pageNo, @RequestParam Integer pageSize) {
        ApiResultMessage rs = ApiResultMessage.successMessage();
        try {
            if (pageNo <= 0 || pageSize <= 0) {
                return ApiResultMessage.message((int)-90, (String)I18nUtil.i18nCode((String)"common_api_pageValid", (Object[])new Object[0]));
            }
            ArrayList eleApiFloorItemList = Lists.newArrayList();
            List eleFloorItemList = this.eleFloorService.getItemsByPage((BaseItem)new EleFloorItem(), pageNo - 1, pageSize.intValue()).getData();
            if (!eleFloorItemList.isEmpty()) {
                eleFloorItemList.forEach(eleFloorItem -> {
                    EleApiFloorItem eleApiFloorItem = EleApiFloorItem.createApiFloor((EleFloorItem)eleFloorItem);
                    if (eleApiFloorItem != null) {
                        eleApiFloorItemList.add(eleApiFloorItem);
                    }
                });
            }
            rs.setData((Object)eleApiFloorItemList);
        }
        catch (Exception e) {
            log.error("api floor/list error", (Throwable)e);
            rs = ApiResultMessage.message((int)-1, (String)I18nUtil.i18nCode((String)"common_api_programError", (Object[])new Object[0]));
        }
        return rs;
    }

    @ResponseBody
    @RequestMapping(value={"/remoteCloseById"}, method={RequestMethod.POST}, produces={"application/json"})
    @ApiOperation(value="Close Ele Floor By Id", notes="Return Result Object", response=ApiResultMessage.class)
    public ApiResultMessage lockingEleFloor(@RequestParam String floorId) {
        ApiResultMessage rs = null;
        try {
            if (StringUtils.isBlank((CharSequence)floorId)) {
                return ApiResultMessage.message((int)-201, (String)I18nUtil.i18nCode((String)"ele_api_floodIdNotNull", (Object[])new Object[0]));
            }
            Map dataMap = this.eleRTMonitorService.operateFloor("closeFloor", null, floorId);
            if (dataMap == null) {
                return ApiResultMessage.message((int)-1, (String)I18nUtil.i18nCode((String)"common_api_programError", (Object[])new Object[0]));
            }
            rs = this.dealResultData(dataMap);
        }
        catch (Exception e) {
            log.error("api floor/remoteCloseById error", (Throwable)e);
            rs = ApiResultMessage.message((int)-1, (String)I18nUtil.i18nCode((String)"common_api_programError", (Object[])new Object[0]));
        }
        return rs;
    }

    @ResponseBody
    @RequestMapping(value={"/remoteOpenById"}, method={RequestMethod.POST}, produces={"application/json"})
    @ApiOperation(value="Open Ele Floor By Id", notes="Return Result Object", response=ApiResultMessage.class)
    public ApiResultMessage openEleFloor(@RequestParam String floorId, @RequestParam String interval) {
        ApiResultMessage rs = null;
        try {
            if (StringUtils.isBlank((CharSequence)floorId)) {
                return ApiResultMessage.message((int)-201, (String)I18nUtil.i18nCode((String)"ele_api_floodIdNotNull", (Object[])new Object[0]));
            }
            if (StringUtils.isBlank((CharSequence)interval)) {
                return ApiResultMessage.message((int)-202, (String)I18nUtil.i18nCode((String)"ele_api_intervalNotNull", (Object[])new Object[0]));
            }
            if (Integer.parseInt(interval) <= 0 || Integer.parseInt(interval) > 254) {
                return ApiResultMessage.message((int)-203, (String)I18nUtil.i18nCode((String)"ele_api_intervalSize", (Object[])new Object[0]));
            }
            Map dataMap = this.eleRTMonitorService.operateFloor("openFloor", interval, floorId);
            if (dataMap == null) {
                return ApiResultMessage.message((int)-1, (String)I18nUtil.i18nCode((String)"common_api_programError", (Object[])new Object[0]));
            }
            rs = this.dealResultData(dataMap);
        }
        catch (Exception e) {
            log.error("api floor/remoteCloseById error", (Throwable)e);
            rs = new ApiResultMessage(-1, I18nUtil.i18nCode((String)"${docking_api_programError}", (Object[])new Object[0]));
        }
        return rs;
    }

    private ApiResultMessage dealResultData(Map<String, String> dataMap) {
        String cmdIdData = dataMap.get("cmdId");
        if ("true".equals(dataMap.get("notExistDev"))) {
            return ApiResultMessage.message((int)-1, (String)I18nUtil.i18nCode((String)"common_dev_notExistDev", (Object[])new Object[0]));
        }
        if (StringUtils.isNotBlank((CharSequence)cmdIdData)) {
            for (String cmdData : cmdIdData.split(",")) {
                String cmdId = cmdData.split("=")[0];
                Map resultMap = this.eleDeviceService.getCmdResultById(Long.valueOf(cmdId), 20);
                if (!Objects.isNull(resultMap) && !Objects.isNull(Integer.parseInt((String)resultMap.get("result"))) && Integer.parseInt((String)resultMap.get("result")) >= 0) continue;
                return ApiResultMessage.failedMessage((int)-1);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)dataMap.get("offline"))) {
            return ApiResultMessage.message((int)-1, (String)I18nUtil.i18nCode((String)"ele_api_devOffline", (Object[])new Object[0]));
        }
        if (StringUtils.isNotBlank((CharSequence)dataMap.get("notSupport"))) {
            return ApiResultMessage.message((int)-1, (String)I18nUtil.i18nCode((String)"ele_dev_devNotSupportFunction", (Object[])new Object[0]));
        }
        if (StringUtils.isNotBlank((CharSequence)dataMap.get("faile"))) {
            return ApiResultMessage.message((int)-1, (String)I18nUtil.i18nCode((String)"common_op_failed", (Object[])new Object[0]));
        }
        return ApiResultMessage.successMessage();
    }
}

