/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.push.center.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.push.center.remote.PushCenterSettingRemote;
import com.zkteco.zkbiosecurity.push.center.service.PushCenterSettingService;
import com.zkteco.zkbiosecurity.push.center.vo.PushCenterSettingItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PushCenterSettingController
extends BaseController
implements PushCenterSettingRemote {
    @Autowired
    private PushCenterSettingService pushCenterSettingService;

    @RequiresPermissions(value={"pushCenter:setting"})
    public ModelAndView index() {
        return new ModelAndView("pushCenter/setting/pushCenterSetting");
    }

    @RequiresPermissions(value={"pushCenter:setting:edit"})
    public ModelAndView edit(@RequestParam(value="id", required=false) String id) {
        String[] checkedPushTypes = null;
        if (StringUtils.isNotBlank((CharSequence)id)) {
            PushCenterSettingItem item = this.pushCenterSettingService.getItemById(id);
            if (StringUtils.isNotBlank((CharSequence)item.getPushTypes())) {
                checkedPushTypes = item.getPushTypes().split(",");
            }
            this.request.setAttribute("item", (Object)item);
        }
        Map pushTypesMap = this.pushCenterSettingService.getPushTypesMap(checkedPushTypes);
        this.request.setAttribute("pushTypesMap", (Object)pushTypesMap);
        return new ModelAndView("pushCenter/setting/editPushCenterSetting");
    }

    @RequiresPermissions(value={"pushCenter:setting:edit"})
    @LogRequest(module="pushCenter_module", object="pushCenter_setting", opType="common_op_edit", requestParams={"name"}, opContent="pushCenter_setting_name")
    public ZKResultMsg save(PushCenterSettingItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.pushCenterSettingService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    public DxGrid list(PushCenterSettingItem codition) {
        Pager pager = this.pushCenterSettingService.getItemsByPage((BaseItem)codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @RequiresPermissions(value={"pushCenter:setting:del"})
    @LogRequest(module="pushCenter_module", object="pushCenter_setting", opType="common_op_del", requestParams={"names"}, opContent="pushCenter_setting_name")
    public ZKResultMsg delete(@RequestParam(value="ids") String ids) {
        this.pushCenterSettingService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public boolean isNotExist(String name) {
        return this.pushCenterSettingService.isNotExist(name);
    }

    public boolean isNotExistPushUrl(String pushUrl) {
        return this.pushCenterSettingService.isNotExistPushUrl(pushUrl);
    }

    public ZKResultMsg checkPushUrl(String pushUrl) {
        return this.pushCenterSettingService.checkPushUrl(pushUrl);
    }

    public ZKResultMsg checkSetting() {
        return this.pushCenterSettingService.checkSetting();
    }
}

