/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.push.center.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.push.center.remote.PushCenterRecordRemote;
import com.zkteco.zkbiosecurity.push.center.service.PushCenterRecordService;
import com.zkteco.zkbiosecurity.push.center.service.PushCenterSettingService;
import com.zkteco.zkbiosecurity.push.center.vo.PushCenterRecordItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.Date;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PushCenterRecordController
extends BaseController
implements PushCenterRecordRemote {
    @Autowired
    private PushCenterRecordService pushCenterRecordService;
    @Autowired
    private PushCenterSettingService pushCenterSettingService;

    @RequiresPermissions(value={"pushCenter:record"})
    public ModelAndView index() {
        return new ModelAndView("pushCenter/record/pushCenterRecord");
    }

    public DxGrid list(PushCenterRecordItem condition) {
        Pager pager = this.pushCenterRecordService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize(), this.getLimitCount());
        return GridUtil.convert((Pager)pager, condition.getClass(), (boolean)this.getPageList());
    }

    @RequiresPermissions(value={"pushCenter:record:del"})
    @LogRequest(module="pushCenter_module", object="pushCenter_record", opType="common_op_del", requestParams={"names"}, opContent="pushCenter_setting_pushTypes")
    public ZKResultMsg delete(@RequestParam(value="ids") String ids) {
        this.pushCenterRecordService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"pushCenter:record:retry"})
    public ZKResultMsg retry(String ids) {
        this.pushCenterRecordService.retry(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public ModelAndView manualView() {
        Map pushTypesMap = this.pushCenterSettingService.getSettingPushTypesMap();
        this.request.setAttribute("pushTypesMap", (Object)pushTypesMap);
        return new ModelAndView("pushCenter/record/opPushCenterManual");
    }

    public ZKResultMsg manual(Date startTime, Date endTime, String pushTypes) {
        this.pushCenterRecordService.manual(startTime, endTime, pushTypes);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }
}

