/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.message.center.controller;

import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.message.center.remote.MessageRecordRemote;
import com.zkteco.zkbiosecurity.message.center.service.MessageRecordService;
import com.zkteco.zkbiosecurity.message.center.vo.MessageRecordItem;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
public class MessageRecordController
extends BaseController
implements MessageRecordRemote {
    @Autowired
    private MessageRecordService messageRecordService;

    public ModelAndView index() {
        this.request.setAttribute("supportModuleName", (Object)this.messageRecordService.getSupportModuleName());
        return new ModelAndView("messageCenter/record/messageRecord");
    }

    public DxGrid list(MessageRecordItem condition) {
        Pager pager = this.messageRecordService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize(), this.getLimitCount());
        List messageRecordItems = pager.getData();
        for (MessageRecordItem item : messageRecordItems) {
            item.setSourceModule(I18nUtil.i18nCode((String)(item.getSourceModule() + "_module"), (Object[])new Object[0]));
        }
        return GridUtil.convert((Pager)pager, condition.getClass(), (boolean)this.getPageList());
    }

    public ZKResultMsg getEditUrlById(String id) {
        ZKResultMsg res = ZKResultMsg.successMsg();
        MessageRecordItem recordItem = this.messageRecordService.getItemById(id);
        if (recordItem != null) {
            res.setMsg(recordItem.getHref());
        }
        return res;
    }
}

