/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.map.center.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.ApplicationPropertiesUtil;
import com.zkteco.zkbiosecurity.core.utils.DateUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.map.center.bean.MapBulkOperateAccParams;
import com.zkteco.zkbiosecurity.map.center.constant.MapConstant;
import com.zkteco.zkbiosecurity.map.center.query.MapCenterEventItem;
import com.zkteco.zkbiosecurity.map.center.remote.MapMonitoringRemote;
import com.zkteco.zkbiosecurity.map.center.service.MapElementService;
import com.zkteco.zkbiosecurity.map.center.service.MapMapService;
import com.zkteco.zkbiosecurity.map.center.service.MapMonitoringService;
import com.zkteco.zkbiosecurity.map.center.vo.MapElementItem;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class MapMonitoringController
extends BaseController
implements MapMonitoringRemote {
    private static final Logger log = LoggerFactory.getLogger(MapMonitoringController.class);
    @Autowired
    private MapMapService mapMapService;
    @Autowired
    private MapElementService mapElementService;
    @Autowired
    private MapMonitoringService mapMonitoringService;

    public ModelAndView index() {
        this.request.setAttribute("mapModuleInfoMap", (Object)MapConstant.MAP_MODULE_INFO);
        return new ModelAndView("map/monitoring/mapMainMonitor");
    }

    public ZKResultMsg checkWheAddCamerasByMapId(String mapId) {
        ZKResultMsg res = new ZKResultMsg();
        MapElementItem queryItem = new MapElementItem();
        queryItem.setMapId(mapId);
        queryItem.setEntityType("VidChannel");
        List mapPosItemList = this.mapElementService.getByCondition(queryItem);
        if (mapPosItemList.size() > 0) {
            res.setRet("ok");
        } else {
            res.setRet("ok");
        }
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    public ModelAndView getPersonSetIndexForAnalytical(String id) {
        this.request.setAttribute("mapId", (Object)id);
        return new ModelAndView("map/track/mapGetFaceTrackForAnalytical");
    }

    public ZKResultMsg getPersonFaceTrack() {
        Date endDate;
        ZKResultMsg resultMsg = ZKResultMsg.failMsg();
        String mapId = this.request.getParameter("mapId");
        String startTime = this.request.getParameter("startTime");
        String endTime = this.request.getParameter("endTime");
        String personPhoto = this.request.getParameter("personPhoto");
        String algorithmCode = this.request.getParameter("algorithmCode");
        String visVisitPinId = this.request.getParameter("visVisitPinId");
        String personnelType = this.request.getParameter("personnelType");
        String confidenceThreshold = this.request.getParameter("confidenceThreshold");
        Date startDate = DateUtil.stringToDate((String)startTime);
        if (startDate.after(endDate = DateUtil.stringToDate((String)endTime))) {
            resultMsg.setMsg("common_startEndDateCompare");
            return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
        }
        if (StringUtils.isEmpty((CharSequence)personPhoto) && StringUtils.isEmpty((CharSequence)visVisitPinId)) {
            resultMsg.setMsg("acc_map_nonPhoto");
            return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
        }
        HashMap<String, String> mapParams = new HashMap<String, String>(16);
        mapParams.put("mapId", mapId);
        mapParams.put("startTime", startTime);
        mapParams.put("endTime", endTime);
        mapParams.put("personPhoto", personPhoto);
        mapParams.put("confidenceThreshold", confidenceThreshold);
        mapParams.put("algorithmCode", algorithmCode);
        mapParams.put("visVisitPinId", visVisitPinId);
        mapParams.put("personnelType", personnelType);
        mapParams.put("sessionId", this.request.getSession().getId());
        resultMsg = this.mapMonitoringService.getPersonFaceTrack(mapParams);
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }

    public ModelAndView getVehicleSetIndexForAnalytical(String id) {
        this.request.setAttribute("mapId", (Object)id);
        return new ModelAndView("map/track/mapGetVehicleTrackForAnalytical");
    }

    public ZKResultMsg getVehicleTrack() {
        ZKResultMsg resultMsg = new ZKResultMsg();
        HashMap resultMap = new HashMap();
        resultMap.put("cameraSnList", new ArrayList());
        resultMap.put("cameraDataList", new ArrayList());
        resultMap.put("dataList", new ArrayList());
        resultMsg.setData(resultMap);
        return resultMsg;
    }

    public ZKResultMsg getAlarmEventCount(String eventType) {
        ZKResultMsg zkResultMsg = ZKResultMsg.successMsg();
        JSONArray elements = new JSONArray();
        Map eventCenterLevel = this.mapMonitoringService.getAllEventCenterLevel();
        for (Map.Entry levelEntry : eventCenterLevel.entrySet()) {
            String levelVal = (String)levelEntry.getKey();
            if (Integer.parseInt(levelVal) != 2 && Integer.parseInt(levelVal) != 3) continue;
            JSONObject data = new JSONObject();
            data.put("eventLevelCount", (Object)this.mapMonitoringService.countByEventLevelAndType(levelVal, eventType));
            data.put("eventLevel", (Object)levelVal);
            data.put("eventLevelName", levelEntry.getValue());
            data.put("eventType", (Object)eventType);
            elements.add((Object)data);
        }
        zkResultMsg.setData((Object)elements);
        return zkResultMsg;
    }

    public ZKResultMsg getAllAlarmLevelI18n() {
        return new ZKResultMsg((Object)this.mapMonitoringService.getAllEventCenterLevel());
    }

    public ZKResultMsg confirmAlarm() {
        String recordId = this.request.getParameter("recordId");
        String remark = this.request.getParameter("eventRemark");
        return this.mapMonitoringService.confirmEvent(recordId, remark);
    }

    public ZKResultMsg getDeviceByChannelId(String channelId) {
        return this.mapMonitoringService.getVideoDeviceCode(this.request.getSession().getId(), channelId);
    }

    public ZKResultMsg listAlarmItemByPage(MapCenterEventItem accAlarmItemParam) {
        ZKResultMsg result = ZKResultMsg.successMsg();
        List dataList = this.mapMonitoringService.listAlarmItemByPage(accAlarmItemParam);
        String localDataFormat = ApplicationPropertiesUtil.getProperty((String)"biosecurity.date.sysDateTimeFmt.alias", (String)"yyyy-MM-dd HH:mm:ss");
        dataList.stream().filter(item -> item.getEventTime() != null).forEach(item -> item.setEventTimeStr(DateUtil.dateToLocaleString((Date)item.getEventTime(), (String)localDataFormat)));
        result.setData((Object)dataList);
        return result;
    }

    public ZKResultMsg getAlarmDetail(String id) {
        String sessionId = this.request.getSession().getId();
        JSONObject object = new JSONObject((Map)this.mapMonitoringService.getEventDetailById(sessionId, id));
        ZKResultMsg resultMsg = ZKResultMsg.successMsg();
        Long eventTime = object.getLong("eventTime");
        if (eventTime != null) {
            object.put("eventTimeStr", (Object)DateUtil.dateToLocaleString((Date)new Date(eventTime), (String)ApplicationPropertiesUtil.getProperty((String)"biosecurity.date.sysDateTimeFmt.alias", (String)"yyyy-MM-dd HH:mm:ss")));
        }
        resultMsg.setData((Object)object);
        return resultMsg;
    }

    public ZKResultMsg getElementStatus() {
        String entityInfo = this.request.getParameter("entityInfo");
        JSONObject entityJson = new JSONObject();
        if (StringUtils.isNotBlank((CharSequence)entityInfo)) {
            entityJson = JSON.parseObject((String)entityInfo);
        }
        return this.mapMonitoringService.getMapElementStatus(entityJson);
    }

    public ZKResultMsg bulkOperations(MapBulkOperateAccParams mapBulkOperateAccParams) {
        return this.mapMonitoringService.penetrateInfo(mapBulkOperateAccParams.getOperationType(), mapBulkOperateAccParams.getOpenInterval(), mapBulkOperateAccParams.getIds());
    }

    public ZKResultMsg openDoor(String ids, String openInterval) {
        return this.mapMonitoringService.penetrateInfo("openDoor", openInterval, ids);
    }

    public ZKResultMsg closeDoor(String ids) {
        return this.mapMonitoringService.penetrateInfo("closeDoor", null, ids);
    }

    public ZKResultMsg cancelAlarm(String ids) {
        return this.mapMonitoringService.penetrateInfo("cancelAlarm", null, ids);
    }

    public ZKResultMsg lockDoor(String ids) {
        return this.mapMonitoringService.penetrateInfo("lockDoor", null, ids);
    }

    public ZKResultMsg unLockDoor(String ids) {
        return this.mapMonitoringService.penetrateInfo("unLockDoor", null, ids);
    }

    public ZKResultMsg normalOpenDoor(String ids) {
        return this.mapMonitoringService.penetrateInfo("normalOpenDoor", null, ids);
    }

    public ZKResultMsg enableNormalOpenDoor(String ids) {
        return this.mapMonitoringService.penetrateInfo("enableNormalOpenDoor", null, ids);
    }

    public ZKResultMsg disableNormalOpenDoor(String ids) {
        return this.mapMonitoringService.penetrateInfo("disableNormalOpenDoor", null, ids);
    }

    public ModelAndView opShowMorePic(String listPicData) {
        this.request.setAttribute("listPicData", (Object)this.mapMonitoringService.decodeLocusPicData(listPicData));
        return new ModelAndView("map/monitoring/opShowMorePic");
    }
}

