/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.map.center.controller;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.TreeItem;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.format.TreeBuilder;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.ClassUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.map.center.constant.MapConstant;
import com.zkteco.zkbiosecurity.map.center.remote.MapMapRemote;
import com.zkteco.zkbiosecurity.map.center.service.MapElementService;
import com.zkteco.zkbiosecurity.map.center.service.MapMapService;
import com.zkteco.zkbiosecurity.map.center.vo.MapElementItem;
import com.zkteco.zkbiosecurity.map.center.vo.MapMapItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.util.Base64Utils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class MapMapController
extends BaseController
implements MapMapRemote {
    private static final Logger log = LoggerFactory.getLogger(MapMapController.class);
    @Value(value="${system.filePath:BioSecurityFile}")
    private String systemFilePath;
    @Autowired
    private MapMapService mapMapService;
    @Autowired
    private MapElementService mapElementService;

    public ModelAndView index() {
        this.request.setAttribute("mapModuleInfoMap", (Object)MapConstant.MAP_MODULE_INFO);
        return new ModelAndView("map/baseMap/mapBaseMap");
    }

    @RequiresPermissions(value={"map:config:add", "map:config:edit"})
    public ModelAndView edit(String id) {
        MapMapItem mapItem = new MapMapItem();
        if (StringUtils.isNotBlank((CharSequence)id)) {
            mapItem = this.mapMapService.getItemById(id);
            if (mapItem != null && mapItem.getCenterX() != null) {
                this.request.setAttribute("itemCenterX", (Object)mapItem.getCenterX().toString());
            } else {
                this.request.setAttribute("itemCenterX", (Object)"");
            }
            if (mapItem != null && mapItem.getCenterY() != null) {
                this.request.setAttribute("itemCenterY", (Object)mapItem.getCenterY().toString());
            } else {
                this.request.setAttribute("itemCenterY", (Object)"");
            }
            this.request.setAttribute("editPage", (Object)true);
        } else {
            this.request.setAttribute("disableAreaIds", (Object)this.mapMapService.getDisableAreaIds());
            mapItem.setAuthAreaId(this.request.getParameter("authAreaId"));
        }
        this.request.setAttribute("item", (Object)mapItem);
        return new ModelAndView("map/baseMap/editBaseMap");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ZKResultMsg save(@RequestParam(value="file", required=false) MultipartFile file, MapMapItem item) {
        ZKResultMsg res = new ZKResultMsg();
        if ("Normal".equals(item.getMapType())) {
            MapMapItem oldMap;
            File oldPic;
            String path = this.systemFilePath + File.separator + "/upload/map/baseMap";
            if (0L == file.getSize()) throw new ZKBusinessException(I18nUtil.i18nCode((String)"map_track_select_map", (Object[])new Object[0]));
            if (file == null || file.getSize() > 0x200000L) {
                throw ZKBusinessException.warnException((String)"base_map_imgSizeError", (Object[])new Object[0]);
            }
            File upLoadPicPath = new File(path);
            if (!upLoadPicPath.isAbsolute()) {
                path = ClassUtil.getRootPath() + "/" + path;
                upLoadPicPath = new File(path);
            }
            if (!upLoadPicPath.exists()) {
                upLoadPicPath.mkdirs();
            }
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{item.getId()}) && (oldPic = new File((oldMap = this.mapMapService.getItemById(item.getId())).getMapPath())).exists()) {
                oldPic.delete();
            }
            long fName = System.currentTimeMillis();
            item.setMapPath(path + "/" + fName + ".jpg");
            try {
                String mapName = path + "/" + fName + ".jpg";
                File mapFile = new File(mapName);
                file.transferTo(mapFile);
            }
            catch (IOException e) {
                throw new ZKBusinessException("AccMapItem SaveMap Exception");
            }
        } else if ("GIS".equals(item.getMapType())) {
            item.setMapPath(item.getGisMapPath());
            item.setAnalysisPath(item.getGisAnalysisPath());
            item.setProjection(item.getGisProjections());
            item.setCenterX(item.getGisCenterX());
            item.setCenterY(item.getGisCenterY());
            item.setInitialLevel(item.getGisInitialLevel());
            item.setMaximumLevel(item.getGisMaximumLevel());
            item.setMinimumLevel(item.getGisMinimumLevel());
            if (item.getMapPath().startsWith(",")) {
                item.setMapPath(item.getMapPath().split(",")[1]);
            }
        } else if ("Google".equals(item.getMapType())) {
            item.setMapKey(item.getGoogleMapKey());
            item.setInitialLevel(item.getGoogleInitialLevel());
            item.setCenterX(item.getGoogleCenterX());
            item.setCenterY(item.getGoogleCenterY());
        } else if ("Baidu".equals(item.getMapType())) {
            item.setMapKey(item.getBaiduMapKey());
            item.setInitialLevel(item.getBaiduInitialLevel());
            item.setCenterX(item.getBaiduCenterX());
            item.setCenterY(item.getBaiduCenterY());
        }
        this.mapMapService.saveItem(item);
        res.setData((Object)item.getId());
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"map:config:del"})
    @LogRequest(module="map_module", object="map_leftMenu_mapConfig", opType="map_del", requestParams={"name"}, opContent="base_map_name")
    public ZKResultMsg del(String ids) {
        this.mapMapService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public ModelAndView getMainMap(String id) {
        MapMapItem tempMapItem = null;
        if (StringUtils.isNotBlank((CharSequence)id) && (tempMapItem = this.mapMapService.getItemById(id)) != null) {
            if ("Normal".equals(tempMapItem.getMapType())) {
                String imgBase64Str = "";
                String mapPath = tempMapItem.getMapPath();
                File mapfile = new File(mapPath);
                if (mapfile.exists()) {
                    try {
                        FileInputStream in = new FileInputStream(mapfile);
                        byte[] data = new byte[((InputStream)in).available()];
                        ((InputStream)in).read(data);
                        imgBase64Str = Base64Utils.encodeToString((byte[])data);
                        tempMapItem.setMapPath("data:image/jpg;base64," + imgBase64Str);
                        ((InputStream)in).close();
                    }
                    catch (IOException e) {
                        throw new ZKBusinessException("AccMapController getMap base64 error");
                    }
                }
            }
            this.request.setAttribute("tempMap", (Object)tempMapItem);
            if (null != tempMapItem.getCenterX()) {
                this.request.setAttribute("CenterXNum", (Object)String.valueOf(tempMapItem.getCenterX()));
            }
            if (null != tempMapItem.getCenterY()) {
                this.request.setAttribute("CenterYNum", (Object)String.valueOf(tempMapItem.getCenterY()));
            }
            if (null != tempMapItem.getInitialLevel()) {
                this.request.setAttribute("initialLevel", (Object)String.valueOf(tempMapItem.getInitialLevel()));
            }
            if (null != tempMapItem.getMaximumLevel()) {
                this.request.setAttribute("maximumLevel", (Object)String.valueOf(tempMapItem.getMaximumLevel()));
            }
            if (null != tempMapItem.getMinimumLevel()) {
                this.request.setAttribute("minimumLevel", (Object)String.valueOf(tempMapItem.getMinimumLevel()));
            }
            this.request.setAttribute("mapId", (Object)id);
        }
        Object personPhotoMaxHeight = null;
        String supportGisMap = "0";
        Object accIsShowPhoto = null;
        Object accIsShowSound = null;
        Object loadPlugins = null;
        String source = this.request.getParameter("source");
        this.request.setAttribute("personPhotoMaxHeight", personPhotoMaxHeight);
        this.request.setAttribute("accIsShowPhoto", accIsShowPhoto);
        this.request.setAttribute("accIsShowSound", accIsShowSound);
        this.request.setAttribute("loadPlugins", loadPlugins);
        this.request.setAttribute("gridName", (Object)this.request.getParameter("gridName"));
        this.request.setAttribute("supportGisMap", (Object)Integer.parseInt(supportGisMap));
        this.request.setAttribute("source", (Object)source);
        if (null == tempMapItem || StringUtils.isBlank((CharSequence)tempMapItem.getMapType())) {
            throw ZKBusinessException.warnException((String)"map_loading_error", (Object[])new Object[0]);
        }
        this.request.setAttribute("mapModuleInfoMap", (Object)MapConstant.MAP_MODULE_INFO);
        switch (tempMapItem.getMapType()) {
            case "Normal": {
                ZKResultMsg result = this.getMapElements(id);
                Map mapDataMap = (Map)result.getData();
                this.request.setAttribute("mapPosList", mapDataMap.get("mapPosList"));
                this.request.setAttribute("mapPosListJson", mapDataMap.get("mapPosListJson"));
                return new ModelAndView("map/baseMap/mapMainGeneral");
            }
            case "GIS": {
                return new ModelAndView("map/baseMap/mapMainGis");
            }
            case "Google": {
                return new ModelAndView("map/baseMap/mapMainGoogle");
            }
            case "Baidu": {
                return new ModelAndView("map/baseMap/mapMainBaidu");
            }
        }
        return new ModelAndView("map/baseMap/mapMainGeneral");
    }

    public ZKResultMsg getMapElements(String mapId) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        List mapPosItemList = this.mapElementService.loadMapElementsByAuthFilter(this.request.getSession().getId(), mapId);
        mapPosItemList = this.mapElementService.replaceElementSkin(mapPosItemList);
        resultMap.put("mapPosList", mapPosItemList);
        resultMap.put("mapPosListJson", JSONObject.toJSONString((Object)mapPosItemList));
        ZKResultMsg resultMsg = ZKResultMsg.successMsg();
        resultMsg.setData(resultMap);
        return resultMsg;
    }

    public boolean isExist(MapMapItem item) {
        String mapName = this.request.getParameter("mapName");
        if (!item.getName().equals(mapName)) {
            return this.mapMapService.isExist(item.getName());
        }
        return true;
    }

    public TreeItem getMapTree() {
        List items = this.mapMapService.createMapTree(this.request.getSession().getId());
        if (items == null || items.isEmpty()) {
            TreeItem infoItem = new TreeItem();
            infoItem.setId("_");
            infoItem.setText("<span class='warningColor'>" + I18nUtil.i18nCode((String)"base_map_addMap", (Object[])new Object[0]) + "</span>");
            infoItem.setIm0("comm_iconAlert.png");
            items.add(infoItem);
        }
        List treeItems = TreeBuilder.newTreeBuilder(TreeItem.class, String.class).buildToTreeList((Collection)items);
        return new TreeItem("0", treeItems);
    }

    public ZKResultMsg saveMapElement(@RequestBody List<MapElementItem> mapElementList) {
        ZKResultMsg zkResultMsg = this.mapMapService.saveMapElement(mapElementList);
        return I18nUtil.i18nMsg((ZKResultMsg)zkResultMsg);
    }

    @RequiresPermissions(value={"auth:area:add", "auth:area:edit"})
    public ModelAndView editMapArea(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            String parentAreaId = "";
            if (id.contains("_")) {
                parentAreaId = id.substring(0, id.length() - 1);
            } else {
                MapMapItem mapMapItem = this.mapMapService.getItemById(id);
                if (mapMapItem != null) {
                    parentAreaId = mapMapItem.getAuthAreaId();
                }
            }
            HashMap<String, String> item = new HashMap<String, String>();
            item.put("parentId", parentAreaId);
            this.request.setAttribute("item", item);
        }
        return new ModelAndView("auth/area/editAuthArea");
    }
}

