/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.map.center.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.map.center.constant.MapConstant;
import com.zkteco.zkbiosecurity.map.center.remote.MapElementRemote;
import com.zkteco.zkbiosecurity.map.center.service.MapElementService;
import com.zkteco.zkbiosecurity.map.center.vo.MapElementItem;
import com.zkteco.zkbiosecurity.map.center.vo.MapMapItem;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class MapElementController
extends BaseController
implements MapElementRemote {
    private static final Logger log = LoggerFactory.getLogger(MapElementController.class);
    @Value(value="${system.filePath:BioSecurityFile}")
    private String systemFilePath;
    @Autowired
    private MapElementService mapElementService;

    public ModelAndView index() {
        return null;
    }

    public ModelAndView edit(String id) {
        return null;
    }

    public ZKResultMsg save(MultipartFile file, MapMapItem item) {
        return null;
    }

    public ZKResultMsg getEntityTreeByType(String type, String mapId, Boolean showAll) {
        String sessionId = this.request.getSession().getId();
        ZKResultMsg zkResultMsg = this.mapElementService.getEntityByType(sessionId, type, mapId, showAll.booleanValue());
        List nodeList = (List)zkResultMsg.getData();
        nodeList = this.mapElementService.replaceTreeNodeSkin(nodeList);
        zkResultMsg.setData((Object)nodeList);
        return zkResultMsg;
    }

    @LogRequest(module="map_module", object="map_leftMenu_mapConfig", opType="base_map_delEntity", requestParams={"name"}, opContent="common_dev_name")
    public ZKResultMsg deleteElements(String ids) {
        if (StringUtils.isNotBlank((CharSequence)ids)) {
            this.mapElementService.deleteByAuthFilter(this.request.getSession().getId(), ids);
        }
        return ZKResultMsg.successMsg();
    }

    public ModelAndView getElementDeviceInfoView(String entityId) {
        this.request.setAttribute("accMapMainPosDeviceInfo", (Object)entityId);
        return new ModelAndView("map/monitoring/mapMainPosDeviceInfo");
    }

    public ZKResultMsg getMapPosDeviceInfo(String entityId) {
        ZKResultMsg zkResultMsg = ZKResultMsg.successMsg();
        MapElementItem tmpAccMapPosItem = new MapElementItem();
        tmpAccMapPosItem.setEntityId(entityId);
        List itemList = this.mapElementService.getByCondition(tmpAccMapPosItem);
        Map<String, String> resultMap = new HashMap<String, String>();
        if (null != itemList) {
            MapElementItem accMapPosItem = (MapElementItem)itemList.get(0);
            switch (accMapPosItem.getEntityType()) {
                case "AccDoor": {
                    resultMap = this.mapElementService.getMapPosAccDoorDeviceInfo(accMapPosItem.getEntityId());
                    zkResultMsg.setData(resultMap);
                    break;
                }
                case "VidChannel": {
                    resultMap = this.mapElementService.getMapPosVidChannelDeviceInfo(this.request.getSession().getId(), accMapPosItem.getEntityId());
                    zkResultMsg.setData(resultMap);
                    break;
                }
            }
            resultMap.put("type", accMapPosItem.getEntityType());
        }
        return zkResultMsg;
    }

    public ZKResultMsg getDeviceMapLocation(String entityId) {
        return this.mapElementService.getDeviceMapLocation(this.request.getSession().getId(), entityId);
    }

    public ModelAndView getModifyElementIconView() {
        String id = this.request.getParameter("id");
        String name = this.request.getParameter("name");
        String entityType = this.request.getParameter("entityType");
        String elementType = "camera";
        String img = "vid_channel.png";
        if (entityType.equals("EsdcDevice")) {
            elementType = "esdc";
            img = "esdc_device.png";
        }
        this.request.setAttribute("id", (Object)id);
        this.request.setAttribute("name", (Object)name);
        this.request.setAttribute("elementType", (Object)elementType);
        this.request.setAttribute("img", (Object)img);
        this.request.setAttribute("iconTypeList", (Object)MapConstant.CAMERA_ICON_TYPE);
        return new ModelAndView("map/baseMap/opMapModifyElementIcon");
    }

    @LogRequest(module="map_module", object="map_leftMenu_mapConfig", opType="base_map_modifyIcon", requestParams={"name"}, opContent="common_name")
    public ZKResultMsg updateElementIcon(String id, String iconType) {
        ZKResultMsg zkResultMsg = new ZKResultMsg();
        MapElementItem mapElementItem = this.mapElementService.updateElementIcon(id, iconType);
        if (Objects.nonNull(mapElementItem)) {
            List mapElementItemList = this.mapElementService.replaceElementSkin(Collections.singletonList(mapElementItem));
            mapElementItem = (MapElementItem)mapElementItemList.get(0);
        }
        zkResultMsg.setData((Object)mapElementItem.getEntityIcon());
        return I18nUtil.i18nMsg((ZKResultMsg)zkResultMsg);
    }
}

