/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.hybridCloudPush.controller;

import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.hybridCloudPush.remote.HybridCloudPushRemote;
import com.zkteco.zkbiosecurity.hybridCloudPush.service.HybridCloudPushService;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class HybridCloudPushController
extends BaseController
implements HybridCloudPushRemote {
    @Autowired
    private HybridCloudPushService hybridCloudPushService;
    @Value(value="${hybridCloud.download.url:https://zkbio-cvconnect.s3.ap-southeast-1.amazonaws.com/setup/ZKBioCVConnect_Client_V1.0.0.exe}")
    private String hybridCloudDownloadUrl;

    @RequiresPermissions(value={"hybridCloudPush:management"})
    public ModelAndView index() {
        Map hybridCloudParams = this.hybridCloudPushService.getHybridCloudPushParams();
        this.request.setAttribute("hybridCloudParams", (Object)hybridCloudParams);
        this.request.setAttribute("hybridCloudDownloadUrl", (Object)this.hybridCloudDownloadUrl);
        return new ModelAndView("HybridCloudPush/params/hybridCloudPushParams");
    }

    @RequiresPermissions(value={"hybridCloudPush:management"})
    public ZKResultMsg save(Map<String, String> whatsappParams) {
        ZKResultMsg res = new ZKResultMsg();
        this.hybridCloudPushService.saveItem(whatsappParams);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }
}

