/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.event.center.controller;

import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.SelectItem;
import com.zkteco.zkbiosecurity.base.bean.TreeItem;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.format.TreeBuilder;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.event.center.remote.EventTypeRemote;
import com.zkteco.zkbiosecurity.event.center.service.EventTypeService;
import com.zkteco.zkbiosecurity.event.center.vo.EventTypeItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class EventTypeController
extends BaseController
implements EventTypeRemote {
    @Autowired
    private EventTypeService eventTypeService;

    @RequiresPermissions(value={"event:center:type"})
    public ModelAndView index() {
        return new ModelAndView("eventCenter/type/eventType");
    }

    @RequiresPermissions(value={"event:center:level:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.eventTypeService.getItemById(id));
        }
        return null;
    }

    @RequiresPermissions(value={"event:center:type:edit"})
    public ZKResultMsg save(EventTypeItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.eventTypeService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"event:center:type:refresh"})
    public DxGrid list(EventTypeItem condition) {
        Pager pager = this.eventTypeService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        List eventTypeItems = pager.getData();
        for (EventTypeItem eventTypeItem : eventTypeItems) {
            eventTypeItem.setSourceModule(I18nUtil.i18nCode((String)(eventTypeItem.getSourceModule() + "_module"), (Object[])new Object[0]));
        }
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"event:center:type:del"})
    public ZKResultMsg delete(String ids) {
        ZKResultMsg retMsg = new ZKResultMsg();
        this.eventTypeService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)retMsg);
    }

    public ZKResultMsg editEventTypeLevel(String ids, String eventLevelVal) {
        ZKResultMsg res = new ZKResultMsg();
        this.eventTypeService.editEventTypeLevel(ids, eventLevelVal);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    public ZKResultMsg getModuleNames() {
        ArrayList<SelectItem> items = new ArrayList<SelectItem>();
        List moduleNames = this.eventTypeService.getAllModuleName();
        for (String moduleName : moduleNames) {
            items.add(new SelectItem((Object)I18nUtil.i18nCode((String)(moduleName + "_module"), (Object[])new Object[0]), moduleName));
        }
        return new ZKResultMsg(items);
    }

    public TreeItem getModuleNameTree() {
        List moduleNames = this.eventTypeService.getAllModuleName();
        ArrayList<TreeItem> items = new ArrayList<TreeItem>();
        if (!moduleNames.isEmpty()) {
            for (String moduleName : moduleNames) {
                TreeItem item = new TreeItem();
                item.setId(moduleName);
                item.setText(I18nUtil.i18nCode((String)(moduleName + "_module"), (Object[])new Object[0]));
                items.add(item);
            }
        }
        List treeItems = TreeBuilder.newTreeBuilder(TreeItem.class, String.class).buildToTreeList(items);
        return new TreeItem("0", treeItems);
    }
}

