/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.event.center.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.FileEncryptUtil;
import com.zkteco.zkbiosecurity.core.utils.FileUtils;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.event.center.remote.EventRecordRemote;
import com.zkteco.zkbiosecurity.event.center.service.EventRecordService;
import com.zkteco.zkbiosecurity.event.center.vo.EventRecordItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class EventRecordController
extends ExportController
implements EventRecordRemote {
    @Autowired
    private EventRecordService eventRecordService;

    @RequiresPermissions(value={"event:center:record"})
    public ModelAndView index() {
        return new ModelAndView("eventCenter/record/eventRecord");
    }

    @RequiresPermissions(value={"event:center:record:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.eventRecordService.getItemById(id));
        }
        return null;
    }

    @RequiresPermissions(value={"event:center:record:edit"})
    public ZKResultMsg save(EventRecordItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.eventRecordService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"event:center:record:refresh"})
    public DxGrid list(EventRecordItem condition) {
        Pager pager = this.eventRecordService.getItemsByPageAndAreaIds(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize(), this.getLimitCount());
        List eventRecordItems = pager.getData();
        for (EventRecordItem eventRecordItem : eventRecordItems) {
            String eventLevelVal = eventRecordItem.getEventLevelVal();
            if (StringUtils.isNotBlank((CharSequence)eventLevelVal)) {
                switch (eventLevelVal) {
                    case "1": {
                        eventRecordItem.setEventLevelName(I18nUtil.i18nCode((String)"event_level_common", (Object[])new Object[0]));
                        break;
                    }
                    case "2": {
                        eventRecordItem.setEventLevelName(I18nUtil.i18nCode((String)"event_level_warning", (Object[])new Object[0]));
                        break;
                    }
                    case "3": {
                        eventRecordItem.setEventLevelName(I18nUtil.i18nCode((String)"event_level_emergency", (Object[])new Object[0]));
                        break;
                    }
                    default: {
                        eventRecordItem.setEventLevelName(I18nUtil.i18nCode((String)"event_level_normal", (Object[])new Object[0]));
                    }
                }
            }
            if (!FileUtils.fileExists((String)eventRecordItem.getCaptureImgURL())) {
                eventRecordItem.setCaptureImgURL(null);
            }
            if (!FileUtils.fileExists((String)eventRecordItem.getPanoramaImgURL())) {
                eventRecordItem.setPanoramaImgURL(null);
            }
            eventRecordItem.setSourceModule(I18nUtil.i18nCode((String)(eventRecordItem.getSourceModule() + "_module"), (Object[])new Object[0]));
        }
        return GridUtil.convert((Pager)pager, condition.getClass(), (boolean)this.getPageList());
    }

    @RequiresPermissions(value={"event:center:record:del"})
    public ZKResultMsg delete(String ids) {
        ZKResultMsg retMsg = new ZKResultMsg();
        this.eventRecordService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)retMsg);
    }

    public ZKResultMsg affirm(String id, String eventRemark) {
        ZKResultMsg retMsg = new ZKResultMsg();
        this.eventRecordService.affirmEventLog(id, eventRemark);
        return I18nUtil.i18nMsg((ZKResultMsg)retMsg);
    }

    public ZKResultMsg getDecryptFileBase64(String photoPath) {
        ZKResultMsg zkResultMsg = new ZKResultMsg();
        String decryptFileBase64 = FileEncryptUtil.getDecryptFileBase64((String)photoPath);
        if (StringUtils.isNotBlank((CharSequence)decryptFileBase64)) {
            decryptFileBase64 = "data:image/jpg;base64," + decryptFileBase64;
            zkResultMsg.setData((Object)decryptFileBase64);
        }
        return zkResultMsg;
    }

    public ZKResultMsg saveQuickInput(String name) {
        return this.eventRecordService.saveQuickInput(name);
    }

    public ZKResultMsg findAllQuickInput() {
        return this.eventRecordService.findAllQuickInput();
    }

    public ZKResultMsg delQuickInputById(String id) {
        ZKResultMsg ret = new ZKResultMsg();
        this.eventRecordService.delQuickInputById(id);
        return I18nUtil.i18nMsg((ZKResultMsg)ret);
    }

    @RequiresPermissions(value={"event:center:record:export"})
    @LogRequest(module="monitor_center_module", object="event_center_record", opType="common_op_export", opContent="common_op_export")
    public void export(HttpServletRequest request, HttpServletResponse response) {
        EventRecordItem recordItem = new EventRecordItem();
        this.setConditionValue((BaseItem)recordItem);
        List itemList = this.eventRecordService.exportItemListByAuthFilter(request.getSession().getId(), EventRecordItem.class, recordItem, this.getBeginIndex(), this.getEndIndex());
        this.excelExport(itemList, EventRecordItem.class);
    }
}

