/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.event.center.controller;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.event.center.remote.EventLevelRemote;
import com.zkteco.zkbiosecurity.event.center.service.EventLevelService;
import com.zkteco.zkbiosecurity.event.center.vo.EventLevelItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class EventLevelController
extends BaseController
implements EventLevelRemote {
    @Autowired
    private EventLevelService eventLevelService;

    @RequiresPermissions(value={"event:center:level"})
    public ModelAndView index() {
        return new ModelAndView("eventCenter/level/eventLevel");
    }

    @RequiresPermissions(value={"event:center:level:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.eventLevelService.getItemById(id));
        }
        return new ModelAndView("eventCenter/level/editEventLevel");
    }

    @RequiresPermissions(value={"event:center:level:edit"})
    public ZKResultMsg save(EventLevelItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.eventLevelService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"event:center:level:refresh"})
    public DxGrid list(EventLevelItem condition) {
        Pager pager = this.eventLevelService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"event:center:level:del"})
    public ZKResultMsg delete(String ids) {
        String isInitLevel;
        ZKResultMsg resultMsg = new ZKResultMsg();
        String msg = "";
        JSONObject delResult = this.eventLevelService.deleteEventLevel(ids);
        String inUseLevel = delResult.getString("inUseLevel");
        if (StringUtils.isNotBlank((CharSequence)inUseLevel)) {
            msg = msg + String.format(I18nUtil.i18nCode((String)"event_level_isInUse", (Object[])new Object[0]), inUseLevel);
        }
        if (StringUtils.isNotBlank((CharSequence)(isInitLevel = delResult.getString("isInitLevel")))) {
            msg = msg + String.format(I18nUtil.i18nCode((String)"event_level_isInit", (Object[])new Object[0]), isInitLevel);
        }
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            resultMsg.setMsg(msg);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }

    public Boolean validName(String levelName) {
        EventLevelItem eventLevelItem;
        boolean isNameExist = true;
        if (StringUtils.isNotBlank((CharSequence)levelName) && Objects.nonNull(eventLevelItem = this.eventLevelService.getItemByLevelName(levelName))) {
            isNameExist = false;
        }
        return isNameExist;
    }

    public Boolean validLevelVal(String levelVal) {
        EventLevelItem eventLevelItem;
        boolean isValExist = true;
        if (StringUtils.isNotBlank((CharSequence)levelVal) && Objects.nonNull(eventLevelItem = this.eventLevelService.getItemByLevelVal(levelVal))) {
            isValExist = false;
        }
        return isValExist;
    }

    public ZKResultMsg getEventLeaveTree() {
        return this.eventLevelService.getEventLeaveTree();
    }
}

