/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.event.center.app.controller;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.base.vo.AppResultMessage;
import com.zkteco.zkbiosecurity.event.center.service.EventCenterAppService;
import com.zkteco.zkbiosecurity.event.center.service.EventRecordService;
import com.zkteco.zkbiosecurity.event.center.vo.EventRecordItem;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@RestController
@ApiIgnore
@RequestMapping(value={"/app/v1/eventCenter"})
public class EventCenterAppController {
    @Autowired
    private EventRecordService eventRecordService;
    @Autowired
    private EventCenterAppService eventRecordAppService;
    @Autowired
    protected HttpServletRequest request;

    @RequestMapping(value={"/eventRecordCount"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public AppResultMessage eventRecordCount(@RequestBody JSONObject data) {
        String userName = this.request.getParameter("user_name");
        String startTimeStr = data.getString("startTime");
        String endTimeStr = data.getString("endTime");
        String levels = data.getString("levels");
        String modules = data.getString("modules");
        return this.eventRecordAppService.eventRecordCount(userName, startTimeStr, endTimeStr, levels, modules);
    }

    @RequestMapping(value={"/getEventRecordList"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public AppResultMessage getEventRecordList(@RequestBody JSONObject data) {
        String userName = this.request.getParameter("user_name");
        String startTimeStr = data.getString("startTime");
        String endTimeStr = data.getString("endTime");
        String levels = data.getString("levels");
        String modules = data.getString("modules");
        String processState = data.getString("processState");
        String filters = data.getString("filters");
        int pageNo = data.containsKey((Object)"pageNo") ? data.getIntValue("pageNo") : 1;
        int pageSize = data.containsKey((Object)"pageSize") ? data.getIntValue("pageSize") : 20;
        return this.eventRecordAppService.getEventRecordList(userName, startTimeStr, endTimeStr, levels, modules, processState, filters, pageNo - 1, pageSize);
    }

    @RequestMapping(value={"/affirmEventLog"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public AppResultMessage affirmEventLog(@RequestBody JSONObject data) {
        AppResultMessage zkResultMsg = AppResultMessage.successMessage();
        String id = data.getString("id");
        String eventRemark = data.getString("eventRemark");
        this.eventRecordService.affirmEventLog(id, eventRemark, this.request.getParameter("user_name"));
        return zkResultMsg;
    }

    @RequestMapping(value={"/getEventDetailsById"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public AppResultMessage getEventDetailsById(@RequestBody JSONObject data) {
        AppResultMessage zkResultMsg = AppResultMessage.successMessage();
        String id = data.getString("id");
        if (StringUtils.isNotBlank((CharSequence)id)) {
            EventRecordItem item = this.eventRecordService.getItemById(id);
            zkResultMsg.setData((Object)item);
        }
        return zkResultMsg;
    }
}

