/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.event.center.api.controller;

import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.FileEncryptUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.event.center.service.EventRecordService;
import com.zkteco.zkbiosecurity.event.center.vo.EventRecordItem;
import com.zkteco.zkbiosecurity.message.bean.ZKMessage;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/eventCenter"})
public class EventCenterApiController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(EventCenterApiController.class);
    @Autowired
    private EventRecordService eventRecordService;

    @RequestMapping(value={"/getEventDetailsById"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public ZKResultMsg getEventDetailsById(@RequestBody ZKMessage message) {
        EventRecordItem item;
        ZKResultMsg zkResultMsg = new ZKResultMsg();
        Map content = message.getContent();
        if (Objects.nonNull(content) && Objects.nonNull(item = this.eventRecordService.getItemById(MapUtils.getString((Map)content, (Object)"id")))) {
            String sourceModule;
            String decryptFileBase64;
            String captureImgURL = item.getCaptureImgURL();
            if (StringUtils.isNotBlank((CharSequence)captureImgURL) && StringUtils.isNotBlank((CharSequence)(decryptFileBase64 = FileEncryptUtil.getDecryptFileBase64((String)captureImgURL)))) {
                item.setCaptureImgURL(decryptFileBase64);
            }
            if (StringUtils.isNotBlank((CharSequence)(sourceModule = item.getSourceModule()))) {
                item.setSourceModule(I18nUtil.i18nCode((String)(sourceModule + "_module"), (Object[])new Object[0]));
            }
            zkResultMsg.setData((Object)item);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)zkResultMsg);
    }

    @RequestMapping(value={"/affirmEventLog"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public ZKResultMsg affirmEventLog(@RequestBody ZKMessage message) {
        ZKResultMsg zkResultMsg = new ZKResultMsg();
        Map content = message.getContent();
        if (Objects.nonNull(content)) {
            this.eventRecordService.affirmEventLog(MapUtils.getString((Map)content, (Object)"id"), MapUtils.getString((Map)content, (Object)"eventRemark"));
        }
        return I18nUtil.i18nMsg((ZKResultMsg)zkResultMsg);
    }
}

