/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.device.center.controller;

import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.device.center.remote.DeviceSubsetInfoRemote;
import com.zkteco.zkbiosecurity.device.center.service.DeviceSubsetInfoService;
import com.zkteco.zkbiosecurity.device.center.vo.DeviceSubsetInfoItem;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class DeviceSubsetInfoController
extends BaseController
implements DeviceSubsetInfoRemote {
    @Autowired
    private DeviceSubsetInfoService deviceSubsetInfoService;

    public ModelAndView toDeviceSubsetInfo(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("deviceInfoId", (Object)id);
        }
        return new ModelAndView("deviceCenter/deviceSubsetInfo");
    }

    public DxGrid list(DeviceSubsetInfoItem condition) {
        Pager pager = this.deviceSubsetInfoService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        List deviceSubsetInfoItems = pager.getData();
        for (DeviceSubsetInfoItem deviceSubsetInfoItem : deviceSubsetInfoItems) {
            deviceSubsetInfoItem.setSubsetType(I18nUtil.i18nCode((String)("device_subset_" + deviceSubsetInfoItem.getSubsetType()), (Object[])new Object[0]));
        }
        return GridUtil.convert((Pager)pager, condition.getClass());
    }
}

