/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.device.center.controller;

import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.device.center.remote.DeviceCenterManagerRemote;
import com.zkteco.zkbiosecurity.device.center.service.DeviceCenterManagerService;
import com.zkteco.zkbiosecurity.device.center.service.DeviceSubsetInfoService;
import com.zkteco.zkbiosecurity.device.center.vo.DeviceInfoItem;
import com.zkteco.zkbiosecurity.device.center.vo.DeviceSubsetInfoItem;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class DeviceCenterManagerController
extends BaseController
implements DeviceCenterManagerRemote {
    @Autowired
    private DeviceCenterManagerService deviceCenterManagerService;
    @Autowired
    private DeviceSubsetInfoService deviceSubsetInfoService;

    public ModelAndView index() {
        return new ModelAndView("deviceCenter/deviceCenterManager");
    }

    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.deviceCenterManagerService.getItemById(id));
        }
        return null;
    }

    public ZKResultMsg save(DeviceInfoItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.deviceCenterManagerService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    public DxGrid list(DeviceInfoItem condition) {
        Pager pager = this.deviceCenterManagerService.getItemsByPageAndAreaIds(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        List deviceInfoItems = pager.getData();
        for (DeviceInfoItem deviceInfoItem : deviceInfoItems) {
            deviceInfoItem.setSourceModule(I18nUtil.i18nCode((String)(deviceInfoItem.getSourceModule() + "_module"), (Object[])new Object[0]));
        }
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public DxGrid subsetInfoList(DeviceSubsetInfoItem condition) {
        Pager pager = this.deviceSubsetInfoService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public ZKResultMsg delete(String ids) {
        ZKResultMsg retMsg = new ZKResultMsg();
        this.deviceCenterManagerService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)retMsg);
    }

    public ZKResultMsg synDeviceCenterDev() {
        return this.deviceCenterManagerService.synDeviceCenterDev();
    }
}

